/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.LogCatLogger;
import com.adjust.sdk.Logger;
import com.adjust.sdk.PackageHandler;
import com.adjust.sdk.RequestHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;

public class AdjustFactory {
    private static IPackageHandler packageHandler = null;
    private static IRequestHandler requestHandler = null;
    private static Logger logger = null;
    private static HttpClient httpClient = null;
    private static long timerInterval = -1L;
    private static long sessionInterval = -1L;
    private static long subsessionInterval = -1L;

    public static IPackageHandler getPackageHandler(ActivityHandler activityHandler, Context context, boolean dropOfflineActivities) {
        if (packageHandler == null) {
            return new PackageHandler(activityHandler, context, dropOfflineActivities);
        }
        return packageHandler;
    }

    public static IRequestHandler getRequestHandler(IPackageHandler packageHandler) {
        if (requestHandler == null) {
            return new RequestHandler(packageHandler);
        }
        return requestHandler;
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = new LogCatLogger();
        }
        return logger;
    }

    public static HttpClient getHttpClient(HttpParams params) {
        if (httpClient == null) {
            return new DefaultHttpClient(params);
        }
        return httpClient;
    }

    public static long getTimerInterval() {
        if (timerInterval == -1L) {
            return 60000L;
        }
        return timerInterval;
    }

    public static long getSessionInterval() {
        if (sessionInterval == -1L) {
            return 1800000L;
        }
        return sessionInterval;
    }

    public static long getSubsessionInterval() {
        if (subsessionInterval == -1L) {
            return 1000L;
        }
        return subsessionInterval;
    }

    public static void setPackageHandler(IPackageHandler packageHandler) {
        AdjustFactory.packageHandler = packageHandler;
    }

    public static void setRequestHandler(IRequestHandler requestHandler) {
        AdjustFactory.requestHandler = requestHandler;
    }

    public static void setLogger(Logger logger) {
        AdjustFactory.logger = logger;
    }

    public static void setHttpClient(HttpClient httpClient) {
        AdjustFactory.httpClient = httpClient;
    }

    public static void setTimerInterval(long timerInterval) {
        AdjustFactory.timerInterval = timerInterval;
    }

    public static void setSessionInterval(long sessionInterval) {
        AdjustFactory.sessionInterval = sessionInterval;
    }

    public static void setSubsessionInterval(long subsessionInterval) {
        AdjustFactory.subsessionInterval = subsessionInterval;
    }
}

