/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.util.Log;
import com.adjust.sdk.Logger;
import java.util.Locale;

public class LogCatLogger
implements Logger {
    private Logger.LogLevel logLevel;

    public LogCatLogger() {
        this.setLogLevel(Logger.LogLevel.INFO);
    }

    @Override
    public void setLogLevel(Logger.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void setLogLevelString(String logLevelString) {
        if (null != logLevelString) {
            try {
                this.setLogLevel(Logger.LogLevel.valueOf(logLevelString.toUpperCase(Locale.US)));
            }
            catch (IllegalArgumentException iae) {
                this.error(String.format("Malformed logLevel '%s', falling back to 'info'", logLevelString));
            }
        }
    }

    @Override
    public void verbose(String message) {
        if (this.logLevel.androidLogLevel <= 2) {
            Log.v((String)"Adjust", (String)message);
        }
    }

    @Override
    public void debug(String message) {
        if (this.logLevel.androidLogLevel <= 3) {
            Log.d((String)"Adjust", (String)message);
        }
    }

    @Override
    public void info(String message) {
        if (this.logLevel.androidLogLevel <= 4) {
            Log.i((String)"Adjust", (String)message);
        }
    }

    @Override
    public void warn(String message) {
        if (this.logLevel.androidLogLevel <= 5) {
            Log.w((String)"Adjust", (String)message);
        }
    }

    @Override
    public void error(String message) {
        if (this.logLevel.androidLogLevel <= 6) {
            Log.e((String)"Adjust", (String)message);
        }
    }

    @Override
    public void Assert(String message) {
        Log.println((int)7, (String)"Adjust", (String)message);
    }
}

