/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IRequestHandler;
import com.adjust.sdk.Logger;
import com.adjust.sdk.ResponseData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public class PackageHandler
extends HandlerThread
implements IPackageHandler {
    private static final String PACKAGE_QUEUE_FILENAME = "AdjustIoPackageQueue";
    private final InternalHandler internalHandler;
    private IRequestHandler requestHandler;
    private ActivityHandler activityHandler;
    private List<ActivityPackage> packageQueue;
    private AtomicBoolean isSending;
    private boolean paused;
    private Context context;
    private boolean dropOfflineActivities;
    private Logger logger;

    public PackageHandler(ActivityHandler activityHandler, Context context, boolean dropOfflineActivities) {
        super("Adjust", 1);
        this.setDaemon(true);
        this.start();
        this.internalHandler = new InternalHandler(this.getLooper(), this);
        this.logger = AdjustFactory.getLogger();
        this.activityHandler = activityHandler;
        this.context = context;
        this.dropOfflineActivities = dropOfflineActivities;
        Message message = Message.obtain();
        message.arg1 = 1;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void addPackage(ActivityPackage pack) {
        Message message = Message.obtain();
        message.arg1 = 2;
        message.obj = pack;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void sendFirstPackage() {
        Message message = Message.obtain();
        message.arg1 = 4;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void sendNextPackage() {
        Message message = Message.obtain();
        message.arg1 = 3;
        this.internalHandler.sendMessage(message);
    }

    @Override
    public void closeFirstPackage() {
        if (this.dropOfflineActivities) {
            this.sendNextPackage();
        } else {
            this.isSending.set(false);
        }
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
    }

    @Override
    public String getFailureMessage() {
        if (this.dropOfflineActivities) {
            return "Dropping offline activity.";
        }
        return "Will retry later.";
    }

    @Override
    public boolean dropsOfflineActivities() {
        return this.dropOfflineActivities;
    }

    @Override
    public void finishedTrackingActivity(ActivityPackage activityPackage, ResponseData responseData) {
        responseData.setActivityKind(activityPackage.getActivityKind());
        this.activityHandler.finishedTrackingActivity(responseData);
    }

    private void initInternal() {
        this.requestHandler = AdjustFactory.getRequestHandler(this);
        this.isSending = new AtomicBoolean();
        this.readPackageQueue();
    }

    private void addInternal(ActivityPackage newPackage) {
        this.packageQueue.add(newPackage);
        this.logger.debug(String.format(Locale.US, "Added package %d (%s)", this.packageQueue.size(), newPackage));
        this.logger.verbose(newPackage.getExtendedString());
        this.writePackageQueue();
    }

    private void sendFirstInternal() {
        if (this.packageQueue.isEmpty()) {
            return;
        }
        if (this.paused) {
            this.logger.debug("Package handler is paused");
            return;
        }
        if (this.isSending.getAndSet(true)) {
            this.logger.verbose("Package handler is already sending");
            return;
        }
        ActivityPackage firstPackage = this.packageQueue.get(0);
        this.requestHandler.sendPackage(firstPackage);
    }

    private void sendNextInternal() {
        this.packageQueue.remove(0);
        this.writePackageQueue();
        this.isSending.set(false);
        this.sendFirstInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPackageQueue() {
        if (this.dropOfflineActivities) {
            this.packageQueue = new ArrayList<ActivityPackage>();
            return;
        }
        try {
            FileInputStream inputStream = this.context.openFileInput(PACKAGE_QUEUE_FILENAME);
            BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
            ObjectInputStream objectStream = new ObjectInputStream(bufferedStream);
            try {
                Object object = objectStream.readObject();
                List packageQueue = (List)object;
                this.logger.debug(String.format(Locale.US, "Package handler read %d packages", packageQueue.size()));
                this.packageQueue = packageQueue;
                return;
            }
            catch (ClassNotFoundException e) {
                this.logger.error("Failed to find package queue class");
            }
            catch (OptionalDataException e) {
            }
            catch (IOException e) {
                this.logger.error("Failed to read package queue object");
            }
            catch (ClassCastException e) {
                this.logger.error("Failed to cast package queue object");
            }
            finally {
                objectStream.close();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.verbose("Package queue file not found");
        }
        catch (Exception e) {
            this.logger.error("Failed to read package queue file");
        }
        this.packageQueue = new ArrayList<ActivityPackage>();
    }

    public static Boolean deletePackageQueue(Context context) {
        return context.deleteFile(PACKAGE_QUEUE_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackageQueue() {
        if (this.dropOfflineActivities) {
            return;
        }
        try {
            FileOutputStream outputStream = this.context.openFileOutput(PACKAGE_QUEUE_FILENAME, 0);
            BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
            ObjectOutputStream objectStream = new ObjectOutputStream(bufferedStream);
            try {
                objectStream.writeObject(this.packageQueue);
                this.logger.debug(String.format(Locale.US, "Package handler wrote %d packages", this.packageQueue.size()));
            }
            catch (NotSerializableException e) {
                this.logger.error("Failed to serialize packages");
            }
            finally {
                objectStream.close();
            }
        }
        catch (Exception e) {
            this.logger.error(String.format("Failed to write packages (%s)", e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private static final class InternalHandler
    extends Handler {
        private static final int INIT = 1;
        private static final int ADD = 2;
        private static final int SEND_NEXT = 3;
        private static final int SEND_FIRST = 4;
        private final WeakReference<PackageHandler> packageHandlerReference;

        protected InternalHandler(Looper looper, PackageHandler packageHandler) {
            super(looper);
            this.packageHandlerReference = new WeakReference<PackageHandler>(packageHandler);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            PackageHandler packageHandler = (PackageHandler)this.packageHandlerReference.get();
            if (null == packageHandler) {
                return;
            }
            switch (message.arg1) {
                case 1: {
                    packageHandler.initInternal();
                    break;
                }
                case 2: {
                    ActivityPackage activityPackage = (ActivityPackage)message.obj;
                    packageHandler.addInternal(activityPackage);
                    break;
                }
                case 4: {
                    packageHandler.sendFirstInternal();
                    break;
                }
                case 3: {
                    packageHandler.sendNextInternal();
                }
            }
        }
    }
}

