/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static SimpleDateFormat dateFormat;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'Z";

    protected static String getUserAgent(Context context) {
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Configuration configuration = resources.getConfiguration();
        Locale locale = configuration.locale;
        int screenLayout = configuration.screenLayout;
        Object[] parts = new String[]{Util.getPackageName(context), Util.getAppVersion(context), Util.getDeviceType(screenLayout), Util.getDeviceName(), Util.getOsName(), Util.getOsVersion(), Util.getLanguage(locale), Util.getCountry(locale), Util.getScreenSize(screenLayout), Util.getScreenFormat(screenLayout), Util.getScreenDensity(displayMetrics), Util.getDisplayWidth(displayMetrics), Util.getDisplayHeight(displayMetrics)};
        return TextUtils.join((CharSequence)" ", (Object[])parts);
    }

    private static String getPackageName(Context context) {
        String packageName = context.getPackageName();
        return Util.sanitizeString(packageName);
    }

    private static String getAppVersion(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            String name = context.getPackageName();
            PackageInfo info = packageManager.getPackageInfo(name, 0);
            String versionName = info.versionName;
            return Util.sanitizeString(versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            return "unknown";
        }
    }

    private static String getDeviceType(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: 
            case 2: {
                return "phone";
            }
            case 3: 
            case 4: {
                return "tablet";
            }
        }
        return "unknown";
    }

    private static String getDeviceName() {
        String deviceName = Build.MODEL;
        return Util.sanitizeString(deviceName);
    }

    private static String getOsName() {
        return "android";
    }

    private static String getOsVersion() {
        String osVersion = "" + Build.VERSION.SDK_INT;
        return Util.sanitizeString(osVersion);
    }

    private static String getLanguage(Locale locale) {
        String language = locale.getLanguage();
        return Util.sanitizeStringShort(language);
    }

    private static String getCountry(Locale locale) {
        String country = locale.getCountry();
        return Util.sanitizeStringShort(country);
    }

    private static String getScreenSize(int screenLayout) {
        int screenSize = screenLayout & 0xF;
        switch (screenSize) {
            case 1: {
                return "small";
            }
            case 2: {
                return "normal";
            }
            case 3: {
                return "large";
            }
            case 4: {
                return "xlarge";
            }
        }
        return "unknown";
    }

    private static String getScreenFormat(int screenLayout) {
        int screenFormat = screenLayout & 0x30;
        switch (screenFormat) {
            case 32: {
                return "long";
            }
            case 16: {
                return "normal";
            }
        }
        return "unknown";
    }

    private static String getScreenDensity(DisplayMetrics displayMetrics) {
        int density = displayMetrics.densityDpi;
        int low = 140;
        int high = 200;
        if (0 == density) {
            return "unknown";
        }
        if (density < 140) {
            return "low";
        }
        if (density > 200) {
            return "high";
        }
        return "medium";
    }

    private static String getDisplayWidth(DisplayMetrics displayMetrics) {
        String displayWidth = String.valueOf(displayMetrics.widthPixels);
        return Util.sanitizeString(displayWidth);
    }

    private static String getDisplayHeight(DisplayMetrics displayMetrics) {
        String displayHeight = String.valueOf(displayMetrics.heightPixels);
        return Util.sanitizeString(displayHeight);
    }

    protected static String createUuid() {
        return UUID.randomUUID().toString();
    }

    protected static String getMacAddress(Context context) {
        String rawAddress = Util.getRawMacAddress(context);
        String upperAddress = rawAddress.toUpperCase(Locale.US);
        return Util.sanitizeString(upperAddress);
    }

    private static String getRawMacAddress(Context context) {
        String wlanAddress = Util.loadAddress("wlan0");
        if (wlanAddress != null) {
            return wlanAddress;
        }
        String ethAddress = Util.loadAddress("eth0");
        if (ethAddress != null) {
            return ethAddress;
        }
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            String wifiAddress = wifiManager.getConnectionInfo().getMacAddress();
            if (wifiAddress != null) {
                return wifiAddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static String sanitizeString(String string) {
        return Util.sanitizeString(string, "unknown");
    }

    private static String sanitizeStringShort(String string) {
        return Util.sanitizeString(string, "zz");
    }

    private static String sanitizeString(String string, String defaultString) {
        String result = string;
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = defaultString;
        }
        if (TextUtils.isEmpty((CharSequence)(result = result.replaceAll("\\s", "")))) {
            result = defaultString;
        }
        return result;
    }

    protected static String loadAddress(String interfaceName) {
        try {
            int numRead;
            String filePath = "/sys/class/net/" + interfaceName + "/address";
            StringBuilder fileData = new StringBuilder(1000);
            BufferedReader reader = new BufferedReader(new FileReader(filePath), 1024);
            char[] buf = new char[1024];
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
            reader.close();
            return fileData.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    protected static String getAttributionId(Context context) {
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
            String columnName = "aid";
            String[] projection = new String[]{"aid"};
            Cursor cursor = contentResolver.query(uri, projection, null, null, null);
            if (null == cursor) {
                return null;
            }
            if (!cursor.moveToFirst()) {
                cursor.close();
                return null;
            }
            String attributionId = cursor.getString(cursor.getColumnIndex("aid"));
            cursor.close();
            return attributionId;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static String sha1(String text) {
        return Util.hash(text, "SHA-1");
    }

    protected static String md5(String text) {
        return Util.hash(text, "MD5");
    }

    private static String hash(String text, String method) {
        try {
            byte[] bytes = text.getBytes("UTF-8");
            MessageDigest mesd = MessageDigest.getInstance(method);
            mesd.update(bytes, 0, bytes.length);
            byte[] hash = mesd.digest();
            return Util.convertToHex(hash);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String convertToHex(byte[] bytes) {
        BigInteger bigInt = new BigInteger(1, bytes);
        String formatString = "%0" + (bytes.length << 1) + "x";
        return String.format(formatString, bigInt);
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        return String.format("'%s'", string);
    }

    public static String dateFormat(long date) {
        if (null == dateFormat) {
            dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        }
        return dateFormat.format(date);
    }

    public static String getGpsAdid(Context context) {
        try {
            Class<?> AdvertisingIdClientClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            Class[] cArg = new Class[]{Context.class};
            Method getAdvertisingInfoMethod = AdvertisingIdClientClass.getMethod("getAdvertisingIdInfo", cArg);
            Object AdvertisingInfoObject = getAdvertisingInfoMethod.invoke(null, context);
            Class<?> AdvertisingInfoClass = AdvertisingInfoObject.getClass();
            Method isLimitedTrackingEnabledMethod = AdvertisingInfoClass.getMethod("isLimitAdTrackingEnabled", new Class[0]);
            Object isLimitedTrackingEnabledObject = isLimitedTrackingEnabledMethod.invoke(AdvertisingInfoObject, new Object[0]);
            Boolean isLimitedTrackingEnabled = (Boolean)isLimitedTrackingEnabledObject;
            if (!isLimitedTrackingEnabled.booleanValue()) {
                Method getIdMethod = AdvertisingInfoClass.getMethod("getId", new Class[0]);
                Object getIdObject = getIdMethod.invoke(AdvertisingInfoObject, new Object[0]);
                String gpsAdid = (String)getIdObject;
            }
        }
        catch (Exception e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }
}

