/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.exif;

import android.util.Log;
import com.android.mms.exif.ExifData;
import com.android.mms.exif.ExifInterface;
import com.android.mms.exif.ExifInvalidFormatException;
import com.android.mms.exif.ExifParser;
import com.android.mms.exif.ExifTag;
import com.android.mms.exif.IfdData;
import java.io.IOException;
import java.io.InputStream;

class ExifReader {
    private static final String TAG = "ExifReader";
    private final ExifInterface mInterface;

    ExifReader(ExifInterface iRef) {
        this.mInterface = iRef;
    }

    protected ExifData read(InputStream inputStream) throws ExifInvalidFormatException, IOException {
        ExifParser parser = ExifParser.parse(inputStream, this.mInterface);
        ExifData exifData = new ExifData(parser.getByteOrder());
        ExifTag tag = null;
        int event = parser.next();
        while (event != 5) {
            switch (event) {
                case 0: {
                    exifData.addIfdData(new IfdData(parser.getCurrentIfd()));
                    break;
                }
                case 1: {
                    tag = parser.getTag();
                    if (!tag.hasValue()) {
                        parser.registerForTagValue(tag);
                        break;
                    }
                    exifData.getIfdData(tag.getIfd()).setTag(tag);
                    break;
                }
                case 2: {
                    tag = parser.getTag();
                    if (tag.getDataType() == 7) {
                        parser.readFullTagValue(tag);
                    }
                    exifData.getIfdData(tag.getIfd()).setTag(tag);
                    break;
                }
                case 3: {
                    byte[] buf = new byte[parser.getCompressedImageSize()];
                    if (buf.length == parser.read(buf)) {
                        exifData.setCompressedThumbnail(buf);
                        break;
                    }
                    Log.w((String)TAG, (String)"Failed to read the compressed thumbnail");
                    break;
                }
                case 4: {
                    byte[] buf = new byte[parser.getStripSize()];
                    if (buf.length == parser.read(buf)) {
                        exifData.setStripBytes(parser.getStripIndex(), buf);
                        break;
                    }
                    Log.w((String)TAG, (String)"Failed to read the strip bytes");
                }
            }
            event = parser.next();
        }
        return exifData;
    }
}

