/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import com.dropbox.client2.ProgressListener;
import com.dropbox.client2.RESTUtility;
import com.dropbox.client2.SdkVersion;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.exception.DropboxIOException;
import com.dropbox.client2.exception.DropboxLocalStorageFullException;
import com.dropbox.client2.exception.DropboxParseException;
import com.dropbox.client2.exception.DropboxPartialFileException;
import com.dropbox.client2.exception.DropboxServerException;
import com.dropbox.client2.exception.DropboxUnlinkedException;
import com.dropbox.client2.jsonextract.JsonExtractionException;
import com.dropbox.client2.jsonextract.JsonExtractor;
import com.dropbox.client2.jsonextract.JsonList;
import com.dropbox.client2.jsonextract.JsonMap;
import com.dropbox.client2.jsonextract.JsonThing;
import com.dropbox.client2.session.Session;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropboxAPI<SESS_T extends Session> {
    public static final int VERSION = 1;
    public static final String SDK_VERSION = SdkVersion.get();
    public static final long MAX_UPLOAD_SIZE = 0xB400000L;
    protected static final int METADATA_DEFAULT_LIMIT = 25000;
    private static final int REVISION_DEFAULT_LIMIT = 1000;
    private static final int SEARCH_DEFAULT_LIMIT = 10000;
    private static final int UPLOAD_SO_TIMEOUT_MS = 180000;
    protected final SESS_T session;

    public DropboxAPI(SESS_T session) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        this.session = session;
    }

    public ChunkedUploader getChunkedUploader(InputStream is, long length) {
        return new ChunkedUploader(is, length);
    }

    public ChunkedUploader getChunkedUploader(InputStream is, long length, int chunkSize) {
        return new ChunkedUploader(is, length, chunkSize);
    }

    public ChunkedUploadRequest chunkedUploadRequest(InputStream is, long length, ProgressListener listener, long offset, String uploadId) {
        String[] params = offset == 0L ? new String[]{} : new String[]{"upload_id", uploadId, "offset", "" + offset};
        String url = RESTUtility.buildURL(this.session.getContentServer(), 1, "/chunked_upload/", params);
        HttpPut req = new HttpPut(url);
        this.session.sign((HttpRequest)req);
        InputStreamEntity ise = new InputStreamEntity(is, length);
        ise.setContentEncoding("application/octet-stream");
        ise.setChunked(false);
        Object entity = ise;
        if (listener != null) {
            entity = new ProgressListener.ProgressHttpEntity((HttpEntity)entity, listener);
        }
        req.setEntity((HttpEntity)entity);
        return new ChunkedUploadRequest((HttpUriRequest)req, (Session)this.session);
    }

    public SESS_T getSession() {
        return this.session;
    }

    public Account accountInfo() throws DropboxException {
        this.assertAuthenticated();
        Map accountInfo = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), "/account/info", 1, new String[]{"locale", this.session.getLocale().toString()}, this.session);
        return new Account(accountInfo);
    }

    public DropboxFileInfo getFile(String path, String rev, OutputStream os, ProgressListener listener) throws DropboxException {
        DropboxInputStream dis = this.getFileStream(path, rev);
        dis.copyStreamToOutput(os, listener);
        return dis.getFileInfo();
    }

    public DropboxInputStream getFileStream(String path, String rev) throws DropboxException {
        this.assertAuthenticated();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String url = "/files/" + (Object)((Object)this.session.getAccessType()) + path;
        String[] args = new String[]{"rev", rev, "locale", this.session.getLocale().toString()};
        String target = RESTUtility.buildURL(this.session.getContentServer(), 1, url, args);
        HttpGet req = new HttpGet(target);
        this.session.sign((HttpRequest)req);
        HttpResponse response = RESTUtility.execute(this.session, (HttpUriRequest)req);
        return new DropboxInputStream((HttpUriRequest)req, response);
    }

    public Entry putFile(String path, InputStream is, long length, String parentRev, ProgressListener listener) throws DropboxException {
        UploadRequest request = this.putFileRequest(path, is, length, parentRev, listener);
        return request.upload();
    }

    public UploadRequest putFileRequest(String path, InputStream is, long length, String parentRev, ProgressListener listener) throws DropboxException {
        return this.putFileRequest(path, is, length, false, parentRev, listener);
    }

    public Entry putFileOverwrite(String path, InputStream is, long length, ProgressListener listener) throws DropboxException {
        UploadRequest request = this.putFileOverwriteRequest(path, is, length, listener);
        return request.upload();
    }

    public UploadRequest putFileOverwriteRequest(String path, InputStream is, long length, ProgressListener listener) throws DropboxException {
        return this.putFileRequest(path, is, length, true, null, listener);
    }

    public DropboxFileInfo getThumbnail(String path, OutputStream os, ThumbSize size, ThumbFormat format, ProgressListener listener) throws DropboxException {
        DropboxInputStream thumb = this.getThumbnailStream(path, size, format);
        thumb.copyStreamToOutput(os, listener);
        return thumb.getFileInfo();
    }

    public DropboxInputStream getThumbnailStream(String path, ThumbSize size, ThumbFormat format) throws DropboxException {
        this.assertAuthenticated();
        String target = "/thumbnails/" + (Object)((Object)this.session.getAccessType()) + path;
        String[] params = new String[]{"size", size.toAPISize(), "format", format.toString(), "locale", this.session.getLocale().toString()};
        RequestAndResponse rr = RESTUtility.streamRequest(RESTUtility.RequestMethod.GET, this.session.getContentServer(), target, 1, params, this.session);
        return new DropboxInputStream(rr.request, rr.response);
    }

    public Entry metadata(String path, int fileLimit, String hash, boolean list, String rev) throws DropboxException {
        this.assertAuthenticated();
        if (fileLimit <= 0) {
            fileLimit = 25000;
        }
        String[] params = new String[]{"file_limit", String.valueOf(fileLimit), "hash", hash, "list", String.valueOf(list), "rev", rev, "locale", this.session.getLocale().toString()};
        String url_path = "/metadata/" + (Object)((Object)this.session.getAccessType()) + path;
        Map dirinfo = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), url_path, 1, params, this.session);
        return new Entry(dirinfo);
    }

    public List<Entry> revisions(String path, int revLimit) throws DropboxException {
        this.assertAuthenticated();
        if (revLimit <= 0) {
            revLimit = 1000;
        }
        String[] params = new String[]{"rev_limit", String.valueOf(revLimit), "locale", this.session.getLocale().toString()};
        String url_path = "/revisions/" + (Object)((Object)this.session.getAccessType()) + path;
        JSONArray revs = (JSONArray)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), url_path, 1, params, this.session);
        LinkedList<Entry> entries = new LinkedList<Entry>();
        for (Object metadata : revs) {
            entries.add(new Entry((Map)metadata));
        }
        return entries;
    }

    public List<Entry> search(String path, String query, int fileLimit, boolean includeDeleted) throws DropboxException {
        this.assertAuthenticated();
        if (fileLimit <= 0) {
            fileLimit = 10000;
        }
        String target = "/search/" + (Object)((Object)this.session.getAccessType()) + path;
        String[] params = new String[]{"query", query, "file_limit", String.valueOf(fileLimit), "include_deleted", String.valueOf(includeDeleted), "locale", this.session.getLocale().toString()};
        Object response = RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), target, 1, params, this.session);
        ArrayList<Entry> ret = new ArrayList<Entry>();
        if (response instanceof JSONArray) {
            JSONArray jresp = (JSONArray)response;
            for (Object next : jresp) {
                if (!(next instanceof Map)) continue;
                Entry ent = new Entry((Map)next);
                ret.add(ent);
            }
        }
        return ret;
    }

    public Entry move(String fromPath, String toPath) throws DropboxException {
        this.assertAuthenticated();
        String[] params = new String[]{"root", this.session.getAccessType().toString(), "from_path", fromPath, "to_path", toPath, "locale", this.session.getLocale().toString()};
        Map resp = (Map)RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/fileops/move", 1, params, this.session);
        return new Entry(resp);
    }

    public Entry copy(String fromPath, String toPath) throws DropboxException {
        this.assertAuthenticated();
        String[] params = new String[]{"root", this.session.getAccessType().toString(), "from_path", fromPath, "to_path", toPath, "locale", this.session.getLocale().toString()};
        Map resp = (Map)RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/fileops/copy", 1, params, this.session);
        return new Entry(resp);
    }

    public Entry createFolder(String path) throws DropboxException {
        this.assertAuthenticated();
        String[] params = new String[]{"root", this.session.getAccessType().toString(), "path", path, "locale", this.session.getLocale().toString()};
        Map resp = (Map)RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/fileops/create_folder", 1, params, this.session);
        return new Entry(resp);
    }

    public void delete(String path) throws DropboxException {
        this.assertAuthenticated();
        String[] params = new String[]{"root", this.session.getAccessType().toString(), "path", path, "locale", this.session.getLocale().toString()};
        RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/fileops/delete", 1, params, this.session);
    }

    public Entry restore(String path, String rev) throws DropboxException {
        this.assertAuthenticated();
        String[] params = new String[]{"rev", rev, "locale", this.session.getLocale().toString()};
        String target = "/restore/" + (Object)((Object)this.session.getAccessType()) + path;
        Map metadata = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), target, 1, params, this.session);
        return new Entry(metadata);
    }

    public DropboxLink media(String path, boolean ssl) throws DropboxException {
        this.assertAuthenticated();
        String target = "/media/" + (Object)((Object)this.session.getAccessType()) + path;
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), target, 1, new String[]{"locale", this.session.getLocale().toString()}, this.session);
        return new DropboxLink(map, ssl);
    }

    public DropboxLink share(String path) throws DropboxException {
        this.assertAuthenticated();
        String target = "/shares/" + (Object)((Object)this.session.getAccessType()) + path;
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), target, 1, new String[]{"locale", this.session.getLocale().toString()}, this.session);
        String url = (String)map.get("url");
        Date expires = RESTUtility.parseDate((String)map.get("expires"));
        if (url == null || expires == null) {
            throw new DropboxParseException("Could not parse share response.");
        }
        return new DropboxLink(map);
    }

    protected static boolean getFromMapAsBoolean(Map<String, Object> map, String name) {
        Object val = map.get(name);
        if (val != null && val instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    private UploadRequest putFileRequest(String path, InputStream is, long length, boolean overwrite, String parentRev, ProgressListener listener) throws DropboxException {
        if (path == null || path.equals("")) {
            throw new IllegalArgumentException("path is null or empty.");
        }
        this.assertAuthenticated();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String target = "/files_put/" + (Object)((Object)this.session.getAccessType()) + path;
        if (parentRev == null) {
            parentRev = "";
        }
        String[] params = new String[]{"overwrite", String.valueOf(overwrite), "parent_rev", parentRev, "locale", this.session.getLocale().toString()};
        String url = RESTUtility.buildURL(this.session.getContentServer(), 1, target, params);
        HttpPut req = new HttpPut(url);
        this.session.sign((HttpRequest)req);
        InputStreamEntity isEntity = new InputStreamEntity(is, length);
        isEntity.setContentEncoding("application/octet-stream");
        isEntity.setChunked(false);
        Object entity = isEntity;
        if (listener != null) {
            entity = new ProgressListener.ProgressHttpEntity((HttpEntity)entity, listener);
        }
        req.setEntity((HttpEntity)entity);
        return new BasicUploadRequest((HttpUriRequest)req, (Session)this.session);
    }

    private Entry commitChunkedUpload(String path, String uploadId, boolean overwrite, String parentRev) throws DropboxException {
        if (path == null || path.equals("")) {
            throw new IllegalArgumentException("path is null or empty.");
        }
        this.assertAuthenticated();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String target = "/commit_chunked_upload/" + (Object)((Object)this.session.getAccessType()) + path;
        String[] params = new String[]{"overwrite", String.valueOf(overwrite), "parent_rev", parentRev, "locale", this.session.getLocale().toString(), "upload_id", uploadId};
        String url = RESTUtility.buildURL(this.session.getContentServer(), 1, target, params);
        HttpPost req = new HttpPost(url);
        this.session.sign((HttpRequest)req);
        HttpResponse hresp = RESTUtility.execute(this.session, (HttpUriRequest)req);
        Map json = (Map)RESTUtility.parseAsJSON(hresp);
        return new Entry(json);
    }

    public DeltaPage<Entry> delta(String cursor) throws DropboxException {
        String[] params = new String[]{"cursor", cursor, "locale", this.session.getLocale().toString()};
        Object json = RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/delta", 1, params, this.session);
        try {
            return DeltaPage.extractFromJson(new JsonThing(json), Entry.JsonExtractor);
        }
        catch (JsonExtractionException ex) {
            throw new DropboxParseException("Error parsing /delta results: " + ex.getMessage());
        }
    }

    public CreatedCopyRef createCopyRef(String sourcePath) throws DropboxException {
        this.assertAuthenticated();
        if (!sourcePath.startsWith("/")) {
            throw new IllegalArgumentException("'sourcePath' must start with \"/\": " + sourcePath);
        }
        String[] params = new String[]{"locale", this.session.getLocale().toString()};
        String url_path = "/copy_ref/" + (Object)((Object)this.session.getAccessType()) + sourcePath;
        Object result = RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), url_path, 1, params, this.session);
        try {
            return CreatedCopyRef.extractFromJson(new JsonThing(result));
        }
        catch (JsonExtractionException ex) {
            throw new DropboxParseException("Error parsing /copy_ref results: " + ex.getMessage());
        }
    }

    public Entry addFromCopyRef(String sourceCopyRef, String targetPath) throws DropboxException {
        this.assertAuthenticated();
        if (!targetPath.startsWith("/")) {
            throw new IllegalArgumentException("'targetPath' doesn't start with \"/\": " + targetPath);
        }
        String[] params = new String[]{"locale", this.session.getLocale().toString(), "root", this.session.getAccessType().toString(), "from_copy_ref", sourceCopyRef, "to_path", targetPath};
        String url_path = "/fileops/copy";
        Map dirinfo = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), url_path, 1, params, this.session);
        return new Entry(dirinfo);
    }

    protected void assertAuthenticated() throws DropboxUnlinkedException {
        if (!this.session.isLinked()) {
            throw new DropboxUnlinkedException();
        }
    }

    protected static long getFromMapAsLong(Map<String, Object> map, String name) {
        Object val = map.get(name);
        long ret = 0L;
        if (val != null) {
            if (val instanceof Number) {
                ret = ((Number)val).longValue();
            } else if (val instanceof String) {
                ret = Long.parseLong((String)val, 16);
            }
        }
        return ret;
    }

    public static final class CreatedCopyRef {
        public final String copyRef;
        public final String expiration;

        public CreatedCopyRef(String copyRef, String expiration) {
            this.copyRef = copyRef;
            this.expiration = expiration;
        }

        public static CreatedCopyRef extractFromJson(JsonThing j) throws JsonExtractionException {
            JsonMap m = j.expectMap();
            String string = m.get("copy_ref").expectString();
            String expiration = m.get("expires").expectString();
            return new CreatedCopyRef(string, expiration);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeltaEntry<MD> {
        public final String lcPath;
        public final MD metadata;

        public DeltaEntry(String lcPath, MD metadata) {
            this.lcPath = lcPath;
            this.metadata = metadata;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class JsonExtractor<MD>
        extends com.dropbox.client2.jsonextract.JsonExtractor<DeltaEntry<MD>> {
            public final com.dropbox.client2.jsonextract.JsonExtractor<MD> mdExtractor;

            public JsonExtractor(com.dropbox.client2.jsonextract.JsonExtractor<MD> mdExtractor) {
                this.mdExtractor = mdExtractor;
            }

            @Override
            public DeltaEntry<MD> extract(JsonThing j) throws JsonExtractionException {
                return JsonExtractor.extract(j, this.mdExtractor);
            }

            public static <MD> DeltaEntry<MD> extract(JsonThing j, com.dropbox.client2.jsonextract.JsonExtractor<MD> mdExtractor) throws JsonExtractionException {
                JsonList l = j.expectList();
                String path = l.get(0).expectString();
                MD metadata = l.get(1).optionalExtract(mdExtractor);
                return new DeltaEntry<MD>(path, metadata);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeltaPage<MD> {
        public final boolean reset;
        public final String cursor;
        public final List<DeltaEntry<MD>> entries;
        public final boolean hasMore;

        public DeltaPage(boolean reset, List<DeltaEntry<MD>> entries, String cursor, boolean hasMore) {
            this.reset = reset;
            this.entries = entries;
            this.cursor = cursor;
            this.hasMore = hasMore;
        }

        public static <MD> DeltaPage<MD> extractFromJson(JsonThing j, JsonExtractor<MD> entryExtractor) throws JsonExtractionException {
            JsonMap m = j.expectMap();
            boolean reset = m.get("reset").expectBoolean();
            String cursor = m.get("cursor").expectString();
            boolean hasMore = m.get("has_more").expectBoolean();
            ArrayList<DeltaEntry<MD>> entries = m.get("entries").expectList().extract(new DeltaEntry.JsonExtractor<MD>(entryExtractor));
            return new DeltaPage<MD>(reset, entries, cursor, hasMore);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThumbFormat {
        PNG,
        JPEG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThumbSize {
        ICON_32x32("small"),
        ICON_64x64("medium"),
        ICON_128x128("large"),
        ICON_256x256("256x256"),
        BESTFIT_320x240("320x240_bestfit"),
        BESTFIT_480x320("480x320_bestfit"),
        BESTFIT_640x480("640x480_bestfit"),
        BESTFIT_960x640("960x640_bestfit"),
        BESTFIT_1024x768("1024x768_bestfit");

        private String size;

        private ThumbSize(String size) {
            this.size = size;
        }

        public String toAPISize() {
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DropboxLink {
        public final String url;
        public final Date expires;

        private DropboxLink(String returl, boolean secure) {
            if (!secure && returl.startsWith("https://")) {
                returl = returl.replaceFirst("https://", "http://");
                returl = returl.replaceFirst(":443/", "/");
            }
            this.url = returl;
            this.expires = null;
        }

        private DropboxLink(Map<String, Object> map) {
            this(map, true);
        }

        private DropboxLink(Map<String, Object> map, boolean secure) {
            String returl = (String)map.get("url");
            String exp = (String)map.get("expires");
            this.expires = exp != null ? RESTUtility.parseDate(exp) : null;
            if (!secure && returl.startsWith("https://")) {
                returl = returl.replaceFirst("https://", "http://");
                returl = returl.replaceFirst(":443/", "/");
            }
            this.url = returl;
        }
    }

    public static final class RequestAndResponse {
        public final HttpUriRequest request;
        public final HttpResponse response;

        protected RequestAndResponse(HttpUriRequest request, HttpResponse response) {
            this.request = request;
            this.response = response;
        }
    }

    protected static final class BasicUploadRequest
    implements UploadRequest {
        private final HttpUriRequest request;
        private final Session session;

        public BasicUploadRequest(HttpUriRequest request, Session session) {
            this.request = request;
            this.session = session;
        }

        public void abort() {
            this.request.abort();
        }

        public Entry upload() throws DropboxException {
            HttpResponse hresp;
            try {
                hresp = RESTUtility.execute(this.session, this.request, 180000);
            }
            catch (DropboxIOException e) {
                if (this.request.isAborted()) {
                    throw new DropboxPartialFileException(-1L);
                }
                throw e;
            }
            Object resp = RESTUtility.parseAsJSON(hresp);
            Map ret = (Map)resp;
            return new Entry(ret);
        }
    }

    protected static final class ChunkedUploadRequest {
        private final HttpUriRequest request;
        private final Session session;

        protected ChunkedUploadRequest(HttpUriRequest request, Session session) {
            this.request = request;
            this.session = session;
        }

        public void abort() {
            this.request.abort();
        }

        public ChunkedUploadResponse upload() throws DropboxException {
            HttpResponse hresp;
            try {
                hresp = RESTUtility.execute(this.session, this.request, 180000);
            }
            catch (DropboxIOException e) {
                if (this.request.isAborted()) {
                    throw new DropboxPartialFileException(-1L);
                }
                throw e;
            }
            Map fields = (Map)RESTUtility.parseAsJSON(hresp);
            return new ChunkedUploadResponse(fields);
        }
    }

    public class ChunkedUploader {
        private String uploadId;
        private long offset = 0L;
        private static final int DEFAULT_CHUNK_SIZE = 0x400000;
        private byte[] lastChunk = null;
        private InputStream stream;
        private long targetLength;
        private boolean active = true;
        private ChunkedUploadRequest lastRequest = null;
        private final int chunkSize;

        private ChunkedUploader(InputStream is, long length, int chunkSize) {
            this.stream = is;
            this.targetLength = length;
            this.chunkSize = chunkSize;
        }

        private ChunkedUploader(InputStream is, long length) {
            this(is, length, 0x400000);
        }

        public long getOffset() {
            return this.offset;
        }

        public boolean isComplete() {
            return this.offset == this.targetLength;
        }

        public boolean getActive() {
            return this.active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            ChunkedUploader chunkedUploader = this;
            synchronized (chunkedUploader) {
                if (this.lastRequest != null) {
                    this.lastRequest.abort();
                }
                this.active = false;
            }
        }

        public void upload() throws DropboxException, IOException {
            this.upload(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void upload(ProgressListener listener) throws DropboxException, IOException {
            while (this.offset < this.targetLength) {
                int nextChunkSize = (int)Math.min((long)this.chunkSize, this.targetLength - this.offset);
                ProgressListener.Adjusted adjustedListener = null;
                if (listener != null) {
                    adjustedListener = new ProgressListener.Adjusted(listener, this.offset, this.targetLength);
                }
                if (this.lastChunk == null) {
                    this.lastChunk = new byte[nextChunkSize];
                    int bytesRead = this.stream.read(this.lastChunk);
                    if (bytesRead < this.lastChunk.length) {
                        throw new IllegalStateException("InputStream ended after " + (this.offset + (long)bytesRead) + " bytes, expecting " + this.targetLength + " bytes.");
                    }
                }
                try {
                    ChunkedUploader bytesRead = this;
                    synchronized (bytesRead) {
                        if (!this.active) {
                            throw new DropboxPartialFileException(0L);
                        }
                        this.lastRequest = DropboxAPI.this.chunkedUploadRequest(new ByteArrayInputStream(this.lastChunk), this.lastChunk.length, adjustedListener, this.offset, this.uploadId);
                    }
                    ChunkedUploadResponse resp = this.lastRequest.upload();
                    this.offset = resp.getOffset();
                    this.uploadId = resp.getUploadId();
                    this.lastChunk = null;
                }
                catch (DropboxServerException e) {
                    if (e.body.fields.containsKey("offset")) {
                        long newOffset = (Long)e.body.fields.get("offset");
                        if (newOffset > this.offset) {
                            this.lastChunk = null;
                            this.offset = newOffset;
                            continue;
                        }
                        throw e;
                    }
                    throw e;
                }
            }
        }

        public Entry finish(String path, String parentRev) throws DropboxException {
            return DropboxAPI.this.commitChunkedUpload(path, this.uploadId, false, parentRev);
        }
    }

    public static interface UploadRequest {
        public void abort();

        public Entry upload() throws DropboxException;
    }

    public static class DropboxInputStream
    extends FilterInputStream {
        private final HttpUriRequest request;
        private final DropboxFileInfo info;

        public DropboxInputStream(HttpUriRequest request, HttpResponse response) throws DropboxException {
            super(null);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new DropboxException("Didn't get entity from HttpResponse");
            }
            try {
                this.in = entity.getContent();
            }
            catch (IOException e) {
                throw new DropboxIOException(e);
            }
            this.request = request;
            this.info = new DropboxFileInfo(response);
        }

        public void close() throws IOException {
            this.request.abort();
        }

        public DropboxFileInfo getFileInfo() {
            return this.info;
        }

        public void copyStreamToOutput(OutputStream os, ProgressListener listener) throws DropboxIOException, DropboxPartialFileException, DropboxLocalStorageFullException {
            BufferedOutputStream bos = null;
            long totalRead = 0L;
            long lastListened = 0L;
            long length = this.info.getFileSize();
            try {
                bos = new BufferedOutputStream(os);
                byte[] buffer = new byte[4096];
                while (true) {
                    long now;
                    int read;
                    if ((read = this.read(buffer)) < 0) {
                        if (length < 0L || totalRead >= length) break;
                        throw new DropboxPartialFileException(totalRead);
                    }
                    bos.write(buffer, 0, read);
                    totalRead += (long)read;
                    if (listener == null || (now = System.currentTimeMillis()) - lastListened <= listener.progressInterval()) continue;
                    lastListened = now;
                    listener.onProgress(totalRead, length);
                }
                bos.flush();
                os.flush();
                try {
                    if (os instanceof FileOutputStream) {
                        ((FileOutputStream)os).getFD().sync();
                    }
                }
                catch (SyncFailedException e) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                String message = e.getMessage();
                if (message != null && message.startsWith("No space")) {
                    throw new DropboxLocalStorageFullException();
                }
                throw new DropboxPartialFileException(totalRead);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
                try {
                    this.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static final class DropboxFileInfo {
        private String mimeType = null;
        private long fileSize = -1L;
        private String charset = null;
        private Entry metadata = null;

        private DropboxFileInfo(HttpResponse response) throws DropboxException {
            String contentVal;
            this.metadata = DropboxFileInfo.parseXDropboxMetadata(response);
            if (this.metadata == null) {
                throw new DropboxParseException("Error parsing metadata.");
            }
            this.fileSize = DropboxFileInfo.parseFileSize(response, this.metadata);
            if (this.fileSize == -1L) {
                throw new DropboxParseException("Error determining file size.");
            }
            Header contentType = response.getFirstHeader("Content-Type");
            if (contentType != null && (contentVal = contentType.getValue()) != null) {
                String[] splits = contentVal.split(";");
                if (splits.length > 0) {
                    this.mimeType = splits[0].trim();
                }
                if (splits.length > 1 && (splits = splits[1].split("=")).length > 1) {
                    this.charset = splits[1].trim();
                }
            }
        }

        private static Entry parseXDropboxMetadata(HttpResponse response) {
            if (response == null) {
                return null;
            }
            Header xDropboxMetadataHeader = response.getFirstHeader("X-Dropbox-Metadata");
            if (xDropboxMetadataHeader == null) {
                return null;
            }
            String json = xDropboxMetadataHeader.getValue();
            Object metadata = JSONValue.parse((String)json);
            if (metadata == null) {
                return null;
            }
            Map map = (Map)metadata;
            return new Entry(map);
        }

        private static long parseFileSize(HttpResponse response, Entry metadata) {
            long contentLength = response.getEntity().getContentLength();
            if (contentLength >= 0L) {
                return contentLength;
            }
            if (metadata != null) {
                return metadata.bytes;
            }
            return -1L;
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        @Deprecated
        public final long getContentLength() {
            return this.getFileSize();
        }

        public final long getFileSize() {
            return this.fileSize;
        }

        public final String getCharset() {
            return this.charset;
        }

        public final Entry getMetadata() {
            return this.metadata;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ChunkedUploadResponse {
        private final String uploadId;
        private final long offset;

        public ChunkedUploadResponse(Map<String, Object> fields) {
            this.uploadId = (String)fields.get("upload_id");
            this.offset = (Long)fields.get("offset");
        }

        public String getUploadId() {
            return this.uploadId;
        }

        public long getOffset() {
            return this.offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        public long bytes;
        public String hash;
        public String icon;
        public boolean isDir;
        public String modified;
        public String clientMtime;
        public String path;
        public String root;
        public String size;
        public String mimeType;
        public String rev;
        public boolean thumbExists;
        public boolean isDeleted;
        public List<Entry> contents;
        public static final JsonExtractor<Entry> JsonExtractor = new JsonExtractor<Entry>(){

            @Override
            public Entry extract(JsonThing jt) throws JsonExtractionException {
                return new Entry((Map)jt.expectMap().internal);
            }
        };

        public Entry(Map<String, Object> map) {
            this.bytes = DropboxAPI.getFromMapAsLong(map, "bytes");
            this.hash = (String)map.get("hash");
            this.icon = (String)map.get("icon");
            this.isDir = DropboxAPI.getFromMapAsBoolean(map, "is_dir");
            this.modified = (String)map.get("modified");
            this.clientMtime = (String)map.get("client_mtime");
            this.path = (String)map.get("path");
            this.root = (String)map.get("root");
            this.size = (String)map.get("size");
            this.mimeType = (String)map.get("mime_type");
            this.rev = (String)map.get("rev");
            this.thumbExists = DropboxAPI.getFromMapAsBoolean(map, "thumb_exists");
            this.isDeleted = DropboxAPI.getFromMapAsBoolean(map, "is_deleted");
            Object json_contents = map.get("contents");
            if (json_contents != null && json_contents instanceof JSONArray) {
                this.contents = new ArrayList<Entry>();
                for (Object entry : (JSONArray)json_contents) {
                    if (!(entry instanceof Map)) continue;
                    this.contents.add(new Entry((Map)entry));
                }
            } else {
                this.contents = null;
            }
        }

        public Entry() {
        }

        public String fileName() {
            int ind = this.path.lastIndexOf(47);
            return this.path.substring(ind + 1, this.path.length());
        }

        public String parentPath() {
            if (this.path.equals("/")) {
                return "";
            }
            int ind = this.path.lastIndexOf(47);
            return this.path.substring(0, ind + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Account
    implements Serializable {
        private static final long serialVersionUID = 2097522622341535732L;
        public final String country;
        public final String displayName;
        public final long quota;
        public final long quotaNormal;
        public final long quotaShared;
        public final long uid;
        public final String referralLink;

        protected Account(Map<String, Object> map) {
            this.country = (String)map.get("country");
            this.displayName = (String)map.get("display_name");
            this.uid = DropboxAPI.getFromMapAsLong(map, "uid");
            this.referralLink = (String)map.get("referral_link");
            Object quotaInfo = map.get("quota_info");
            Map quotamap = (Map)quotaInfo;
            this.quota = DropboxAPI.getFromMapAsLong(quotamap, "quota");
            this.quotaNormal = DropboxAPI.getFromMapAsLong(quotamap, "normal");
            this.quotaShared = DropboxAPI.getFromMapAsLong(quotamap, "shared");
        }

        protected Account(String country, String displayName, long uid, String referralLink, long quota, long quotaNormal, long quotaShared) {
            this.country = country;
            this.displayName = displayName;
            this.uid = uid;
            this.referralLink = referralLink;
            this.quota = quota;
            this.quotaNormal = quotaNormal;
            this.quotaShared = quotaShared;
        }
    }
}

