/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.dropbox.client2.android.AuthActivity;
import com.dropbox.client2.session.AbstractSession;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;

public class AndroidAuthSession
extends AbstractSession {
    public AndroidAuthSession(AppKeyPair appKeyPair, Session.AccessType type) {
        super(appKeyPair, type);
    }

    public AndroidAuthSession(AppKeyPair appKeyPair, Session.AccessType type, AccessTokenPair accessTokenPair) {
        super(appKeyPair, type, accessTokenPair);
    }

    public void startAuthentication(Context context) {
        AppKeyPair appKeyPair = this.getAppKeyPair();
        if (!AuthActivity.checkAppBeforeAuth(context, appKeyPair.key, true)) {
            return;
        }
        Intent intent = new Intent(context, AuthActivity.class);
        intent.putExtra("EXTRA_INTERNAL_APP_KEY", appKeyPair.key);
        intent.putExtra("EXTRA_INTERNAL_APP_SECRET", appKeyPair.secret);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public boolean authenticationSuccessful() {
        Intent data = AuthActivity.result;
        if (data == null) {
            return false;
        }
        String token = data.getStringExtra("ACCESS_TOKEN");
        String secret = data.getStringExtra("ACCESS_SECRET");
        String uid = data.getStringExtra("UID");
        return token != null && !token.equals("") && secret != null && !secret.equals("") && uid != null && !uid.equals("");
    }

    public String finishAuthentication() throws IllegalStateException {
        Intent data = AuthActivity.result;
        if (data == null) {
            throw new IllegalStateException();
        }
        String token = data.getStringExtra("ACCESS_TOKEN");
        String secret = data.getStringExtra("ACCESS_SECRET");
        String uid = data.getStringExtra("UID");
        if (!(token == null || token.equals("") || secret == null || secret.equals("") || uid == null || uid.equals(""))) {
            AccessTokenPair tokens = new AccessTokenPair(token, secret);
            this.setAccessTokenPair(tokens);
            return uid;
        }
        throw new IllegalStateException();
    }

    public void unlink() {
        super.unlink();
        AuthActivity.result = null;
    }
}

