/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.dropbox.client2.RESTUtility;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Locale;

public class AuthActivity
extends Activity {
    private static final String TAG = AuthActivity.class.getName();
    public static final String EXTRA_CONSUMER_KEY = "CONSUMER_KEY";
    public static final String EXTRA_ACCESS_TOKEN = "ACCESS_TOKEN";
    public static final String EXTRA_ACCESS_SECRET = "ACCESS_SECRET";
    public static final String EXTRA_UID = "UID";
    public static final String EXTRA_CONSUMER_SIG = "CONSUMER_SIG";
    public static final String EXTRA_CALLING_PACKAGE = "CALLING_PACKAGE";
    public static final String EXTRA_CALLING_CLASS = "CALLING_CLASS";
    public static final String EXTRA_AUTH_STATE = "AUTH_STATE";
    public static final String ACTION_AUTHENTICATE_V1 = "com.dropbox.android.AUTHENTICATE_V1";
    public static final String ACTION_AUTHENTICATE_V2 = "com.dropbox.android.AUTHENTICATE_V2";
    public static final int AUTH_VERSION = 1;
    public static final String AUTH_PATH_CONNECT = "/connect";
    static final String EXTRA_INTERNAL_APP_KEY = "EXTRA_INTERNAL_APP_KEY";
    static final String EXTRA_INTERNAL_APP_SECRET = "EXTRA_INTERNAL_APP_SECRET";
    static final String EXTRA_INTERNAL_WEB_HOST = "EXTRA_INTERNAL_WEB_HOST";
    static final String EXTRA_INTERNAL_API_TYPE = "EXTRA_INTERNAL_API_TYPE";
    private static final String DEFAULT_WEB_HOST = "www.dropbox.com";
    public static Intent result = null;
    private String appKey;
    private String appSecret;
    private String webHost;
    private String apiType;
    private String authStateNonce = null;
    private static final String[] DROPBOX_APP_SIGNATURES = new String[]{"308202223082018b02044bd207bd300d06092a864886f70d01010405003058310b3009060355040613025553310b3009060355040813024341311630140603550407130d53616e204672616e636973636f3110300e060355040a130744726f70626f783112301006035504031309546f6d204d65796572301e170d3130303432333230343930315a170d3430303431353230343930315a3058310b3009060355040613025553310b3009060355040813024341311630140603550407130d53616e204672616e636973636f3110300e060355040a130744726f70626f783112301006035504031309546f6d204d6579657230819f300d06092a864886f70d010101050003818d0030818902818100ac1595d0ab278a9577f0ca5a14144f96eccde75f5616f36172c562fab0e98c48ad7d64f1091c6cc11ce084a4313d522f899378d312e112a748827545146a779defa7c31d8c00c2ed73135802f6952f59798579859e0214d4e9c0554b53b26032a4d2dfc2f62540d776df2ea70e2a6152945fb53fef5bac5344251595b729d4810203010001300d06092a864886f70d01010405000381810055c425d94d036153203dc0bbeb3516f94563b102fff39c3d4ed91278db24fc4424a244c2e59f03bbfea59404512b8bf74662f2a32e37eafa2ac904c31f99cfc21c9ff375c977c432d3b6ec22776f28767d0f292144884538c3d5669b568e4254e4ed75d9054f75229ac9d4ccd0b7c3c74a34f07b7657083b2aa76225c0c56ffc", "308201e53082014ea00302010202044e17e115300d06092a864886f70d01010505003037310b30090603550406130255533110300e060355040a1307416e64726f6964311630140603550403130d416e64726f6964204465627567301e170d3131303730393035303331375a170d3431303730313035303331375a3037310b30090603550406130255533110300e060355040a1307416e64726f6964311630140603550403130d416e64726f696420446562756730819f300d06092a864886f70d010101050003818d003081890281810096759fe5abea6a0757039b92adc68d672efa84732c3f959408e12efa264545c61f23141026a6d01eceeeaa13ec7087087e5894a3363da8bf5c69ed93657a6890738a80998e4ca22dc94848f30e2d0e1890000ae2cddf543b20c0c3828deca6c7944b5ecd21a9d18c988b2b3e54517dafbc34b48e801bb1321e0fa49e4d575d7f0203010001300d06092a864886f70d0101050500038181002b6d4b65bcfa6ec7bac97ae6d878064d47b3f9f8da654995b8ef4c385bc4fbfbb7a987f60783ef0348760c0708acd4b7e63f0235c35a4fbcd5ec41b3b4cb295feaa7d5c27fa562a02562b7e1f4776b85147be3e295714986c4a9a07183f48ea09ae4d3ea31b88d0016c65b93526b9c45f2967c3d28dee1aff5a5b29b9c2c8639"};

    public static Intent makeIntent(Context context, String appKey, String appSecret, String webHost, String apiType) {
        Intent intent = new Intent(context, AuthActivity.class);
        intent.putExtra(EXTRA_INTERNAL_APP_KEY, appKey);
        intent.putExtra(EXTRA_INTERNAL_APP_SECRET, appSecret);
        intent.putExtra(EXTRA_INTERNAL_WEB_HOST, webHost);
        intent.putExtra(EXTRA_INTERNAL_API_TYPE, apiType);
        return intent;
    }

    public static boolean checkAppBeforeAuth(Context context, String appKey, boolean alertUser) {
        Intent testIntent = new Intent("android.intent.action.VIEW");
        String scheme = "db-" + appKey;
        String uri = scheme + "://" + 1 + AUTH_PATH_CONNECT;
        testIntent.setData(Uri.parse((String)uri));
        PackageManager pm = context.getPackageManager();
        List activities = pm.queryIntentActivities(testIntent, 0);
        if (null == activities || 0 == activities.size()) {
            throw new IllegalStateException("URI scheme in your app's manifest is not set up correctly. You should have a " + AuthActivity.class.getName() + " with the " + "scheme: " + scheme);
        }
        if (activities.size() > 1) {
            if (alertUser) {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setTitle((CharSequence)"Security alert");
                builder.setMessage((CharSequence)"Another app on your phone may be trying to pose as the app you are currently using. The malicious app cannot access your account, but linking to Dropbox has been disabled as a precaution. Please contact support@dropbox.com.");
                builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                builder.show();
            } else {
                Log.w((String)TAG, (String)("There are multiple apps registered for the AuthActivity URI scheme (" + scheme + ").  Another app may be trying to " + " impersonate this app, so authentication will be disabled."));
            }
            return false;
        }
        String authPackage = ((ResolveInfo)activities.get((int)0)).activityInfo.packageName;
        if (!context.getPackageName().equals(authPackage)) {
            throw new IllegalStateException("There must be a " + AuthActivity.class.getName() + " within your app's package " + "registered for your URI scheme (" + scheme + "). However, " + "it appears that an activity in a different package is " + "registered for that scheme instead. If you have " + "multiple apps that all want to use the same access" + "token pair, designate one of them to do " + "authentication and have the other apps launch it " + "and then retrieve the token pair from it.");
        }
        return true;
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            result = null;
            this.authStateNonce = null;
        } else {
            this.authStateNonce = savedInstanceState.getString("authStateNonce");
        }
        Intent intent = this.getIntent();
        this.appKey = intent.getStringExtra(EXTRA_INTERNAL_APP_KEY);
        this.appSecret = intent.getStringExtra(EXTRA_INTERNAL_APP_SECRET);
        this.webHost = intent.getStringExtra(EXTRA_INTERNAL_WEB_HOST);
        if (null == this.webHost) {
            this.webHost = DEFAULT_WEB_HOST;
        }
        this.apiType = intent.getStringExtra(EXTRA_INTERNAL_API_TYPE);
        this.setTheme(0x1030010);
        super.onCreate(savedInstanceState);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("authStateNonce", this.authStateNonce);
    }

    protected void onResume() {
        super.onResume();
        if (this.isFinishing()) {
            return;
        }
        if (this.authStateNonce != null || this.appKey == null || this.appSecret == null) {
            this.authFinished(null);
            return;
        }
        result = null;
        String state = AuthActivity.createStateNonce();
        Intent officialIntent = new Intent();
        officialIntent.setPackage("com.dropbox.android");
        officialIntent.setAction(ACTION_AUTHENTICATE_V2);
        officialIntent.putExtra(EXTRA_CONSUMER_KEY, this.appKey);
        officialIntent.putExtra(EXTRA_CONSUMER_SIG, this.getConsumerSig());
        officialIntent.putExtra(EXTRA_CALLING_PACKAGE, this.getPackageName());
        officialIntent.putExtra(EXTRA_CALLING_CLASS, ((Object)((Object)this)).getClass().getName());
        officialIntent.putExtra(EXTRA_AUTH_STATE, state);
        if (this.hasDropboxApp(officialIntent)) {
            this.startActivity(officialIntent);
        } else {
            this.startWebAuth(state);
        }
        this.authStateNonce = state;
    }

    protected void onNewIntent(Intent intent) {
        Intent newResult;
        if (null == this.authStateNonce) {
            this.authFinished(null);
            return;
        }
        String token = null;
        String secret = null;
        String uid = null;
        String state = null;
        if (intent.hasExtra(EXTRA_ACCESS_TOKEN)) {
            token = intent.getStringExtra(EXTRA_ACCESS_TOKEN);
            secret = intent.getStringExtra(EXTRA_ACCESS_SECRET);
            uid = intent.getStringExtra(EXTRA_UID);
            state = intent.getStringExtra(EXTRA_AUTH_STATE);
        } else {
            String path;
            Uri uri = intent.getData();
            if (uri != null && AUTH_PATH_CONNECT.equals(path = uri.getPath())) {
                try {
                    token = uri.getQueryParameter("oauth_token");
                    secret = uri.getQueryParameter("oauth_token_secret");
                    uid = uri.getQueryParameter("uid");
                    state = uri.getQueryParameter("state");
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
            }
        }
        if (!(token == null || token.equals("") || secret == null || secret.equals("") || uid == null || uid.equals("") || state == null || state.equals(""))) {
            if (!this.authStateNonce.equals(state)) {
                this.authFinished(null);
                return;
            }
            newResult = new Intent();
            newResult.putExtra(EXTRA_ACCESS_TOKEN, token);
            newResult.putExtra(EXTRA_ACCESS_SECRET, secret);
            newResult.putExtra(EXTRA_UID, uid);
        } else {
            newResult = null;
        }
        this.authFinished(newResult);
    }

    private void authFinished(Intent authResult) {
        result = authResult;
        this.authStateNonce = null;
        this.finish();
    }

    private String getConsumerSig() {
        MessageDigest m;
        try {
            m = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        m.update(this.appSecret.getBytes(), 0, this.appSecret.length());
        BigInteger i = new BigInteger(1, m.digest());
        String s = String.format("%1$040X", i);
        return s.substring(32);
    }

    private boolean hasDropboxApp(Intent intent) {
        PackageInfo packageInfo;
        PackageManager manager = this.getPackageManager();
        List infos = manager.queryIntentActivities(intent, 0);
        if (null == infos || 1 != infos.size()) {
            return false;
        }
        ResolveInfo resolveInfo = manager.resolveActivity(intent, 0);
        if (resolveInfo == null) {
            return false;
        }
        try {
            packageInfo = manager.getPackageInfo(resolveInfo.activityInfo.packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        for (Signature signature : packageInfo.signatures) {
            for (String dbSignature : DROPBOX_APP_SIGNATURES) {
                if (!dbSignature.equals(signature.toCharsString())) continue;
                return true;
            }
        }
        return false;
    }

    private void startWebAuth(String state) {
        String path = AUTH_PATH_CONNECT;
        Locale locale = Locale.getDefault();
        String[] params = new String[]{"locale", locale.getLanguage() + "_" + locale.getCountry(), "k", this.appKey, "s", this.getConsumerSig(), "api", this.apiType, "state", state};
        String url = RESTUtility.buildURL(this.webHost, 1, path, params);
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.startActivity(intent);
    }

    private static String createStateNonce() {
        int NONCE_BYTES = 16;
        byte[] randomBytes = new byte[16];
        new SecureRandom().nextBytes(randomBytes);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append(String.format("%02x", randomBytes[i] & 0xFF));
        }
        return sb.toString();
    }
}

