/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.session;

import com.dropbox.client2.RESTUtility;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.exception.DropboxParseException;
import com.dropbox.client2.session.AbstractSession;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.RequestTokenPair;
import com.dropbox.client2.session.Session;
import java.util.Map;
import org.apache.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAuthSession
extends AbstractSession {
    public WebAuthSession(AppKeyPair appKeyPair, Session.AccessType type) {
        super(appKeyPair, type);
    }

    public WebAuthSession(AppKeyPair appKeyPair, Session.AccessType type, AccessTokenPair accessTokenPair) {
        super(appKeyPair, type, accessTokenPair);
    }

    public WebAuthSession(AppKeyPair appKeyPair) {
        super(appKeyPair);
    }

    public WebAuthSession(AppKeyPair appKeyPair, AccessTokenPair accessTokenPair) {
        super(appKeyPair, accessTokenPair);
    }

    public WebAuthInfo getAuthInfo() throws DropboxException {
        return this.getAuthInfo(null);
    }

    public WebAuthInfo getAuthInfo(String callbackUrl) throws DropboxException {
        this.setUpToken("/oauth/request_token");
        AccessTokenPair accessTokenPair = this.getAccessTokenPair();
        RequestTokenPair requestTokenPair = new RequestTokenPair(accessTokenPair.key, accessTokenPair.secret);
        String[] args = callbackUrl != null ? new String[]{"oauth_token", requestTokenPair.key, "oauth_callback", callbackUrl, "locale", this.getLocale().toString()} : new String[]{"oauth_token", requestTokenPair.key, "locale", this.getLocale().toString()};
        String url = RESTUtility.buildURL(this.getWebServer(), 1, "/oauth/authorize", args);
        return new WebAuthInfo(url, requestTokenPair);
    }

    public String retrieveWebAccessToken(RequestTokenPair requestTokenPair) throws DropboxException {
        this.setAccessTokenPair(requestTokenPair);
        Map<String, String> result = this.setUpToken("/oauth/access_token");
        return result.get("uid");
    }

    private Map<String, String> setUpToken(String path) throws DropboxException {
        HttpResponse response = RESTUtility.streamRequest((RESTUtility.RequestMethod)RESTUtility.RequestMethod.GET, (String)this.getAPIServer(), (String)path, (int)1, (String[])new String[]{"locale", this.getLocale().toString()}, (Session)this).response;
        Map<String, String> result = RESTUtility.parseAsQueryString(response);
        if (!result.containsKey("oauth_token") || !result.containsKey("oauth_token_secret")) {
            throw new DropboxParseException("Did not get tokens from Dropbox");
        }
        this.setAccessTokenPair(new AccessTokenPair(result.get("oauth_token"), result.get("oauth_token_secret")));
        return result;
    }

    public static final class WebAuthInfo {
        public final String url;
        public final RequestTokenPair requestTokenPair;

        private WebAuthInfo(String url, RequestTokenPair requestTokenPair) {
            this.url = url;
            this.requestTokenPair = requestTokenPair;
        }
    }
}

