/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.session;

import com.dropbox.client2.RESTUtility;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.session.AbstractSession;
import com.dropbox.client2.session.AppKeyPair;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

public class WebOAuth2Session
extends AbstractSession {
    public WebOAuth2Session(AppKeyPair appKeyPair) {
        super(appKeyPair);
    }

    public WebOAuth2Session(AppKeyPair appKeyPair, String oauth2AccessToken) {
        super(appKeyPair, oauth2AccessToken);
    }

    public String getAuthorizeURL() {
        return this.getAuthorizeURL(null, null);
    }

    public String getAuthorizeURL(String redirectUrl, String csrfToken) {
        String[] args = new String[]{"response_type", "code", "client_id", this.getAppKeyPair().key, "redirect_uri", redirectUrl, "state", csrfToken};
        String path = "/oauth2/authorize";
        return RESTUtility.buildURL(this.getWebServer(), 1, path, args);
    }

    public String retrieveWebAccessToken(String code, String redirectUrl) throws DropboxException {
        if (code == null) {
            throw new IllegalArgumentException("'code' must not be null");
        }
        String[] args = new String[]{"grant_type", "authorization_code", "code", code, "client_id", this.getAppKeyPair().key, "client_secret", this.getAppKeyPair().secret, "redirect_uri", redirectUrl};
        String path = "/oauth2/token";
        String url = RESTUtility.buildURL(this.getAPIServer(), 1, path, args);
        HttpPost req = new HttpPost(url);
        HttpResponse resp = RESTUtility.execute(this, (HttpUriRequest)req);
        Map respData = (Map)RESTUtility.parseAsJSON(resp);
        String accessToken = (String)respData.get("access_token");
        this.setOAuth2AccessToken(accessToken);
        return accessToken;
    }
}

