/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import com.evernote.client.android.AsyncLinkedNoteStoreClient;
import com.evernote.client.android.ClientFactory;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TProtocol;
import com.evernote.thrift.transport.TTransportException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AsyncBusinessNoteStoreClient
extends AsyncLinkedNoteStoreClient {
    AsyncBusinessNoteStoreClient(TProtocol iprot, TProtocol oprot, String authenticationToken, ClientFactory clientFactory) throws TTransportException {
        super(iprot, oprot, authenticationToken, clientFactory);
    }

    @Override
    public Note createNote(Note note, LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        AsyncLinkedNoteStoreClient sharedNoteStore = this.getClientFactory().createLinkedNoteStoreClient(linkedNotebook);
        SharedNotebook sharedNotebook = sharedNoteStore.getAsyncClient().getClient().getSharedNotebookByAuth(sharedNoteStore.getAuthenticationToken());
        note.setNotebookGuid(sharedNotebook.getNotebookGuid());
        sharedNoteStore.getAsyncClient().getClient().createNote(sharedNoteStore.getAuthenticationToken(), note);
        return note;
    }

    @Override
    public List<LinkedNotebook> listNotebooks() throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        ArrayList<LinkedNotebook> linkedNotebooks = new ArrayList<LinkedNotebook>();
        for (LinkedNotebook notebook : super.listNotebooks()) {
            if (!notebook.isSetBusinessId()) continue;
            linkedNotebooks.add(notebook);
        }
        return linkedNotebooks;
    }

    @Override
    public LinkedNotebook createNotebook(Notebook notebook) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        return super.createNotebook(notebook);
    }

    @Override
    public int deleteNotebook(LinkedNotebook linkedNotebook) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        AsyncLinkedNoteStoreClient sharedNoteStore = this.getClientFactory().createLinkedNoteStoreClient(linkedNotebook);
        SharedNotebook sharedNotebook = sharedNoteStore.getAsyncClient().getClient().getSharedNotebookByAuth(sharedNoteStore.getAuthenticationToken());
        Long[] ids = new Long[]{sharedNotebook.getId()};
        this.getAsyncClient().getClient().expungeSharedNotebooks(this.getAuthenticationToken(), Arrays.asList(ids));
        return this.getAsyncPersonalClient().getClient().expungeLinkedNotebook(this.getAsyncPersonalClient().getAuthenticationToken(), linkedNotebook.getGuid());
    }

    @Override
    public Notebook getCorrespondingNotebook(LinkedNotebook linkedNotebook) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        AsyncLinkedNoteStoreClient sharedNoteStore = this.getClientFactory().createLinkedNoteStoreClient(linkedNotebook);
        SharedNotebook sharedNotebook = sharedNoteStore.getAsyncClient().getClient().getSharedNotebookByAuth(sharedNoteStore.getAuthenticationToken());
        return this.getAsyncClient().getClient().getNotebook(this.getAuthenticationToken(), sharedNotebook.getNotebookGuid());
    }
}

