/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import com.evernote.client.android.AsyncNoteStoreClient;
import com.evernote.client.android.AsyncReflector;
import com.evernote.client.android.ClientFactory;
import com.evernote.client.android.EvernoteSession;
import com.evernote.client.android.OnClientCallback;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NotesMetadataList;
import com.evernote.edam.notestore.NotesMetadataResultSpec;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TProtocol;
import com.evernote.thrift.transport.TTransportException;
import java.util.Arrays;
import java.util.List;

public class AsyncLinkedNoteStoreClient {
    private AsyncNoteStoreClient mMainNoteStoreClient;
    private AsyncNoteStoreClient mLinkedStoreClient;
    private String mAuthToken;
    private ClientFactory mClientFactory;

    AsyncLinkedNoteStoreClient(TProtocol iprot, TProtocol oprot, String authenticationToken, ClientFactory clientFactory) throws TTransportException {
        this.mLinkedStoreClient = new AsyncNoteStoreClient(iprot, oprot, authenticationToken);
        this.mMainNoteStoreClient = EvernoteSession.getOpenSession().getClientFactory().createNoteStoreClient();
        this.mAuthToken = authenticationToken;
        this.mClientFactory = clientFactory;
    }

    public AsyncNoteStoreClient getAsyncClient() {
        return this.mLinkedStoreClient;
    }

    AsyncNoteStoreClient getAsyncPersonalClient() {
        return this.mMainNoteStoreClient;
    }

    String getAuthenticationToken() {
        return this.mAuthToken;
    }

    void setAuthToken(String authenticationToken) {
        this.mAuthToken = authenticationToken;
    }

    ClientFactory getClientFactory() {
        return this.mClientFactory;
    }

    public void createNoteAsync(Note note, LinkedNotebook linkedNotebook, OnClientCallback<Note> callback) {
        AsyncReflector.execute(this, callback, "createNote", note, linkedNotebook);
    }

    public Note createNote(Note note, LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        SharedNotebook sharedNotebook = this.getAsyncClient().getClient().getSharedNotebookByAuth(this.getAuthenticationToken());
        note.setNotebookGuid(sharedNotebook.getNotebookGuid());
        return this.getAsyncClient().getClient().createNote(this.getAuthenticationToken(), note);
    }

    public void listNotebooksAsync(OnClientCallback<List<LinkedNotebook>> callback) {
        AsyncReflector.execute(this.getAsyncPersonalClient(), callback, "listNotebooks", this.getAuthenticationToken());
    }

    public List<LinkedNotebook> listNotebooks() throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        return this.getAsyncPersonalClient().getClient().listLinkedNotebooks(this.getAsyncPersonalClient().getAuthenticationToken());
    }

    public void createNotebookAsync(Notebook notebook, OnClientCallback<LinkedNotebook> callback) {
        AsyncReflector.execute(this, callback, "createNotebook", notebook);
    }

    public LinkedNotebook createNotebook(Notebook notebook) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        Notebook originalNotebook = this.getAsyncClient().getClient().createNotebook(this.getAuthenticationToken(), notebook);
        SharedNotebook sharedNotebook = (SharedNotebook)originalNotebook.getSharedNotebooks().get(0);
        LinkedNotebook linkedNotebook = new LinkedNotebook();
        linkedNotebook.setShareKey(sharedNotebook.getShareKey());
        linkedNotebook.setShareName(originalNotebook.getName());
        linkedNotebook.setUsername(EvernoteSession.getOpenSession().getAuthenticationResult().getBusinessUser().getUsername());
        linkedNotebook.setShardId(EvernoteSession.getOpenSession().getAuthenticationResult().getBusinessUser().getShardId());
        return this.getAsyncPersonalClient().getClient().createLinkedNotebook(this.getAsyncPersonalClient().getAuthenticationToken(), linkedNotebook);
    }

    public void deleteNotebookAsync(LinkedNotebook linkedNotebook, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this, callback, "deleteNotebook", linkedNotebook);
    }

    public int deleteNotebook(LinkedNotebook linkedNotebook) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        SharedNotebook sharedNotebook = this.getAsyncClient().getClient().getSharedNotebookByAuth(this.getAuthenticationToken());
        Long[] ids = new Long[]{sharedNotebook.getId()};
        this.getAsyncClient().getClient().expungeSharedNotebooks(this.getAuthenticationToken(), Arrays.asList(ids));
        return this.getAsyncPersonalClient().getClient().expungeLinkedNotebook(this.getAsyncPersonalClient().getAuthenticationToken(), linkedNotebook.getGuid());
    }

    public void getCorrespondingNotebookAsync(LinkedNotebook linkedNotebook, OnClientCallback<Notebook> callback) {
        AsyncReflector.execute(this, callback, "getCorrespondingNotebook", linkedNotebook);
    }

    public Notebook getCorrespondingNotebook(LinkedNotebook linkedNotebook) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        SharedNotebook sharedNotebook = this.getAsyncClient().getClient().getSharedNotebookByAuth(this.getAuthenticationToken());
        return this.getAsyncClient().getClient().getNotebook(this.getAuthenticationToken(), sharedNotebook.getNotebookGuid());
    }

    public void isNotebookWritableAsync(LinkedNotebook linkedNotebook, OnClientCallback<Boolean> callback) {
        AsyncReflector.execute(this, callback, "isLinkedNotebookWritable", linkedNotebook);
    }

    public boolean isNotebookWritable(LinkedNotebook linkedNotebook) throws EDAMUserException, TException, EDAMSystemException, EDAMNotFoundException {
        Notebook notebook = this.getCorrespondingNotebook(linkedNotebook);
        return !notebook.getRestrictions().isNoCreateNotes();
    }

    public void findNotesMetadataAsync(NoteFilter filter, int offset, int maxNotes, NotesMetadataResultSpec resultSpec, OnClientCallback<NotesMetadataList> callback) {
        AsyncReflector.execute(this, callback, "findNotesMetadata", filter, offset, maxNotes, resultSpec);
    }

    public NotesMetadataList findNotesMetadata(NoteFilter filter, int offset, int maxNotes, NotesMetadataResultSpec resultSpec) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getAsyncClient().getClient().findNotesMetadata(this.getAuthenticationToken(), filter, offset, maxNotes, resultSpec);
    }
}

