/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.content.SharedPreferences;
import android.util.Log;
import com.evernote.client.android.SessionPreferences;
import com.evernote.edam.type.User;

public class AuthenticationResult {
    private static final String LOGTAG = "AuthenticationResult";
    private String mAuthToken;
    private String mNoteStoreUrl;
    private String mWebApiUrlPrefix;
    private String mEvernoteHost;
    private int mUserId;
    private boolean mIsAppLinkedNotebook;
    private String mBusinessNoteStoreUrl;
    private String mBusinessAuthToken;
    private long mBusinessAuthTokenExpiration;
    private User mBusinessUser;

    public AuthenticationResult(SharedPreferences pref) {
        this.restore(pref);
    }

    public AuthenticationResult(String authToken, String noteStoreUrl, String webApiUrlPrefix, String evernoteHost, int userId, boolean isAppLinkedNotebook) {
        this.mAuthToken = authToken;
        this.mNoteStoreUrl = noteStoreUrl;
        this.mWebApiUrlPrefix = webApiUrlPrefix;
        this.mEvernoteHost = evernoteHost;
        this.mUserId = userId;
        this.mIsAppLinkedNotebook = isAppLinkedNotebook;
    }

    void persist(SharedPreferences pref) {
        Log.d((String)LOGTAG, (String)"persisting Authentication results to SharedPreference");
        SharedPreferences.Editor editor = pref.edit();
        editor.putString("evernote.mAuthToken", this.mAuthToken);
        editor.putString("evernote.notestoreUrl", this.mNoteStoreUrl);
        editor.putString("evernote.webApiUrlPrefix", this.mWebApiUrlPrefix);
        editor.putString("evernote.mEvernoteHost", this.mEvernoteHost);
        editor.putInt("evernote.userId", this.mUserId);
        editor.putBoolean("evernote.isAppLinkedNotebook", this.mIsAppLinkedNotebook);
        SessionPreferences.save(editor);
    }

    void restore(SharedPreferences pref) {
        Log.d((String)LOGTAG, (String)"restoring Authentication results from SharedPreference");
        this.mAuthToken = pref.getString("evernote.mAuthToken", null);
        this.mNoteStoreUrl = pref.getString("evernote.notestoreUrl", null);
        this.mWebApiUrlPrefix = pref.getString("evernote.webApiUrlPrefix", null);
        this.mEvernoteHost = pref.getString("evernote.mEvernoteHost", null);
        this.mUserId = pref.getInt("evernote.userId", -1);
        this.mIsAppLinkedNotebook = pref.getBoolean("evernote.isAppLinkedNotebook", false);
    }

    void clear(SharedPreferences pref) {
        Log.d((String)LOGTAG, (String)"clearing Authentication results from SharedPreference");
        SharedPreferences.Editor editor = pref.edit();
        editor.remove("evernote.mAuthToken");
        editor.remove("evernote.notestoreUrl");
        editor.remove("evernote.webApiUrlPrefix");
        editor.remove("evernote.mEvernoteHost");
        editor.remove("evernote.userId");
        editor.remove("evernote.isAppLinkedNotebook");
        SessionPreferences.save(editor);
    }

    public String getAuthToken() {
        return this.mAuthToken;
    }

    public String getNoteStoreUrl() {
        return this.mNoteStoreUrl;
    }

    public String getWebApiUrlPrefix() {
        return this.mWebApiUrlPrefix;
    }

    public String getEvernoteHost() {
        return this.mEvernoteHost;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public boolean isAppLinkedNotebook() {
        return this.mIsAppLinkedNotebook;
    }

    public String getBusinessNoteStoreUrl() {
        return this.mBusinessNoteStoreUrl;
    }

    void setBusinessNoteStoreUrl(String businessNoteStoreUrl) {
        this.mBusinessNoteStoreUrl = businessNoteStoreUrl;
    }

    public User getBusinessUser() {
        return this.mBusinessUser;
    }

    void setBusinessUser(User user) {
        this.mBusinessUser = user;
    }

    public String getBusinessAuthToken() {
        return this.mBusinessAuthToken;
    }

    void setBusinessAuthToken(String authToken) {
        this.mBusinessAuthToken = authToken;
    }

    public long getBusinessAuthTokenExpiration() {
        return this.mBusinessAuthTokenExpiration;
    }

    void setBusinessAuthTokenExpiration(long businessAuthTokenExpiration) {
        this.mBusinessAuthTokenExpiration = businessAuthTokenExpiration;
    }
}

