/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import com.evernote.client.android.AsyncReflector;
import com.evernote.client.android.OnClientCallback;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.ClientUsageMetrics;
import com.evernote.edam.notestore.NoteCollectionCounts;
import com.evernote.edam.notestore.NoteEmailParameters;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.notestore.NoteVersionId;
import com.evernote.edam.notestore.NotesMetadataList;
import com.evernote.edam.notestore.NotesMetadataResultSpec;
import com.evernote.edam.notestore.RelatedQuery;
import com.evernote.edam.notestore.RelatedResult;
import com.evernote.edam.notestore.RelatedResultSpec;
import com.evernote.edam.notestore.SyncChunk;
import com.evernote.edam.notestore.SyncChunkFilter;
import com.evernote.edam.notestore.SyncState;
import com.evernote.edam.type.LazyMap;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.type.SharedNotebookRecipientSettings;
import com.evernote.edam.type.Tag;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TProtocol;
import java.util.List;

public class AsyncNoteStoreClient {
    protected String mAuthenticationToken;
    protected final NoteStore.Client mClient;

    AsyncNoteStoreClient(TProtocol prot, String authenticationToken) {
        this.mClient = new NoteStore.Client(prot);
        this.mAuthenticationToken = authenticationToken;
    }

    AsyncNoteStoreClient(TProtocol iprot, TProtocol oprot, String authenticationToken) {
        this.mClient = new NoteStore.Client(iprot, oprot);
        this.mAuthenticationToken = authenticationToken;
    }

    public NoteStore.Client getClient() {
        return this.mClient;
    }

    String getAuthenticationToken() {
        return this.mAuthenticationToken;
    }

    void setAuthToken(String authenticationToken) {
        this.mAuthenticationToken = authenticationToken;
    }

    public void getSyncState(OnClientCallback<SyncState> callback) {
        AsyncReflector.execute(this.mClient, callback, "getSyncState", this.mAuthenticationToken);
    }

    public void getSyncStateWithMetrics(ClientUsageMetrics clientMetrics, OnClientCallback<SyncState> callback) {
        AsyncReflector.execute(this.mClient, callback, "getSyncStateWithMetrics", this.mAuthenticationToken, clientMetrics);
    }

    public void getSyncChunk(int afterUSN, int maxEntries, boolean fullSyncOnly, OnClientCallback<SyncChunk> callback) {
        AsyncReflector.execute(this.mClient, callback, "getSyncChunk", this.mAuthenticationToken, afterUSN, maxEntries, fullSyncOnly);
    }

    public void getFilteredSyncChunk(int afterUSN, int maxEntries, SyncChunkFilter filter, OnClientCallback<SyncChunk> callback) {
        AsyncReflector.execute(this.mClient, callback, "getFilteredSyncChunk", this.mAuthenticationToken, afterUSN, maxEntries, filter);
    }

    public void getLinkedNotebookSyncState(LinkedNotebook linkedNotebook, OnClientCallback<SyncState> callback) {
        AsyncReflector.execute(this.mClient, callback, "getLinkedNotebookSyncState", this.mAuthenticationToken, linkedNotebook);
    }

    public void getLinkedNotebookSyncChunk(LinkedNotebook linkedNotebook, int afterUSN, int maxEntries, boolean fullSyncOnly, OnClientCallback<SyncChunk> callback) {
        AsyncReflector.execute(this.mClient, callback, "getLinkedNotebookSyncChunk", this.mAuthenticationToken, linkedNotebook, afterUSN, maxEntries, fullSyncOnly);
    }

    public void listNotebooks(OnClientCallback<List<Notebook>> callback) {
        AsyncReflector.execute(this.mClient, callback, "listNotebooks", this.mAuthenticationToken);
    }

    public void getNotebook(String guid, OnClientCallback<Notebook> callback) {
        AsyncReflector.execute(this.mClient, callback, "getNotebook", this.mAuthenticationToken, guid);
    }

    public void getDefaultNotebook(OnClientCallback<Notebook> callback) {
        AsyncReflector.execute(this.mClient, callback, "getDefaultNotebook", this.mAuthenticationToken);
    }

    public void createNotebook(Notebook notebook, OnClientCallback<Notebook> callback) {
        AsyncReflector.execute(this.mClient, callback, "createNotebook", this.mAuthenticationToken, notebook);
    }

    public void updateNotebook(Notebook notebook, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "updateNotebook", this.mAuthenticationToken, notebook);
    }

    public void expungeNotebook(String guid, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "expungeNotebook", this.mAuthenticationToken, guid);
    }

    public void listTags(OnClientCallback<List<Tag>> callback) {
        AsyncReflector.execute(this.mClient, callback, "listTags", this.mAuthenticationToken);
    }

    public void listTagsByNotebook(String notebookGuid, OnClientCallback<List<Tag>> callback) {
        AsyncReflector.execute(this.mClient, callback, "listTagsByNotebook", this.mAuthenticationToken, notebookGuid);
    }

    public void getTag(String guid, OnClientCallback<Tag> callback) {
        AsyncReflector.execute(this.mClient, callback, "getTag", this.mAuthenticationToken, guid);
    }

    public void createTag(Tag tag, OnClientCallback<Tag> callback) {
        AsyncReflector.execute(this.mClient, callback, "createTag", this.mAuthenticationToken, tag);
    }

    public void updateTag(Tag tag, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "updateTag", this.mAuthenticationToken, tag);
    }

    public void untagAll(String guid, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "untagAll", this.mAuthenticationToken, guid);
    }

    public void expungeTag(String guid, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "expungeTag", this.mAuthenticationToken, guid);
    }

    public void listSearches(OnClientCallback<List<SavedSearch>> callback) {
        AsyncReflector.execute(this.mClient, callback, "listSearches", this.mAuthenticationToken);
    }

    public void getSearch(String guid, OnClientCallback<SavedSearch> callback) {
        AsyncReflector.execute(this.mClient, callback, "getSearch", this.mAuthenticationToken, guid);
    }

    public void createSearch(SavedSearch search, OnClientCallback<SavedSearch> callback) {
        AsyncReflector.execute(this.mClient, callback, "createSearch", this.mAuthenticationToken, search);
    }

    public void updateSearch(SavedSearch search, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "updateSearch", this.mAuthenticationToken, search);
    }

    public void expungeSearch(String guid, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "expungeSearch", this.mAuthenticationToken, guid);
    }

    public void findNotes(NoteFilter filter, int offset, int maxNotes, OnClientCallback<NoteList> callback) {
        AsyncReflector.execute(this.mClient, callback, "findNotes", this.mAuthenticationToken, filter, offset, maxNotes);
    }

    public void findNoteOffset(NoteFilter filter, String guid, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "findNoteOffset", this.mAuthenticationToken, filter, guid);
    }

    public void findNotesMetadata(NoteFilter filter, int offset, int maxNotes, NotesMetadataResultSpec resultSpec, OnClientCallback<NotesMetadataList> callback) {
        AsyncReflector.execute(this.mClient, callback, "findNotesMetadata", this.mAuthenticationToken, filter, offset, maxNotes, resultSpec);
    }

    public void findNoteCounts(NoteFilter filter, boolean withTrash, OnClientCallback<NoteCollectionCounts> callback) {
        AsyncReflector.execute(this.mClient, callback, "findNoteCounts", this.mAuthenticationToken, filter, withTrash);
    }

    public void getNote(String guid, boolean withContent, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData, OnClientCallback<Note> callback) {
        AsyncReflector.execute(this.mClient, callback, "getNote", this.mAuthenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
    }

    public void getNoteApplicationData(String guid, OnClientCallback<LazyMap> callback) {
        AsyncReflector.execute(this.mClient, callback, "getNoteApplicationData", this.mAuthenticationToken, guid);
    }

    public void getNoteApplicationDataEntry(String guid, String key, OnClientCallback<String> callback) {
        AsyncReflector.execute(this.mClient, callback, "getNoteApplicationDataEntry", this.mAuthenticationToken, guid, key);
    }

    public void setNoteApplicationDataEntry(String guid, String key, String value, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "setNoteApplicationDataEntry", this.mAuthenticationToken, guid, key, value);
    }

    public void unsetNoteApplicationDataEntry(String guid, String key, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "unsetNoteApplicationDataEntry", this.mAuthenticationToken, guid, key);
    }

    public void getNoteContent(String guid, OnClientCallback<String> callback) {
        AsyncReflector.execute(this.mClient, callback, "getNoteContent", this.mAuthenticationToken, guid);
    }

    public void getNoteSearchText(String guid, boolean noteOnly, boolean tokenizeForIndexing, OnClientCallback<String> callback) {
        AsyncReflector.execute(this.mClient, callback, "getNoteSearchText", this.mAuthenticationToken, guid, noteOnly, tokenizeForIndexing);
    }

    public void getResourceSearchText(String guid, OnClientCallback<String> callback) {
        AsyncReflector.execute(this.mClient, callback, "getResourceSearchText", this.mAuthenticationToken, guid);
    }

    public void getNoteTagNames(String guid, OnClientCallback<List<String>> callback) {
        AsyncReflector.execute(this.mClient, callback, "getNoteTagNames", this.mAuthenticationToken, guid);
    }

    public void createNote(Note note, OnClientCallback<Note> callback) {
        AsyncReflector.execute(this.mClient, callback, "createNote", this.mAuthenticationToken, note);
    }

    public void updateNote(Note note, OnClientCallback<Note> callback) {
        AsyncReflector.execute(this.mClient, callback, "updateNote", this.mAuthenticationToken, note);
    }

    public void deleteNote(String guid, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "deleteNote", this.mAuthenticationToken, guid);
    }

    public void expungeNote(String guid, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "expungeNote", this.mAuthenticationToken, guid);
    }

    public void expungeNotes(List<String> noteGuids, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "expungeNotes", this.mAuthenticationToken, noteGuids);
    }

    public void expungeInactiveNotes(OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "expungeInactiveNotes", this.mAuthenticationToken);
    }

    public void copyNote(String noteGuid, String toNotebookGuid, OnClientCallback<Note> callback) {
        AsyncReflector.execute(this.mClient, callback, "copyNote", this.mAuthenticationToken, noteGuid, toNotebookGuid);
    }

    public void listNoteVersions(String noteGuid, OnClientCallback<List<NoteVersionId>> callback) {
        AsyncReflector.execute(this.mClient, callback, "listNoteVersions", this.mAuthenticationToken, noteGuid);
    }

    public void getNoteVersion(String noteGuid, int updateSequenceNum, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData, OnClientCallback<Note> callback) {
        AsyncReflector.execute(this.mClient, callback, "getNoteVersion", this.mAuthenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
    }

    public void getResource(String guid, boolean withData, boolean withRecognition, boolean withAttributes, boolean withAlternateData, OnClientCallback<Resource> callback) {
        AsyncReflector.execute(this.mClient, callback, "getResource", this.mAuthenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData);
    }

    public void getResourceApplicationData(String guid, OnClientCallback<LazyMap> callback) {
        AsyncReflector.execute(this.mClient, callback, "getResourceApplicationData", this.mAuthenticationToken, guid);
    }

    public void getResourceApplicationDataEntry(String guid, String key, OnClientCallback<String> callback) {
        AsyncReflector.execute(this.mClient, callback, "getResourceApplicationDataEntry", this.mAuthenticationToken, guid, key);
    }

    public void setResourceApplicationDataEntry(String guid, String key, String value, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "setResourceApplicationDataEntry", this.mAuthenticationToken, guid, key, value);
    }

    public void unsetResourceApplicationDataEntry(String guid, String key, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "unsetResourceApplicationDataEntry", this.mAuthenticationToken, guid, key);
    }

    public void updateResource(Resource resource, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "updateResource", this.mAuthenticationToken, resource);
    }

    public void getResourceData(String guid, OnClientCallback<byte[]> callback) {
        AsyncReflector.execute(this.mClient, callback, "getResourceData", this.mAuthenticationToken, guid);
    }

    public void getResourceByHash(String noteGuid, byte[] contentHash, boolean withData, boolean withRecognition, boolean withAlternateData, OnClientCallback<Resource> callback) {
        AsyncReflector.execute(this.mClient, callback, "getResourceByHash", this.mAuthenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData);
    }

    public void getResourceRecognition(String guid, OnClientCallback<byte[]> callback) {
        AsyncReflector.execute(this.mClient, callback, "getResourceRecognition", this.mAuthenticationToken);
    }

    public void getResourceAlternateData(String guid, OnClientCallback<byte[]> callback) {
        AsyncReflector.execute(this.mClient, callback, "getResourceAlternateData", this.mAuthenticationToken, guid);
    }

    public void getResourceAttributes(String guid, OnClientCallback<ResourceAttributes> callback) {
        AsyncReflector.execute(this.mClient, callback, "getResourceAttributes", this.mAuthenticationToken, guid);
    }

    public void getPublicNotebook(int userId, String publicUri, OnClientCallback<Notebook> callback) {
        AsyncReflector.execute(this.mClient, callback, "getPublicNotebook", this.mAuthenticationToken, userId, publicUri);
    }

    public void createSharedNotebook(SharedNotebook sharedNotebook, OnClientCallback<SharedNotebook> callback) {
        AsyncReflector.execute(this.mClient, callback, "createSharedNotebook", this.mAuthenticationToken, sharedNotebook);
    }

    public void updateSharedNotebook(SharedNotebook sharedNotebook, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "updateSharedNotebook", this.mAuthenticationToken, sharedNotebook);
    }

    public void sendMessageToSharedNotebookMembers(String notebookGuid, String messageText, List<String> recipients, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "sendMessageToSharedNotebookMembers", this.mAuthenticationToken, notebookGuid, messageText, recipients);
    }

    public void listSharedNotebooks(OnClientCallback<List<SharedNotebook>> callback) {
        AsyncReflector.execute(this.mClient, callback, "listSharedNotebooks", this.mAuthenticationToken);
    }

    public void expungeSharedNotebooks(List<Long> sharedNotebookIds, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "expungeSharedNotebooks", this.mAuthenticationToken, sharedNotebookIds);
    }

    public void createLinkedNotebook(LinkedNotebook linkedNotebook, OnClientCallback<LinkedNotebook> callback) {
        AsyncReflector.execute(this.mClient, callback, "createLinkedNotebook", this.mAuthenticationToken, linkedNotebook);
    }

    public void updateLinkedNotebook(LinkedNotebook linkedNotebook, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "updateLinkedNotebook", this.mAuthenticationToken, linkedNotebook);
    }

    public void listLinkedNotebooks(OnClientCallback<List<LinkedNotebook>> callback) {
        AsyncReflector.execute(this.mClient, callback, "listLinkedNotebooks", this.mAuthenticationToken);
    }

    public void expungeLinkedNotebook(String guid, OnClientCallback<Integer> callback) {
        AsyncReflector.execute(this.mClient, callback, "expungeLinkedNotebook", this.mAuthenticationToken);
    }

    public void authenticateToSharedNotebook(String shareKey, OnClientCallback<AuthenticationResult> callback) {
        AsyncReflector.execute(this.mClient, callback, "authenticateToSharedNotebook", this.mAuthenticationToken, shareKey);
    }

    public void getSharedNotebookByAuth(OnClientCallback<SharedNotebook> callback) {
        AsyncReflector.execute(this.mClient, callback, "getSharedNotebookByAuth", this.mAuthenticationToken);
    }

    public void emailNote(NoteEmailParameters parameters, OnClientCallback<Void> callback) {
        AsyncReflector.execute(this.mClient, callback, "emailNote", this.mAuthenticationToken, parameters);
    }

    public void shareNote(String guid, OnClientCallback<String> callback) {
        AsyncReflector.execute(this.mClient, callback, "shareNote", this.mAuthenticationToken, guid);
    }

    public void stopSharingNote(String guid, OnClientCallback<Void> callback) {
        AsyncReflector.execute(this.mClient, callback, "stopSharingNote", this.mAuthenticationToken, guid);
    }

    public void authenticateToSharedNote(String guid, String noteKey, String authToken, OnClientCallback<AuthenticationResult> callback) {
        AsyncReflector.execute(this.mClient, callback, "authenticateToSharedNote", guid, noteKey, authToken);
    }

    public void findRelated(RelatedQuery query, RelatedResultSpec resultSpec, OnClientCallback<RelatedResult> callback) {
        AsyncReflector.execute(this.mClient, callback, "findRelated", this.mAuthenticationToken, query, resultSpec);
    }

    public void setSharedNotebookRecipientSettings(long sharedNotebookId, SharedNotebookRecipientSettings recipientSettings, OnClientCallback<Integer> callback) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        AsyncReflector.execute(this.mClient, callback, "setSharedNotebookRecipientSettings", this.mAuthenticationToken, sharedNotebookId, recipientSettings);
    }
}

