/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.util.Log;
import com.evernote.client.android.AsyncUserStoreClient;
import com.evernote.client.android.ClientFactory;
import com.evernote.client.android.EvernoteSession;
import com.evernote.edam.userstore.BootstrapInfo;
import com.evernote.edam.userstore.BootstrapProfile;
import com.evernote.thrift.TException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class BootstrapManager {
    private static final String LOGTAG = "EvernoteSession";
    private static List<Locale> sChinaLocales = Arrays.asList(Locale.TRADITIONAL_CHINESE, Locale.CHINESE, Locale.CHINA, Locale.SIMPLIFIED_CHINESE);
    public static final String CHINA_PROFILE = "Evernote-China";
    public static final String DISPLAY_YXBIJI = "\u5370\u8c61\u7b14\u8bb0";
    public static final String DISPLAY_EVERNOTE = "Evernote";
    public static final String DISPLAY_EVERNOTE_INTL = "Evernote International";
    private ArrayList<String> mBootstrapServerUrls = new ArrayList();
    private AsyncUserStoreClient mUserStoreClient;
    private Locale mLocale;
    private ClientFactory mClientProducer;
    private String mBootstrapServerUsed;

    private BootstrapManager() {
    }

    BootstrapManager(EvernoteSession.EvernoteService service, ClientFactory producer) {
        this(service, producer, Locale.getDefault());
    }

    BootstrapManager(EvernoteSession.EvernoteService service, ClientFactory producer, Locale locale) {
        this.mLocale = locale;
        this.mClientProducer = producer;
        this.mBootstrapServerUrls.clear();
        switch (service) {
            case PRODUCTION: {
                if (sChinaLocales.contains(this.mLocale)) {
                    this.mBootstrapServerUrls.add("https://app.yinxiang.com");
                }
                this.mBootstrapServerUrls.add("https://www.evernote.com");
                break;
            }
            case SANDBOX: {
                this.mBootstrapServerUrls.add("https://sandbox.evernote.com");
            }
        }
    }

    private void initializeUserStoreAndCheckVersion() throws Exception {
        int i = 0;
        String version = "1.25";
        for (String url : this.mBootstrapServerUrls) {
            ++i;
            try {
                this.mUserStoreClient = this.mClientProducer.createUserStoreClient(url);
                if (!this.mUserStoreClient.getClient().checkVersion(this.mClientProducer.getUserAgent(), (short)1, (short)25)) {
                    this.mUserStoreClient = null;
                    throw new ClientUnsupportedException(version);
                }
                this.mBootstrapServerUsed = url;
                return;
            }
            catch (ClientUnsupportedException cue) {
                Log.e((String)LOGTAG, (String)"Invalid Version", (Throwable)cue);
                throw cue;
            }
            catch (Exception e) {
                this.mUserStoreClient = null;
                if (i < this.mBootstrapServerUrls.size()) {
                    Log.e((String)LOGTAG, (String)("Error contacting bootstrap server=" + url), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    BootstrapInfoWrapper getBootstrapInfo() throws Exception {
        Log.d((String)LOGTAG, (String)"getBootstrapInfo()");
        BootstrapInfo bsInfo = null;
        try {
            if (this.mUserStoreClient == null) {
                this.initializeUserStoreAndCheckVersion();
            }
            bsInfo = this.mUserStoreClient.getClient().getBootstrapInfo(this.mLocale.toString());
            this.printBootstrapInfo(bsInfo);
        }
        catch (ClientUnsupportedException cue) {
            throw cue;
        }
        catch (TException e) {
            Log.e((String)LOGTAG, (String)"error getting bootstrap info", (Throwable)e);
        }
        BootstrapInfoWrapper wrapper = new BootstrapInfoWrapper(this.mBootstrapServerUsed, bsInfo);
        return wrapper;
    }

    void printBootstrapInfo(BootstrapInfo bsInfo) {
        if (bsInfo == null) {
            return;
        }
        Log.d((String)LOGTAG, (String)"printBootstrapInfo");
        List profiles = bsInfo.getProfiles();
        if (profiles != null) {
            for (BootstrapProfile profile : profiles) {
                Log.d((String)LOGTAG, (String)profile.toString());
            }
        } else {
            Log.d((String)LOGTAG, (String)"Profiles are null");
        }
    }

    public static class ClientUnsupportedException
    extends Exception {
        public ClientUnsupportedException(String version) {
            super("Client version " + version + " not supported.");
        }
    }

    static class BootstrapInfoWrapper {
        private String mServerUrl;
        private BootstrapInfo mBootstrapInfo;

        BootstrapInfoWrapper(String serverUrl, BootstrapInfo info) {
            this.mServerUrl = serverUrl;
            this.mBootstrapInfo = info;
        }

        String getServerUrl() {
            return this.mServerUrl;
        }

        BootstrapInfo getBootstrapInfo() {
            return this.mBootstrapInfo;
        }
    }
}

