/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.evernote.client.android.AuthenticationResult;
import com.evernote.client.android.BootstrapManager;
import com.evernote.client.android.ClientFactory;
import com.evernote.client.android.EvernoteOAuthActivity;
import com.evernote.client.android.InvalidAuthenticationException;
import com.evernote.client.android.SessionPreferences;
import com.evernote.client.oauth.EvernoteAuthToken;
import java.util.Locale;

public class EvernoteSession {
    private static final String LOGTAG = "EvernoteSession";
    public static final String HOST_SANDBOX = "https://sandbox.evernote.com";
    public static final String HOST_PRODUCTION = "https://www.evernote.com";
    public static final String HOST_CHINA = "https://app.yinxiang.com";
    public static final int REQUEST_CODE_OAUTH = 14390;
    private static EvernoteSession sInstance = null;
    private String mConsumerKey;
    private String mConsumerSecret;
    private EvernoteService mEvernoteService;
    private BootstrapManager mBootstrapManager;
    private ClientFactory mClientFactory;
    private AuthenticationResult mAuthenticationResult;
    private boolean mSupportAppLinkedNotebooks;

    public static EvernoteSession getInstance(Context ctx, String consumerKey, String consumerSecret, EvernoteService evernoteService, boolean supportAppLinkedNotebooks) throws IllegalArgumentException {
        if (sInstance == null) {
            sInstance = new EvernoteSession(ctx, consumerKey, consumerSecret, evernoteService, supportAppLinkedNotebooks);
        }
        return sInstance;
    }

    static EvernoteSession getOpenSession() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvernoteSession(Context ctx, String consumerKey, String consumerSecret, EvernoteService evernoteService, boolean supportAppLinkedNotebooks) throws IllegalArgumentException {
        if (ctx == null || TextUtils.isEmpty((CharSequence)consumerKey) || TextUtils.isEmpty((CharSequence)consumerSecret) || evernoteService == null) {
            throw new IllegalArgumentException("Parameters canot be null or empty");
        }
        this.mConsumerKey = consumerKey;
        this.mConsumerSecret = consumerSecret;
        this.mEvernoteService = evernoteService;
        this.mSupportAppLinkedNotebooks = supportAppLinkedNotebooks;
        EvernoteSession evernoteSession = this;
        synchronized (evernoteSession) {
            this.mAuthenticationResult = this.getAuthenticationResultFromPref(SessionPreferences.getPreferences(ctx));
        }
        this.mClientFactory = new ClientFactory(this.generateUserAgentString(ctx), ctx.getFilesDir());
        this.mBootstrapManager = new BootstrapManager(this.mEvernoteService, this.mClientFactory);
    }

    protected BootstrapManager getBootstrapSession() {
        return this.mBootstrapManager;
    }

    public ClientFactory getClientFactory() {
        return this.mClientFactory;
    }

    private AuthenticationResult getAuthenticationResultFromPref(SharedPreferences prefs) {
        AuthenticationResult authResult = new AuthenticationResult(prefs);
        if (TextUtils.isEmpty((CharSequence)authResult.getEvernoteHost()) || TextUtils.isEmpty((CharSequence)authResult.getAuthToken()) || TextUtils.isEmpty((CharSequence)authResult.getNoteStoreUrl()) || TextUtils.isEmpty((CharSequence)authResult.getWebApiUrlPrefix()) || TextUtils.isEmpty((CharSequence)authResult.getEvernoteHost())) {
            return null;
        }
        return authResult;
    }

    public String getAuthToken() {
        if (this.mAuthenticationResult != null) {
            return this.mAuthenticationResult.getAuthToken();
        }
        return null;
    }

    public AuthenticationResult getAuthenticationResult() {
        return this.mAuthenticationResult;
    }

    private String generateUserAgentString(Context ctx) {
        String packageName = null;
        int packageVersion = 0;
        try {
            packageName = ctx.getPackageName();
            packageVersion = ctx.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)LOGTAG, (String)e.getMessage());
        }
        String userAgent = packageName + " Android/" + packageVersion;
        Locale locale = Locale.getDefault();
        userAgent = locale == null ? userAgent + " (" + Locale.US + ");" : userAgent + " (" + locale.toString() + "); ";
        userAgent = userAgent + "Android/" + Build.VERSION.RELEASE + "; ";
        userAgent = userAgent + Build.MODEL + "/" + Build.VERSION.SDK_INT + ";";
        return userAgent;
    }

    public void authenticate(Context ctx) {
        Intent intent = new Intent(ctx, EvernoteOAuthActivity.class);
        intent.putExtra("EVERNOTE_HOST", (Parcelable)this.mEvernoteService);
        intent.putExtra("CONSUMER_KEY", this.mConsumerKey);
        intent.putExtra("CONSUMER_SECRET", this.mConsumerSecret);
        intent.putExtra("SUPPORT_APP_LINKED_NOTEBOOKS", this.mSupportAppLinkedNotebooks);
        if (ctx instanceof Activity) {
            ((Activity)ctx).startActivityForResult(intent, 14390);
        } else {
            intent.addFlags(0x10000000);
            ctx.startActivity(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean persistAuthenticationToken(Context ctx, EvernoteAuthToken authToken, String evernoteHost) {
        if (ctx == null || authToken == null) {
            return false;
        }
        EvernoteSession evernoteSession = this;
        synchronized (evernoteSession) {
            this.mAuthenticationResult = new AuthenticationResult(authToken.getToken(), authToken.getNoteStoreUrl(), authToken.getWebApiUrlPrefix(), evernoteHost, authToken.getUserId(), authToken.isAppLinkedNotebook());
            this.mAuthenticationResult.persist(SessionPreferences.getPreferences(ctx));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoggedIn() {
        EvernoteSession evernoteSession = this;
        synchronized (evernoteSession) {
            return this.mAuthenticationResult != null;
        }
    }

    public boolean isAppLinkedNotebook() {
        return this.mAuthenticationResult.isAppLinkedNotebook();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOut(Context ctx) throws InvalidAuthenticationException {
        if (!this.isLoggedIn()) {
            throw new InvalidAuthenticationException("Must not call when already logged out");
        }
        EvernoteSession evernoteSession = this;
        synchronized (evernoteSession) {
            this.mAuthenticationResult.clear(SessionPreferences.getPreferences(ctx));
            this.mAuthenticationResult = null;
        }
        CookieSyncManager.createInstance((Context)ctx);
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.removeAllCookie();
    }

    public static enum EvernoteService implements Parcelable
    {
        SANDBOX,
        PRODUCTION;

        public static final Parcelable.Creator<EvernoteService> CREATOR;

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<EvernoteService>(){

                public EvernoteService createFromParcel(Parcel source) {
                    return EvernoteService.values()[source.readInt()];
                }

                public EvernoteService[] newArray(int size) {
                    return new EvernoteService[size];
                }
            };
        }
    }
}

