/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import com.evernote.edam.type.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EvernoteUtil {
    public static final String NOTE_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\"><en-note>";
    public static final String NOTE_SUFFIX = "</en-note>";
    private static final String EDAM_HASH_ALGORITHM = "MD5";

    public static String createEnMediaTag(Resource resource) {
        return "<en-media hash=\"" + EvernoteUtil.bytesToHex(resource.getData().getBodyHash()) + "\" type=\"" + resource.getMime() + "\"/>";
    }

    public static byte[] hash(byte[] body) {
        try {
            return MessageDigest.getInstance(EDAM_HASH_ALGORITHM).digest(body);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EvernoteUtilException("MD5 not supported", e);
        }
    }

    public static byte[] hash(InputStream in) throws IOException {
        int n;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(EDAM_HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EvernoteUtilException("MD5 not supported", e);
        }
        byte[] buf = new byte[1024];
        while ((n = in.read(buf)) != -1) {
            digest.update(buf, 0, n);
        }
        return digest.digest();
    }

    public static String bytesToHex(byte[] bytes) {
        return EvernoteUtil.bytesToHex(bytes, false);
    }

    public static String bytesToHex(byte[] bytes, boolean withSpaces) {
        StringBuilder sb = new StringBuilder();
        for (byte hashByte : bytes) {
            int intVal = 0xFF & hashByte;
            if (intVal < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(intVal));
            if (!withSpaces) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String hexString) {
        byte[] result = new byte[hexString.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            int offset = i * 2;
            result[i] = (byte)Integer.parseInt(hexString.substring(offset, offset + 2), 16);
        }
        return result;
    }

    private static final class EvernoteUtilException
    extends RuntimeException {
        public EvernoteUtilException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

