/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.android;

import com.evernote.client.android.AsyncReflector;
import com.evernote.client.android.OnClientCallback;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.PremiumInfo;
import com.evernote.edam.type.User;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.edam.userstore.BootstrapInfo;
import com.evernote.edam.userstore.PublicUserInfo;
import com.evernote.edam.userstore.UserStore;
import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TProtocol;

public class AsyncUserStoreClient {
    private final String mAuthenticationToken;
    private final UserStore.Client mClient;

    AsyncUserStoreClient(TProtocol prot, String authenticationToken) {
        this.mClient = new UserStore.Client(prot);
        this.mAuthenticationToken = authenticationToken;
    }

    AsyncUserStoreClient(TProtocol iprot, TProtocol oprot, String authenticationToken) {
        this.mClient = new UserStore.Client(iprot, oprot);
        this.mAuthenticationToken = authenticationToken;
    }

    public UserStore.Client getClient() {
        return this.mClient;
    }

    String getAuthenticationToken() {
        return this.mAuthenticationToken;
    }

    public void isBusinessUserAsync(OnClientCallback<Boolean> callback) {
        AsyncReflector.execute(this, callback, "isBusinessUser", new Object[0]);
    }

    public boolean isBusinessUser() throws TException, EDAMUserException, EDAMSystemException {
        return this.getClient().getUser(this.getAuthenticationToken()).getAccounting().isSetBusinessId();
    }

    public void checkVersion(String clientName, short edamVersionMajor, short edamVersionMinor, OnClientCallback<Boolean> callback) {
        AsyncReflector.execute(this.mClient, callback, "checkVersion", clientName, edamVersionMajor, edamVersionMinor);
    }

    public void getBootstrapInfo(String locale, OnClientCallback<BootstrapInfo> callback) {
        AsyncReflector.execute(this.mClient, callback, "getBootstrapInfo", locale);
    }

    public void authenticate(String username, String password, String consumerKey, String consumerSecret, boolean supportsTwoFactor, OnClientCallback<AuthenticationResult> callback) {
        AsyncReflector.execute(this.mClient, callback, "authenticate", username, password, consumerKey, consumerSecret, supportsTwoFactor);
    }

    public void authenticateLongSession(String username, String password, String consumerKey, String consumerSecret, String deviceIdentifier, String deviceDescription, boolean supportsTwoFactor, OnClientCallback<AuthenticationResult> callback) {
        AsyncReflector.execute(this.mClient, callback, "authenticateLongSession", username, password, consumerKey, consumerSecret, deviceIdentifier, deviceDescription, supportsTwoFactor);
    }

    public void authenticateToBusiness(String authenticationToken, OnClientCallback<AuthenticationResult> callback) {
        AsyncReflector.execute(this.mClient, callback, "authenticateToBusiness", authenticationToken);
    }

    public void refreshAuthentication(String authenticationToken, OnClientCallback<AuthenticationResult> callback) {
        AsyncReflector.execute(this.mClient, callback, "refreshAuthentication", authenticationToken);
    }

    public void getUser(OnClientCallback<User> callback) {
        AsyncReflector.execute(this.mClient, callback, "getUser", this.mAuthenticationToken);
    }

    public void getPublicUserInfo(String username, OnClientCallback<PublicUserInfo> callback) {
        AsyncReflector.execute(this.mClient, callback, "getPublicUserInfo", username);
    }

    public void getPremiumInfo(OnClientCallback<PremiumInfo> callback) {
        AsyncReflector.execute(this.mClient, callback, "getPremiumInfo", this.mAuthenticationToken);
    }

    public void getNoteStoreUrl(OnClientCallback<String> callback) {
        AsyncReflector.execute(this.mClient, callback, "getNoteStoreUrl", this.mAuthenticationToken);
    }

    public void revokeLongSession(OnClientCallback<Void> callback) throws EDAMUserException, EDAMSystemException, TException {
        AsyncReflector.execute(this.mClient, callback, "revokeLongSession", this.mAuthenticationToken);
    }

    public void completeTwoFactorAuthentication(String oneTimeCode, String deviceIdentifier, String deviceDescription, OnClientCallback<AuthenticationResult> callback) throws EDAMUserException, EDAMSystemException, TException {
        AsyncReflector.execute(this.mClient, callback, "completeTwoFactorAuthentication", this.mAuthenticationToken, oneTimeCode, deviceIdentifier, deviceDescription);
    }
}

