/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.client.conn.mobile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DiskBackedByteStore
extends OutputStream {
    protected File file;
    protected int maxMemory;
    protected FileOutputStream fileoutputStream = null;
    protected ByteArrayOutputStream byteArray = null;
    protected FileInputStream fileInputStream = null;
    protected OutputStream current = null;
    protected int size = 0;
    protected Exception exception;
    protected File tempPath;

    public DiskBackedByteStore(File file, int maxMemory) {
        this.file = file;
        this.maxMemory = maxMemory;
    }

    public DiskBackedByteStore(File parentDir, String prefix, int maxMemory) throws IOException {
        parentDir.mkdirs();
        this.tempPath = parentDir;
        this.file = this.makeTempFile();
        this.maxMemory = maxMemory;
    }

    protected File makeTempFile() {
        return new File(this.tempPath, Math.random() * 9.223372036854776E18 + ".tft");
    }

    @Override
    public void write(byte[] buffer, int offset, int count) {
        this.initBuffers();
        try {
            if (this.isSwapRequired(count)) {
                this.swapToDisk();
            }
            this.size += count;
            this.current.write(buffer, offset, count);
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private boolean isSwapRequired(int delta) {
        return this.size + delta > this.maxMemory && this.byteArray != null;
    }

    @Override
    public void write(int oneByte) {
        try {
            this.initBuffers();
            if (this.isSwapRequired(1)) {
                this.swapToDisk();
            }
            ++this.size;
            this.current.write(oneByte);
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void initBuffers() {
        if (this.current == null) {
            this.byteArray = new ByteArrayOutputStream();
            this.current = this.byteArray;
        }
    }

    protected void swapToDisk() throws FileNotFoundException, IOException {
        this.fileoutputStream = new FileOutputStream(this.file);
        this.byteArray.writeTo(this.fileoutputStream);
        this.byteArray = null;
        this.current = this.fileoutputStream;
    }

    public void clear() {
        this.byteArray = null;
        this.current = null;
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fileInputStream = null;
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    public InputStream getInputStream() throws IOException {
        this.current.close();
        if (this.byteArray != null) {
            return new ByteArrayInputStream(this.byteArray.toByteArray());
        }
        this.fileInputStream = new FileInputStream(this.file);
        return this.fileInputStream;
    }

    public Exception getException() {
        return this.exception;
    }

    public void reset() throws IOException {
        this.clear();
        if (this.file.isFile()) {
            this.file.delete();
        }
        this.file = this.makeTempFile();
        this.exception = null;
    }
}

