/*
 * Decompiled with CFR 0.152.
 */
package com.five.adwoad.mraid;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.five.adwoad.mraid.AdAlertGestureListener$ZigZagState;

public class AdAlertGestureListener
extends GestureDetector.SimpleOnGestureListener {
    private static final int MINIMUM_NUMBER_OF_ZIGZAGS_TO_FLAG = 4;
    private static final float MAXIMUM_THRESHOLD_X_IN_DIPS = 100.0f;
    private static final float MAXIMUM_THRESHOLD_Y_IN_DIPS = 50.0f;
    private float mCurrentThresholdInDips = 100.0f;
    private float mPreviousPositionX;
    private boolean mHasCrossedLeftThreshold;
    private boolean mHasCrossedRightThreshold;
    private int mNumberOfZigZags;
    private float mPivotPositionX;
    private AdAlertGestureListener$ZigZagState mCurrentZigZagState = AdAlertGestureListener$ZigZagState.UNSET;

    AdAlertGestureListener(View view) {
        if (view != null && view.getWidth() > 0) {
            this.mCurrentThresholdInDips = Math.min(100.0f, (float)view.getWidth() / 3.0f);
        }
    }

    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f2, float f3) {
        if (this.mCurrentZigZagState == AdAlertGestureListener$ZigZagState.FINISHED) {
            return super.onScroll(motionEvent, motionEvent2, f2, f3);
        }
        if (this.isTouchOutOfBoundsOnYAxis(motionEvent.getY(), motionEvent2.getY())) {
            this.mCurrentZigZagState = AdAlertGestureListener$ZigZagState.FAILED;
            return super.onScroll(motionEvent, motionEvent2, f2, f3);
        }
        switch (this.mCurrentZigZagState) {
            case UNSET: {
                this.mPivotPositionX = motionEvent.getX();
                this.updateInitialState(motionEvent2.getX());
                break;
            }
            case GOING_RIGHT: {
                this.updateZig(motionEvent2.getX());
                break;
            }
            case GOING_LEFT: {
                this.updateZag(motionEvent2.getX());
            }
        }
        this.mPreviousPositionX = motionEvent2.getX();
        return super.onScroll(motionEvent, motionEvent2, f2, f3);
    }

    void finishGestureDetection() {
        this.reset();
    }

    void reset() {
        this.mNumberOfZigZags = 0;
        this.mCurrentZigZagState = AdAlertGestureListener$ZigZagState.UNSET;
    }

    private boolean isTouchOutOfBoundsOnYAxis(float f2, float f3) {
        return Math.abs(f3 - f2) > 50.0f;
    }

    private void updateInitialState(float f2) {
        if (f2 > this.mPivotPositionX) {
            this.mCurrentZigZagState = AdAlertGestureListener$ZigZagState.GOING_RIGHT;
        }
    }

    private void updateZig(float f2) {
        if (this.rightThresholdReached(f2) && this.isMovingLeft(f2)) {
            this.mCurrentZigZagState = AdAlertGestureListener$ZigZagState.GOING_LEFT;
            this.mPivotPositionX = f2;
        }
    }

    private void updateZag(float f2) {
        if (this.leftThresholdReached(f2) && this.isMovingRight(f2)) {
            this.mCurrentZigZagState = AdAlertGestureListener$ZigZagState.GOING_RIGHT;
            this.mPivotPositionX = f2;
        }
    }

    private void incrementNumberOfZigZags() {
        ++this.mNumberOfZigZags;
        if (this.mNumberOfZigZags >= 4) {
            this.mCurrentZigZagState = AdAlertGestureListener$ZigZagState.FINISHED;
        }
    }

    private boolean rightThresholdReached(float f2) {
        if (this.mHasCrossedRightThreshold) {
            return true;
        }
        if (f2 >= this.mPivotPositionX + this.mCurrentThresholdInDips) {
            this.mHasCrossedLeftThreshold = false;
            this.mHasCrossedRightThreshold = true;
            return true;
        }
        return false;
    }

    private boolean leftThresholdReached(float f2) {
        if (this.mHasCrossedLeftThreshold) {
            return true;
        }
        if (f2 <= this.mPivotPositionX - this.mCurrentThresholdInDips) {
            this.mHasCrossedRightThreshold = false;
            this.mHasCrossedLeftThreshold = true;
            this.incrementNumberOfZigZags();
            return true;
        }
        return false;
    }

    private boolean isMovingRight(float f2) {
        return f2 > this.mPreviousPositionX;
    }

    private boolean isMovingLeft(float f2) {
        return f2 < this.mPreviousPositionX;
    }

    @Deprecated
    int getNumberOfZigzags() {
        return this.mNumberOfZigZags;
    }

    @Deprecated
    float getMinimumDipsInZigZag() {
        return this.mCurrentThresholdInDips;
    }

    @Deprecated
    AdAlertGestureListener$ZigZagState getCurrentZigZagState() {
        return this.mCurrentZigZagState;
    }
}

