/*
 * Decompiled with CFR 0.152.
 */
package com.five.adwoad.mraid;

import android.content.Context;
import android.location.Location;
import android.net.ConnectivityManager;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class AdViewController {
    static final int MINIMUM_REFRESH_TIME_MILLISECONDS = 10000;
    static final int DEFAULT_REFRESH_TIME_MILLISECONDS = 60000;
    private static WeakHashMap sViewShouldHonorServerDimensions = new WeakHashMap();
    private Context mContext;
    private Runnable mRefreshRunnable;
    private boolean mIsDestroyed;
    private Handler mHandler;
    private boolean mIsLoading;
    private String mUrl;
    private Map mLocalExtras = new HashMap();
    private boolean mAutoRefreshEnabled = true;
    private String mKeywords;
    private Location mLocation;
    private boolean mIsFacebookSupported = true;
    private boolean mIsTesting;

    protected static void setShouldHonorServerDimensions(View view) {
        sViewShouldHonorServerDimensions.put(view, true);
    }

    public void loadAd() {
        if (!this.isNetworkAvailable()) {
            Log.d((String)"MoPub", (String)"Can't load an ad because there is no network connectivity.");
            this.scheduleRefreshTimerIfEnabled();
            return;
        }
    }

    void loadNonJavascript(String string) {
        if (string == null) {
            return;
        }
        Log.d((String)"Adwo", (String)("Loading url: " + string));
        if (this.mIsLoading) {
            return;
        }
        this.mUrl = string;
        this.mIsLoading = true;
        this.fetchAd(this.mUrl);
    }

    public void reload() {
        Log.d((String)"Adwo", (String)("Reload ad: " + this.mUrl));
        this.loadNonJavascript(this.mUrl);
    }

    void setFailUrl(String string) {
    }

    void setNotLoading() {
        this.mIsLoading = false;
    }

    public String getKeywords() {
        return this.mKeywords;
    }

    public void setKeywords(String string) {
        this.mKeywords = string;
    }

    public boolean isFacebookSupported() {
        return this.mIsFacebookSupported;
    }

    public void setFacebookSupported(boolean bl2) {
        this.mIsFacebookSupported = bl2;
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public void setLocation(Location location) {
        this.mLocation = location;
    }

    public void setTimeout(int n2) {
    }

    public boolean getAutorefreshEnabled() {
        return this.mAutoRefreshEnabled;
    }

    public void setAutorefreshEnabled(boolean bl2) {
        this.mAutoRefreshEnabled = bl2;
        if (this.mAutoRefreshEnabled) {
            this.scheduleRefreshTimerIfEnabled();
            return;
        }
        this.cancelRefreshTimer();
    }

    public boolean getTesting() {
        return this.mIsTesting;
    }

    public void setTesting(boolean bl2) {
        this.mIsTesting = bl2;
    }

    boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    void cleanup() {
        if (this.mIsDestroyed) {
            return;
        }
        this.setAutorefreshEnabled(false);
        this.cancelRefreshTimer();
        this.mIsDestroyed = true;
    }

    void trackImpression() {
    }

    void registerClick() {
    }

    void fetchAd(String string) {
    }

    void forceRefresh() {
        this.setNotLoading();
        this.loadAd();
    }

    void scheduleRefreshTimerIfEnabled() {
    }

    void setLocalExtras(Map map) {
        this.mLocalExtras = map != null ? new HashMap(map) : new HashMap();
    }

    Map getLocalExtras() {
        if (this.mLocalExtras != null) {
            return new HashMap(this.mLocalExtras);
        }
        return new HashMap();
    }

    private void cancelRefreshTimer() {
        this.mHandler.removeCallbacks(this.mRefreshRunnable);
    }

    private boolean isNetworkAvailable() {
        int n2 = this.mContext.checkCallingPermission("android.permission.ACCESS_NETWORK_STATE");
        if (n2 == -1) {
            return true;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        return (connectivityManager = connectivityManager.getActiveNetworkInfo()) != null && connectivityManager.isConnected();
    }

    @Deprecated
    public void customEventDidLoadAd() {
        this.setNotLoading();
        this.trackImpression();
        this.scheduleRefreshTimerIfEnabled();
    }

    @Deprecated
    public void customEventActionWillBegin() {
        this.registerClick();
    }
}

