/*
 * Decompiled with CFR 0.152.
 */
package com.five.adwoad.mraid;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.five.adwoad.mraid.Drawables;
import com.five.adwoad.mraid.MraidBrowser$1;
import com.five.adwoad.mraid.MraidBrowser$2;
import com.five.adwoad.mraid.MraidBrowser$3;
import com.five.adwoad.mraid.MraidBrowser$4;
import com.five.adwoad.mraid.MraidBrowser$5;
import com.five.adwoad.mraid.MraidBrowser$6;

public class MraidBrowser
extends Activity {
    public static final String URL_EXTRA = "extra_url";
    public static final int INNER_LAYOUT_ID = 1;
    private WebView mWebView;
    private ImageButton mBackButton;
    private ImageButton mForwardButton;
    private ImageButton mRefreshButton;
    private ImageButton mCloseButton;

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getWindow().requestFeature(2);
        this.getWindow().setFeatureInt(2, -1);
        this.setContentView(this.getMraidBrowserView());
        bundle = this.getIntent();
        this.initializeWebView((Intent)bundle);
        this.initializeButtons();
        this.enableCookies();
    }

    private void initializeWebView(Intent intent) {
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(true);
        this.mWebView.loadUrl(intent.getStringExtra(URL_EXTRA));
        this.mWebView.setWebViewClient((WebViewClient)new MraidBrowser$1(this));
        this.mWebView.setWebChromeClient((WebChromeClient)new MraidBrowser$2(this));
    }

    private void initializeButtons() {
        this.mBackButton.setBackgroundColor(0);
        this.mBackButton.setOnClickListener((View.OnClickListener)new MraidBrowser$3(this));
        this.mForwardButton.setBackgroundColor(0);
        this.mForwardButton.setOnClickListener((View.OnClickListener)new MraidBrowser$4(this));
        this.mRefreshButton.setBackgroundColor(0);
        this.mRefreshButton.setOnClickListener((View.OnClickListener)new MraidBrowser$5(this));
        this.mCloseButton.setBackgroundColor(0);
        this.mCloseButton.setOnClickListener((View.OnClickListener)new MraidBrowser$6(this));
    }

    private void enableCookies() {
        CookieSyncManager.createInstance((Context)this);
        CookieSyncManager.getInstance().startSync();
    }

    protected void onPause() {
        super.onPause();
        CookieSyncManager.getInstance().stopSync();
    }

    protected void onResume() {
        super.onResume();
        CookieSyncManager.getInstance().startSync();
    }

    private View getMraidBrowserView() {
        LinearLayout linearLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout.setOrientation(1);
        layoutParams = new RelativeLayout((Context)this);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        linearLayout.addView((View)layoutParams);
        layoutParams2 = new LinearLayout((Context)this);
        layoutParams2.setId(1);
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams3.addRule(12);
        layoutParams2.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        layoutParams2.setBackgroundDrawable((Drawable)Drawables.BACKGROUND.decodeImage((Context)this));
        layoutParams.addView((View)layoutParams2);
        this.mBackButton = this.getButton((Drawable)Drawables.LEFT_ARROW.decodeImage((Context)this));
        this.mForwardButton = this.getButton((Drawable)Drawables.RIGHT_ARROW.decodeImage((Context)this));
        this.mRefreshButton = this.getButton((Drawable)Drawables.REFRESH.decodeImage((Context)this));
        this.mCloseButton = this.getButton((Drawable)Drawables.CLOSE.decodeImage((Context)this));
        layoutParams2.addView((View)this.mBackButton);
        layoutParams2.addView((View)this.mForwardButton);
        layoutParams2.addView((View)this.mRefreshButton);
        layoutParams2.addView((View)this.mCloseButton);
        this.mWebView = new WebView((Context)this);
        layoutParams2 = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams2.addRule(2, 1);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        layoutParams.addView((View)this.mWebView);
        return linearLayout;
    }

    private ImageButton getButton(Drawable drawable) {
        ImageButton imageButton = new ImageButton((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        new LinearLayout.LayoutParams(-2, -2, 1.0f).gravity = 16;
        imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageButton.setImageDrawable(drawable);
        return imageButton;
    }

    static /* synthetic */ ImageButton access$0(MraidBrowser mraidBrowser) {
        return mraidBrowser.mForwardButton;
    }

    static /* synthetic */ ImageButton access$1(MraidBrowser mraidBrowser) {
        return mraidBrowser.mBackButton;
    }

    static /* synthetic */ WebView access$2(MraidBrowser mraidBrowser) {
        return mraidBrowser.mWebView;
    }
}

