/*
 * Decompiled with CFR 0.152.
 */
package com.five.adwoad.mraid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.five.adwoad.MraidView;
import com.five.adwoad.mraid.MraidAbstractController;
import com.five.adwoad.mraid.Utils;

public class MraidBrowserController
extends MraidAbstractController {
    private static final String LOGTAG = "MraidBrowserController";
    private Context mContext;

    public MraidBrowserController(MraidView mraidView) {
        super(mraidView);
        this.mContext = mraidView.getContext();
    }

    protected void open(String string) {
        Log.d((String)LOGTAG, (String)("Opening url: " + string));
        MraidView mraidView = this.getMraidView();
        if (mraidView.getOnOpenListener$24a78177() != null) {
            mraidView.getOnOpenListener$24a78177();
        }
        if (!this.isWebSiteUrl(string) && this.canHandleApplicationUrl(string)) {
            this.launchApplicationUrl(string);
            return;
        }
        mraidView = new Intent();
        try {
            ComponentName componentName = new ComponentName("com.android.browser", "com.android.browser.BrowserActivity");
            mraidView.setComponent(componentName);
            mraidView.setAction("android.intent.action.VIEW");
            mraidView.setData(Uri.parse((String)string));
            mraidView.addFlags(0x10000000);
            this.mContext.startActivity((Intent)mraidView);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private boolean canHandleApplicationUrl(String string) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
        if (!Utils.deviceCanHandleIntent(this.mContext, intent)) {
            Log.w((String)"Adwo", (String)("Could not handle application specific action: " + string + ". " + "You may be running in the emulator or another device which does not " + "have the required application."));
            return false;
        }
        return true;
    }

    private boolean launchApplicationUrl(String string) {
        string = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
        string.addFlags(0x10000000);
        String string2 = "Unable to open intent.";
        return this.executeIntent(this.getMraidView().getContext(), (Intent)string, string2);
    }

    private boolean executeIntent(Context context, Intent intent, String string) {
        try {
            context.startActivity(intent);
        }
        catch (Exception exception) {
            Log.d((String)"Adwo", (String)(string != null ? string : "Unable to start intent."));
            return false;
        }
        return true;
    }

    private boolean isWebSiteUrl(String string) {
        return string.startsWith("http://") || string.startsWith("https://");
    }
}

