/*
 * Decompiled with CFR 0.152.
 */
package com.five.adwoad.mraid;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Environment;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.URLUtil;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.five.adwoad.MraidView;
import com.five.adwoad.aO;
import com.five.adwoad.aS;
import com.five.adwoad.aU;
import com.five.adwoad.aV;
import com.five.adwoad.mraid.Drawables;
import com.five.adwoad.mraid.MraidAbstractController;
import com.five.adwoad.mraid.MraidCommandFactory$MraidJavascriptCommand;
import com.five.adwoad.mraid.MraidDisplayController$1;
import com.five.adwoad.mraid.MraidDisplayController$2;
import com.five.adwoad.mraid.MraidDisplayController$3;
import com.five.adwoad.mraid.MraidDisplayController$4;
import com.five.adwoad.mraid.MraidDisplayController$5;
import com.five.adwoad.mraid.MraidDisplayController$6;
import com.five.adwoad.mraid.MraidDisplayController$7;
import com.five.adwoad.mraid.MraidDisplayController$8;
import com.five.adwoad.mraid.MraidDisplayController$OrientationBroadcastReceiver;
import com.five.adwoad.mraid.MraidProperty;
import com.five.adwoad.mraid.MraidScreenSizeProperty;
import com.five.adwoad.mraid.MraidStateProperty;
import com.five.adwoad.mraid.MraidSupportsProperty;
import com.five.adwoad.mraid.MraidViewableProperty;
import com.five.adwoad.mraid.Mraids;
import java.io.File;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;

public class MraidDisplayController
extends MraidAbstractController {
    private static final String LOGTAG = "MraidDisplayController";
    private static final long VIEWABILITY_TIMER_MILLIS = 3000L;
    private static final int CLOSE_BUTTON_SIZE_DP = 50;
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ssZZZZZ", "yyyy-MM-dd'T'HH:mmZZZZZ"};
    private static final int MAX_NUMBER_DAYS_IN_MONTH = 31;
    private aV mViewState = aV.dz;
    private final aO mExpansionStyle;
    private final aS mNativeCloseButtonStyle;
    private MraidView mTwoPartExpansionView;
    private FrameLayout mRootView;
    private boolean mIsViewable;
    private Runnable mCheckViewabilityTask = new MraidDisplayController$1(this);
    private Handler mHandler = new Handler();
    private final int mOriginalRequestedOrientation;
    private MraidDisplayController$OrientationBroadcastReceiver mOrientationBroadcastReceiver = new MraidDisplayController$OrientationBroadcastReceiver(this);
    private ImageView mCloseButton;
    private boolean mAdWantsCustomCloseButton;
    protected float mDensity;
    protected int mScreenWidth = -1;
    protected int mScreenHeight = -1;
    private int mViewIndexInParent;
    private FrameLayout mPlaceholderView;
    private FrameLayout mAdContainerLayout;
    private RelativeLayout mExpansionLayout;

    public MraidDisplayController(MraidView mraidView, aO aO2, aS aS2) {
        super(mraidView);
        this.mExpansionStyle = aO2;
        this.mNativeCloseButtonStyle = aS2;
        mraidView = this.getContext();
        this.mOriginalRequestedOrientation = mraidView instanceof Activity ? ((Activity)mraidView).getRequestedOrientation() : -1;
        this.mAdContainerLayout = this.createAdContainerLayout();
        this.mExpansionLayout = this.createExpansionLayout();
        this.mPlaceholderView = this.createPlaceholderView();
        this.initialize();
    }

    private void initialize() {
        this.mViewState = aV.dw;
        this.initializeScreenMetrics();
        this.initializeViewabilityTimer();
        this.mOrientationBroadcastReceiver.register(this.getContext());
    }

    private void initializeScreenMetrics() {
        Context context = this.getContext();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        this.mDensity = displayMetrics.density;
        int n2 = 0;
        int n3 = 0;
        if (context instanceof Activity) {
            context = (Activity)context;
            Window window = context.getWindow();
            context = new Rect();
            window.getDecorView().getWindowVisibleDisplayFrame((Rect)context);
            n2 = context.top;
            int n4 = window.findViewById(0x1020002).getTop();
            n3 = n4 - n2;
        }
        int n5 = displayMetrics.widthPixels;
        n3 = displayMetrics.heightPixels - n2 - n3;
        this.mScreenWidth = (int)((double)n5 * (160.0 / (double)displayMetrics.densityDpi));
        this.mScreenHeight = (int)((double)n3 * (160.0 / (double)displayMetrics.densityDpi));
    }

    private void initializeViewabilityTimer() {
        this.mHandler.removeCallbacks(this.mCheckViewabilityTask);
        this.mHandler.post(this.mCheckViewabilityTask);
    }

    private int getDisplayRotation() {
        WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
        return windowManager.getDefaultDisplay().getOrientation();
    }

    private void onOrientationChanged(int n2) {
        this.initializeScreenMetrics();
        this.getMraidView().fireChangeEventForProperty(MraidScreenSizeProperty.createWithSize(this.mScreenWidth, this.mScreenHeight));
    }

    public void destroy() {
        this.mHandler.removeCallbacks(this.mCheckViewabilityTask);
        try {
            this.mOrientationBroadcastReceiver.unregister();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
            if (!illegalArgumentException.getMessage().contains("Receiver not registered")) {
                throw illegalArgumentException2;
            }
            return;
        }
    }

    public void initializeJavaScriptState() {
        ArrayList<MraidProperty> arrayList = new ArrayList<MraidProperty>();
        arrayList.add(MraidScreenSizeProperty.createWithSize(this.mScreenWidth, this.mScreenHeight));
        arrayList.add(MraidViewableProperty.createWithViewable(this.mIsViewable));
        this.getMraidView().fireChangeEventForProperties(arrayList);
        this.mViewState = aV.dx;
        this.getMraidView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        this.initializeSupportedFunctionsProperty();
    }

    protected boolean isExpanded() {
        return this.mViewState == aV.dy;
    }

    protected void close() {
        if (this.mViewState == aV.dy) {
            this.resetViewToDefaultState();
            this.setOrientationLockEnabled(false);
            this.mViewState = aV.dx;
            this.getMraidView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        } else if (this.mViewState == aV.dx) {
            this.getMraidView().setVisibility(4);
            this.mViewState = aV.dz;
            this.getMraidView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        }
        if (this.getMraidView().getMraidListener() != null) {
            this.getMraidView().getMraidListener().onClose(this.getMraidView(), this.mViewState);
        }
    }

    private void resetViewToDefaultState() {
        this.setNativeCloseButtonEnabled(false);
        this.mAdContainerLayout.removeAllViewsInLayout();
        this.mExpansionLayout.removeAllViewsInLayout();
        this.mRootView.removeView((View)this.mExpansionLayout);
        this.getMraidView().requestLayout();
        ViewGroup viewGroup = (ViewGroup)this.mPlaceholderView.getParent();
        viewGroup.addView((View)this.getMraidView(), this.mViewIndexInParent);
        viewGroup.removeView((View)this.mPlaceholderView);
        viewGroup.invalidate();
    }

    protected void expand(String string, int n2, int n3, boolean bl2, boolean bl3) {
        if (this.mExpansionStyle == aO.dk) {
            return;
        }
        if (string != null && !URLUtil.isValidUrl((String)string)) {
            this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.EXPAND, "URL passed to expand() was invalid.");
            return;
        }
        this.mRootView = (FrameLayout)this.getMraidView().getRootView().findViewById(0x1020002);
        this.useCustomClose(bl2);
        this.setOrientationLockEnabled(bl3);
        this.swapViewWithPlaceholderView();
        MraidView mraidView = this.getMraidView();
        if (string != null) {
            this.mTwoPartExpansionView = new MraidView(this.getContext(), aO.dk, aS.dr, aU.dt);
            this.mTwoPartExpansionView.setMraidListener(new MraidDisplayController$2(this));
            this.mTwoPartExpansionView.loadUrl(string);
            mraidView = this.mTwoPartExpansionView;
        }
        this.expandLayouts((View)mraidView, (int)((float)n2 * this.mDensity), (int)((float)n3 * this.mDensity));
        this.mRootView.addView((View)this.mExpansionLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (this.mNativeCloseButtonStyle == aS.dp || !this.mAdWantsCustomCloseButton && this.mNativeCloseButtonStyle != aS.dq) {
            this.setNativeCloseButtonEnabled(true);
        }
        this.mViewState = aV.dy;
        this.getMraidView().fireChangeEventForProperty(MraidStateProperty.createWithViewState(this.mViewState));
        if (this.getMraidView().getMraidListener() != null) {
            this.getMraidView().getMraidListener().onExpand(this.getMraidView());
        }
    }

    protected void showUserDownloadImageAlert(String string) {
        Context context = this.getContext();
        if (!Mraids.isStorePictureSupported(context)) {
            this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.STORE_PICTURE, "Error downloading file - the device does not have an SD card mounted, or the Android permission is not granted.");
            Log.d((String)"Adwo", (String)"Error downloading file - the device does not have an SD card mounted, or the Android permission is not granted.");
            return;
        }
        if (context instanceof Activity) {
            this.showUserDialog(string);
            return;
        }
        this.showUserToast("Downloading image to Picture gallery...");
        this.downloadImage(string);
    }

    private void showUserToast(String string) {
        this.mHandler.post((Runnable)new MraidDisplayController$3(this, string));
    }

    private void downloadImage(String string) {
        File file = this.getPictureStoragePath();
        file.mkdirs();
        new Thread(new MraidDisplayController$4(this, string, file)).start();
    }

    private void showUserDialog(String string) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)"Save Image").setMessage((CharSequence)"Download image to Picture gallery?").setNegativeButton((CharSequence)"Cancel", null).setPositiveButton((CharSequence)"Okay", (DialogInterface.OnClickListener)new MraidDisplayController$5(this, string)).setCancelable(true).show();
    }

    protected void showVideo(String string) {
        Context context = this.getMraidView().getActivityContext();
        if (context instanceof Activity) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            this.mHandler.post((Runnable)new MraidDisplayController$6(this, context, string, windowManager));
            return;
        }
        this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.PLAY_VIDEO, "Failed to play the video.");
    }

    protected void getCurrentPosition() {
        this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.GET_CURRENT_POSITION, "Unsupported action getCurrentPosition");
    }

    protected void getDefaultPosition() {
        this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.GET_DEFAULT_POSITION, "Unsupported action getDefaultPosition");
    }

    protected void getMaxSize() {
        this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.GET_MAX_SIZE, "Unsupported action getMaxSize");
    }

    protected void getScreenSize() {
        this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.GET_SCREEN_SIZE, "Unsupported action getScreenSize");
    }

    protected void createCalendarEvent(Map map) {
        Context context = this.getMraidView().getContext();
        if (Mraids.isCalendarAvailable(context)) {
            try {
                map = this.translateJSParamsToAndroidCalendarEventMapping(map);
                Intent intent = new Intent("android.intent.action.INSERT").setType("vnd.android.cursor.item/event");
                for (String string : map.keySet()) {
                    Object v2 = map.get(string);
                    if (v2 instanceof Long) {
                        intent.putExtra(string, ((Long)v2).longValue());
                        continue;
                    }
                    if (v2 instanceof Integer) {
                        intent.putExtra(string, ((Integer)v2).intValue());
                        continue;
                    }
                    intent.putExtra(string, (String)v2);
                }
                intent.setFlags(0x10000000);
                context.startActivity(intent);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                Log.d((String)LOGTAG, (String)"no calendar app installed");
                this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.CREATE_CALENDAR_EVENT, "Action is unsupported on this device - no calendar app installed");
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.d((String)LOGTAG, (String)("create calendar: invalid parameters " + illegalArgumentException.getMessage()));
                this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.CREATE_CALENDAR_EVENT, illegalArgumentException.getMessage());
                return;
            }
            catch (Exception exception) {
                Log.d((String)LOGTAG, (String)"could not create calendar event");
                this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.CREATE_CALENDAR_EVENT, "could not create calendar event");
                return;
            }
        }
        Log.d((String)LOGTAG, (String)"unsupported action createCalendarEvent for devices pre-ICS");
        this.getMraidView().fireErrorEvent(MraidCommandFactory$MraidJavascriptCommand.CREATE_CALENDAR_EVENT, "Action is unsupported on this device (need Android version Ice Cream Sandwich or above)");
    }

    private Map translateJSParamsToAndroidCalendarEventMapping(Map map) {
        Date date;
        HashMap hashMap = new HashMap();
        if (!map.containsKey("description") || !map.containsKey("start")) {
            throw new IllegalArgumentException("Missing start and description fields");
        }
        hashMap.put("title", map.get("description"));
        if (map.containsKey("start") && map.get("start") != null) {
            date = this.parseDate((String)map.get("start"));
            if (date == null) {
                throw new IllegalArgumentException("Invalid calendar event: start time is malformed. Date format expecting (yyyy-MM-DDTHH:MM:SS-xx:xx) or (yyyy-MM-DDTHH:MM-xx:xx) i.e. 2013-08-14T09:00:01-08:00");
            }
        } else {
            throw new IllegalArgumentException("Invalid calendar event: start is null.");
        }
        hashMap.put("beginTime", date.getTime());
        if (map.containsKey("end") && map.get("end") != null) {
            date = this.parseDate((String)map.get("end"));
            if (date != null) {
                hashMap.put("endTime", date.getTime());
            } else {
                throw new IllegalArgumentException("Invalid calendar event: end time is malformed. Date format expecting (yyyy-MM-DDTHH:MM:SS-xx:xx) or (yyyy-MM-DDTHH:MM-xx:xx) i.e. 2013-08-14T09:00:01-08:00");
            }
        }
        if (map.containsKey("location")) {
            hashMap.put("eventLocation", map.get("location"));
        }
        if (map.containsKey("summary")) {
            hashMap.put("description", map.get("summary"));
        }
        if (map.containsKey("transparency")) {
            hashMap.put("availability", ((String)map.get("transparency")).equals("transparent") ? 1 : 0);
        }
        hashMap.put("rrule", this.parseRecurrenceRule(map));
        return hashMap;
    }

    private Date parseDate(String string) {
        Date date = null;
        int n2 = 0;
        while (n2 < DATE_FORMATS.length) {
            try {
                date = new SimpleDateFormat(DATE_FORMATS[n2]).parse(string);
                if (date != null) {
                    break;
                }
            }
            catch (ParseException parseException) {}
            ++n2;
        }
        return date;
    }

    private String parseRecurrenceRule(Map object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object.containsKey("frequency")) {
            String string = (String)object.get("frequency");
            int n2 = -1;
            if (object.containsKey("interval")) {
                n2 = Integer.parseInt((String)object.get("interval"));
            }
            if ("daily".equals(string)) {
                stringBuilder.append("FREQ=DAILY;");
                if (n2 != -1) {
                    stringBuilder.append("INTERVAL=" + n2 + ";");
                }
            } else if ("weekly".equals(string)) {
                stringBuilder.append("FREQ=WEEKLY;");
                if (n2 != -1) {
                    stringBuilder.append("INTERVAL=" + n2 + ";");
                }
                if (object.containsKey("daysInWeek")) {
                    if ((object = this.translateWeekIntegersToDays((String)object.get("daysInWeek"))) == null) {
                        throw new IllegalArgumentException("invalid ");
                    }
                    stringBuilder.append("BYDAY=" + (String)object + ";");
                }
            } else if ("monthly".equals(string)) {
                stringBuilder.append("FREQ=MONTHLY;");
                if (n2 != -1) {
                    stringBuilder.append("INTERVAL=" + n2 + ";");
                }
                if (object.containsKey("daysInMonth")) {
                    if ((object = this.translateMonthIntegersToDays((String)object.get("daysInMonth"))) == null) {
                        throw new IllegalArgumentException();
                    }
                    stringBuilder.append("BYMONTHDAY=" + (String)object + ";");
                }
            } else {
                throw new IllegalArgumentException("frequency is only supported for daily, weekly, and monthly.");
            }
        }
        return stringBuilder.toString();
    }

    private String translateWeekIntegersToDays(String stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean[] blArray = new boolean[7];
        stringArray = stringArray.split(",");
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = Integer.parseInt(stringArray[n2]);
            int n4 = n3 = n3 == 7 ? 0 : n3;
            if (!blArray[n3]) {
                stringBuilder.append(String.valueOf(this.dayNumberToDayOfWeekString(n3)) + ",");
                blArray[n3] = true;
            }
            ++n2;
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("must have at least 1 day of the week if specifying repeating weekly");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private String translateMonthIntegersToDays(String stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean[] blArray = new boolean[63];
        stringArray = stringArray.split(",");
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = Integer.parseInt(stringArray[n2]);
            if (!blArray[n3 + 31]) {
                stringBuilder.append(String.valueOf(this.dayNumberToDayOfMonthString(n3)) + ",");
                blArray[n3 + 31] = true;
            }
            ++n2;
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("must have at least 1 day of the month if specifying repeating weekly");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private String dayNumberToDayOfWeekString(int n2) {
        String string;
        switch (n2) {
            case 0: {
                string = "SU";
                break;
            }
            case 1: {
                string = "MO";
                break;
            }
            case 2: {
                string = "TU";
                break;
            }
            case 3: {
                string = "WE";
                break;
            }
            case 4: {
                string = "TH";
                break;
            }
            case 5: {
                string = "FR";
                break;
            }
            case 6: {
                string = "SA";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid day of week " + n2);
            }
        }
        return string;
    }

    private String dayNumberToDayOfMonthString(int n2) {
        if (n2 == 0 || n2 < -31 || n2 > 31) {
            throw new IllegalArgumentException("invalid day of month " + n2);
        }
        String string = "" + n2;
        return string;
    }

    private void swapViewWithPlaceholderView() {
        ViewGroup viewGroup = (ViewGroup)this.getMraidView().getParent();
        if (viewGroup == null) {
            return;
        }
        int n2 = viewGroup.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            if (viewGroup.getChildAt(n3) == this.getMraidView()) break;
            ++n3;
        }
        this.mViewIndexInParent = n3;
        viewGroup.addView((View)this.mPlaceholderView, n3, new ViewGroup.LayoutParams(this.getMraidView().getWidth(), this.getMraidView().getHeight()));
        viewGroup.removeView((View)this.getMraidView());
    }

    private void expandLayouts(View view, int n2, int n3) {
        int n4 = (int)(50.0f * this.mDensity + 0.5f);
        if (n2 < n4) {
            n2 = n4;
        }
        if (n3 < n4) {
            n3 = n4;
        }
        View view2 = new View(this.getContext());
        view2.setBackgroundColor(0);
        view2.setOnTouchListener((View.OnTouchListener)new MraidDisplayController$7(this));
        this.mExpansionLayout.addView(view2, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.mAdContainerLayout.addView(view, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        view = new RelativeLayout.LayoutParams(n2, n3);
        view.addRule(13);
        this.mExpansionLayout.addView((View)this.mAdContainerLayout, (ViewGroup.LayoutParams)view);
    }

    private void setOrientationLockEnabled(boolean bl2) {
        Context context = this.getContext();
        Activity activity = null;
        try {
            activity = (Activity)context;
            int n2 = bl2 ? activity.getResources().getConfiguration().orientation : this.mOriginalRequestedOrientation;
            activity.setRequestedOrientation(n2);
            return;
        }
        catch (ClassCastException classCastException) {
            Log.d((String)LOGTAG, (String)"Unable to modify device orientation.");
            return;
        }
    }

    protected void setNativeCloseButtonEnabled(boolean bl2) {
        if (this.mRootView == null) {
            return;
        }
        if (bl2) {
            if (this.mCloseButton == null) {
                StateListDrawable stateListDrawable = new StateListDrawable();
                stateListDrawable.addState(new int[]{-16842919}, (Drawable)Drawables.INTERSTITIAL_CLOSE_BUTTON_NORMAL.decodeImage(this.mRootView.getContext()));
                stateListDrawable.addState(new int[]{16842919}, (Drawable)Drawables.INTERSTITIAL_CLOSE_BUTTON_PRESSED.decodeImage(this.mRootView.getContext()));
                this.mCloseButton = new ImageButton(this.getContext());
                this.mCloseButton.setImageDrawable((Drawable)stateListDrawable);
                this.mCloseButton.setBackgroundDrawable(null);
                this.mCloseButton.setOnClickListener((View.OnClickListener)new MraidDisplayController$8(this));
            }
            int layoutParams = (int)(50.0f * this.mDensity + 0.5f);
            FrameLayout.LayoutParams mraidView = new FrameLayout.LayoutParams(layoutParams, layoutParams, 5);
            this.mAdContainerLayout.addView((View)this.mCloseButton, (ViewGroup.LayoutParams)mraidView);
        } else {
            this.mAdContainerLayout.removeView((View)this.mCloseButton);
        }
        MraidView mraidView = this.getMraidView();
        if (mraidView.getOnCloseButtonStateChangeListener() != null) {
            mraidView.getOnCloseButtonStateChangeListener();
        }
    }

    protected void useCustomClose(boolean bl2) {
        this.mAdWantsCustomCloseButton = bl2;
        MraidView mraidView = this.getMraidView();
        if (mraidView.getOnCloseButtonStateChangeListener() != null) {
            mraidView.getOnCloseButtonStateChangeListener();
        }
    }

    protected boolean checkViewable() {
        return true;
    }

    FrameLayout createAdContainerLayout() {
        return new FrameLayout(this.getContext());
    }

    RelativeLayout createExpansionLayout() {
        return new RelativeLayout(this.getContext());
    }

    FrameLayout createPlaceholderView() {
        return new FrameLayout(this.getContext());
    }

    private Context getContext() {
        return this.getMraidView().getContext();
    }

    protected void initializeSupportedFunctionsProperty() {
        Context context = this.getContext();
        this.getMraidView().fireChangeEventForProperty(new MraidSupportsProperty().withTel(Mraids.isTelAvailable(context)).withSms(Mraids.isSmsAvailable(context)).withCalendar(Mraids.isCalendarAvailable(context)).withInlineVideo(Mraids.isInlineVideoAvailable(context)).withStorePicture(Mraids.isStorePictureSupported(context)));
    }

    private File getPictureStoragePath() {
        return new File(Environment.getExternalStorageDirectory(), "Pictures");
    }

    private String getFileNameForUriAndHttpResponse(URI object, HttpResponse object2) {
        if ((object = ((URI)object).getPath()) == null) {
            return null;
        }
        object = new File((String)object).getName();
        if ((object2 = object2.getFirstHeader("Content-Type")) != null) {
            object2 = object2.getValue().split(";");
            String[] stringArray = object2;
            int n2 = ((String[])object2).length;
            int n3 = 0;
            while (n3 < n2) {
                object2 = stringArray[n3];
                if (((String)object2).contains("image/")) {
                    if (((String)object).endsWith((String)(object2 = "." + ((String)object2).split("/")[1]))) break;
                    object = String.valueOf(object) + (String)object2;
                    break;
                }
                ++n3;
            }
        }
        return object;
    }

    static /* synthetic */ boolean access$1(MraidDisplayController mraidDisplayController) {
        return mraidDisplayController.mIsViewable;
    }

    static /* synthetic */ void access$2(MraidDisplayController mraidDisplayController, boolean bl2) {
        mraidDisplayController.mIsViewable = bl2;
    }

    static /* synthetic */ Handler access$3(MraidDisplayController mraidDisplayController) {
        return mraidDisplayController.mHandler;
    }

    static /* synthetic */ int access$4(MraidDisplayController mraidDisplayController) {
        return mraidDisplayController.getDisplayRotation();
    }

    static /* synthetic */ void access$5(MraidDisplayController mraidDisplayController, int n2) {
        mraidDisplayController.onOrientationChanged(n2);
    }

    static /* synthetic */ Context access$6(MraidDisplayController mraidDisplayController) {
        return mraidDisplayController.getContext();
    }

    static /* synthetic */ String access$7(MraidDisplayController mraidDisplayController, URI uRI, HttpResponse httpResponse) {
        return mraidDisplayController.getFileNameForUriAndHttpResponse(uRI, httpResponse);
    }

    static /* synthetic */ void access$8(MraidDisplayController mraidDisplayController, String string) {
        mraidDisplayController.showUserToast(string);
    }

    static /* synthetic */ void access$9(MraidDisplayController mraidDisplayController, String string) {
        mraidDisplayController.downloadImage(string);
    }
}

