/*
 * Decompiled with CFR 0.152.
 */
package com.five.adwoad.mraid;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import com.five.adwoad.mraid.Utils;
import com.five.adwoad.mraid.VersionCode;

public class Mraids {
    public static final String ANDROID_CALENDAR_CONTENT_TYPE = "vnd.android.cursor.item/event";

    public static boolean isTelAvailable(Context context) {
        Intent intent = new Intent("android.intent.action.DIAL");
        intent.setData(Uri.parse((String)"tel:"));
        return Utils.deviceCanHandleIntent(context, intent);
    }

    public static boolean isSmsAvailable(Context context) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)"sms:"));
        return Utils.deviceCanHandleIntent(context, intent);
    }

    public static boolean isStorePictureSupported(Context context) {
        return "mounted".equals(Environment.getExternalStorageState()) && context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    public static boolean isCalendarAvailable(Context context) {
        Intent intent = new Intent("android.intent.action.INSERT").setType(ANDROID_CALENDAR_CONTENT_TYPE);
        return VersionCode.currentApiLevel().isAtLeast(VersionCode.ICE_CREAM_SANDWICH) && Utils.deviceCanHandleIntent(context, intent);
    }

    public static boolean isInlineVideoAvailable(Context context) {
        return Build.VERSION.SDK_INT >= 7;
    }
}

