/*
 * Decompiled with CFR 0.152.
 */
package com.five.adwoad.mraid;

import android.content.Context;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.five.adwoad.mraid.AdAlertGestureListener;
import com.five.adwoad.mraid.ViewGestureDetector$UserClickListener;

public class ViewGestureDetector
extends GestureDetector {
    private final View mView;
    private AdAlertGestureListener mAdAlertGestureListener;
    private ViewGestureDetector$UserClickListener mUserClickListener;

    public ViewGestureDetector(Context context, View view) {
        this(context, view, new AdAlertGestureListener(view));
    }

    private ViewGestureDetector(Context context, View view, AdAlertGestureListener adAlertGestureListener) {
        super(context, (GestureDetector.OnGestureListener)adAlertGestureListener);
        this.mAdAlertGestureListener = adAlertGestureListener;
        this.mView = view;
        this.setIsLongpressEnabled(false);
    }

    public void sendTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 1: {
                if (this.mUserClickListener != null) {
                    this.mUserClickListener.onUserClick();
                } else {
                    Log.d((String)"Adwo", (String)"View's onUserClick() is not registered.");
                }
                this.mAdAlertGestureListener.finishGestureDetection();
                return;
            }
            case 0: {
                this.onTouchEvent(motionEvent);
                return;
            }
            case 2: {
                if (this.isMotionEventInView(motionEvent, this.mView)) {
                    this.onTouchEvent(motionEvent);
                    return;
                }
                this.resetAdFlaggingGesture();
            }
        }
    }

    public void setUserClickListener(ViewGestureDetector$UserClickListener viewGestureDetector$UserClickListener) {
        this.mUserClickListener = viewGestureDetector$UserClickListener;
    }

    void resetAdFlaggingGesture() {
        this.mAdAlertGestureListener.reset();
    }

    private boolean isMotionEventInView(MotionEvent motionEvent, View view) {
        if (motionEvent == null || view == null) {
            return false;
        }
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        return f2 >= 0.0f && f2 <= (float)view.getWidth() && f3 >= 0.0f && f3 <= (float)view.getHeight();
    }

    @Deprecated
    void setAdAlertGestureListener(AdAlertGestureListener adAlertGestureListener) {
        this.mAdAlertGestureListener = adAlertGestureListener;
    }
}

