/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.jnibuild;

import com.github.rjeschke.jnibuild.Arguments;
import com.github.rjeschke.jnibuild.Build;
import com.github.rjeschke.jnibuild.Command;
import com.github.rjeschke.jnibuild.OsIdentifier;
import com.github.rjeschke.jnibuild.OsType;
import com.github.rjeschke.jnibuild.PropertiesReader;
import com.github.rjeschke.jnibuild.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Builder {
    private final File javaSDK;
    private final File cwd;
    private final String javaHome;
    private final OsIdentifier os;
    private File pomTemplate = null;
    private File buildJni = null;
    private File nativeSrc;
    private File objOutput;
    private File dllOutput;
    private File mvnOutput;
    private String library;
    private String libraryPath;
    private final ArrayList<String> objects = new ArrayList();
    private Arguments arguments;
    private static final String[] NEEDED_KEYS = new String[]{"project.package", "project.sources", "project.name"};

    public Builder(String currentDir) {
        this.javaSDK = Utils.findSDK();
        this.cwd = new File(currentDir);
        this.javaHome = System.getProperty("java.home");
        this.os = Utils.getOsIdentifier();
    }

    public Builder() {
        this(System.getProperty("user.dir"));
    }

    public int run(String[] args) {
        Map<String, String> config;
        int err;
        block18: {
            block17: {
                block16: {
                    block15: {
                        err = 0;
                        this.arguments = Arguments.parse(args);
                        this.pomTemplate = new File(this.cwd, "jni_pom.xml");
                        this.buildJni = new File(this.cwd, "build.jni");
                        this.nativeSrc = new File(this.cwd, "src/main/native");
                        this.objOutput = new File(this.cwd, "target/native/obj");
                        this.dllOutput = new File(this.cwd, "target/native");
                        this.mvnOutput = new File(this.cwd, "target/native-artifact");
                        if (this.pomTemplate.exists()) break block15;
                        System.err.println("Missing 'jni_pom.xml', aborting.");
                        return 1;
                    }
                    if (this.buildJni.exists()) break block16;
                    System.err.println("Missing 'build.jni', aborting.");
                    return 1;
                }
                if (this.nativeSrc.exists() && this.nativeSrc.isDirectory()) break block17;
                System.err.println("Missing 'src/main/native' folder, aborting.");
                return 1;
            }
            this.objOutput.mkdirs();
            this.mvnOutput.mkdirs();
            config = this.prepareBuildConfig();
            if (config != null) break block18;
            return 1;
        }
        try {
            if (this.arguments.dumpConfig) {
                System.out.println("Dumping configuration:");
                Builder.dumpMap(config);
                System.out.println();
            }
            ArrayList<String> sources = Utils.cmdTokenize(config.get("project.sources"));
            err = 0;
            for (String s : sources) {
                int e = this.compile(config, s);
                if (e == 0) continue;
                err = e;
            }
            if (err != 0) {
                System.out.println("Compilation failed.");
                return err;
            }
            System.out.println("Compilation finished.");
            System.out.println();
            err = this.link(config);
            if (err != 0) {
                System.out.println("Linking failed.");
                return err;
            }
            System.out.println("Linking finished.");
            System.out.println();
            err = this.prepareMaven(config);
            if (err != 0) {
                System.out.println("Artifact creation failed.");
                return err;
            }
            System.out.println();
            if (this.arguments.installProject) {
                System.out.println("Doing maven install ...");
                err = this.cmd((ProcessBuilder)new ProcessBuilder((String[])new String[]{"mvn", "install"}), (File)this.mvnOutput, (boolean)false).returnValue;
                if (err != 0) {
                    System.out.println("Maven install failed.");
                    return err;
                }
                System.out.println("Maven install finished.");
                System.out.println();
            }
            if (this.arguments.deployProject) {
                System.out.println("Doing maven deploy ...");
                err = this.cmd((ProcessBuilder)new ProcessBuilder((String[])new String[]{"mvn", "deploy"}), (File)this.mvnOutput, (boolean)false).returnValue;
                if (err != 0) {
                    System.out.println("Maven deploy failed.");
                    return err;
                }
                System.out.println("Maven deploy finished.");
                System.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return err;
    }

    private Map<String, String> prepareBuildConfig() throws IOException {
        Map<String, String> buildArgs = this.initTemplate();
        HashMap<String, String> preparedArgs = new HashMap<String, String>();
        this.prepareArchMap(buildArgs, preparedArgs);
        Builder.filterMap(buildArgs, preparedArgs, "project.");
        String osKey = String.valueOf(this.os.os.toString().toLowerCase()) + ".";
        Utils.mapAppend(preparedArgs, String.valueOf(osKey) + "include_paths", this.getJniIncludes());
        Utils.mapAppend(preparedArgs, String.valueOf(osKey) + "include_paths", this.nativeSrc.getAbsolutePath());
        Utils.mapAppend(preparedArgs, String.valueOf(osKey) + "lib_paths", this.getJniLibs());
        if (this.resolveFlags(preparedArgs, String.valueOf(osKey) + "cflags") != 0) {
            return null;
        }
        if (this.resolveFlags(preparedArgs, String.valueOf(osKey) + "cppflags") != 0) {
            return null;
        }
        if (this.resolveFlags(preparedArgs, String.valueOf(osKey) + "cxxflags") != 0) {
            return null;
        }
        if (this.resolveFlags(preparedArgs, String.valueOf(osKey) + "ldflags") != 0) {
            return null;
        }
        if (this.resolveFlags(preparedArgs, String.valueOf(osKey) + "asmflags") != 0) {
            return null;
        }
        HashMap<String, String> cfg = new HashMap<String, String>();
        for (Map.Entry<String, String> e : preparedArgs.entrySet()) {
            if (e.getKey().startsWith(osKey)) {
                cfg.put(e.getKey().substring(osKey.length()), e.getValue());
                continue;
            }
            cfg.put(e.getKey(), e.getValue());
        }
        String[] stringArray = NEEDED_KEYS;
        int n = NEEDED_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!cfg.containsKey(s)) {
                throw new IOException("Required key '" + s + "' missing.");
            }
            ++n2;
        }
        return cfg;
    }

    private int prepareMaven(Map<String, String> cfg) throws IOException {
        System.out.println("Preparing maven artifact ...");
        File path = new File(new File(new File(this.mvnOutput, "src/main/resources"), cfg.get("project.package").replaceAll("\\.", "/")), this.os.toString());
        path.mkdirs();
        Utils.copy(new File(this.libraryPath), new File(path, this.library));
        if (cfg.containsKey("copy_libs")) {
            ArrayList<String> todo = Utils.cmdTokenize(cfg.get("copy_libs"));
            for (String s : todo) {
                Utils.copy(new File(s), new File(path, new File(s).getName()));
            }
        }
        String pom = new String(Utils.asBytes(this.pomTemplate), "UTF-8");
        Utils.writeToFile(new File(this.mvnOutput, "pom.xml"), pom.replaceAll("\\$\\$arch\\$\\$", this.os.toString()));
        System.out.println("Artifact prepared.");
        return 0;
    }

    private static String g(Map<String, String> map, String key) {
        return map.containsKey(key) ? map.get(key) : "";
    }

    private int link(Map<String, String> cfg) throws IOException {
        String libname = Utils.mapLibraryName(cfg.get("project.name"));
        String outLib = new File(this.dllOutput, libname).getAbsolutePath();
        System.out.println("Linking " + libname + " ...");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(Builder.g(cfg, "link"));
        if (this.os.os != OsType.WINDOWS) {
            cmd.addAll(this.objects);
            cmd.add("-shared");
            cmd.add("-o");
            cmd.add(outLib);
            cmd.addAll(Utils.cmdTokenize(Builder.g(cfg, "ldflags")));
            ArrayList<String> tmp = Utils.cmdTokenize(Builder.g(cfg, "lib_paths"));
            for (String s : tmp) {
                cmd.add("-L" + s);
            }
            tmp = Utils.cmdTokenize(Builder.g(cfg, "libs"));
            for (String s : tmp) {
                cmd.add("-l" + s);
            }
        }
        this.library = libname;
        this.libraryPath = outLib;
        return this.cmd(cmd);
    }

    private int compile(Map<String, String> cfg, String src) throws IOException {
        int eidx = src.lastIndexOf(46);
        if (eidx == -1) {
            System.err.println("Illegal/unknown source file: " + src);
            return 1;
        }
        System.out.println("Compiling " + src + " ...");
        String ext = src.substring(eidx).toLowerCase();
        String obj = String.valueOf(src.substring(0, eidx)) + (this.os.os == OsType.WINDOWS ? ".obj" : ".o");
        ArrayList<String> cmd = new ArrayList<String>();
        if (Builder.isC(ext)) {
            cmd.add(Builder.g(cfg, "cc"));
            cmd.addAll(Utils.cmdTokenize(Builder.g(cfg, "cppflags")));
            cmd.addAll(Utils.cmdTokenize(Builder.g(cfg, "cflags")));
        } else if (Builder.isCpp(ext)) {
            cmd.add(Builder.g(cfg, "cpp"));
            cmd.addAll(Utils.cmdTokenize(Builder.g(cfg, "cppflags")));
            cmd.addAll(Utils.cmdTokenize(Builder.g(cfg, "cxxflags")));
        }
        if (this.os.os != OsType.WINDOWS) {
            ArrayList<String> includes = Utils.cmdTokenize(Builder.g(cfg, "include_paths"));
            for (String s : includes) {
                cmd.add("-I" + s);
            }
            cmd.add("-c");
            cmd.add("-o");
            String objFile = new File(this.objOutput, obj).getAbsolutePath();
            cmd.add(objFile);
            cmd.add(new File(this.nativeSrc, src).getAbsolutePath());
            this.objects.add(objFile);
        }
        return this.cmd(cmd);
    }

    public static final boolean isC(String ext) {
        return ext.equals(".c");
    }

    public static final boolean isCpp(String ext) {
        return ext.equals(".cpp") || ext.equals(".cc");
    }

    public static final boolean isAsm(String ext) {
        return ext.equals(".asm");
    }

    private static Map<String, String> filterMap(Map<String, String> inMap, Map<String, String> outMap, String prefix) {
        for (Map.Entry<String, String> e : inMap.entrySet()) {
            if (!e.getKey().startsWith(prefix)) continue;
            outMap.put(e.getKey(), e.getValue());
        }
        return outMap;
    }

    private Map<String, String> prepareArchMap(Map<String, String> inMap, Map<String, String> outMap) {
        String osname = String.valueOf(this.os.os.toString().toLowerCase()) + ".";
        String osprefix = String.valueOf(this.os.os.toString().toLowerCase()) + this.os.arch + ".";
        for (Map.Entry<String, String> e : inMap.entrySet()) {
            if (!e.getKey().startsWith(osname) || e.getKey().startsWith(osprefix)) continue;
            outMap.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, String> e : inMap.entrySet()) {
            if (!e.getKey().startsWith(osprefix)) continue;
            String okey = String.valueOf(osname) + e.getKey().substring(osprefix.length());
            Utils.mapAppend(outMap, okey, e.getValue());
        }
        return outMap;
    }

    private List<String> getJniIncludes() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.javaSDK != null) {
            File includes = new File(this.javaSDK, "include");
            File[] files = includes.listFiles();
            paths.add(includes.getAbsolutePath());
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    paths.add(f.getAbsolutePath());
                }
                ++n2;
            }
        }
        return paths;
    }

    private int resolveFlags(Map<String, String> map, String key) throws IOException {
        if (!map.containsKey(key)) {
            return 0;
        }
        ArrayList<String> args = Utils.cmdTokenize(map.get(key));
        ArrayList<String> resolved = new ArrayList<String>();
        for (String s : args) {
            if (s.startsWith("`")) {
                String ret = this.configCmd(s);
                if (ret == null) {
                    return 1;
                }
                resolved.add(ret);
                continue;
            }
            resolved.add(s);
        }
        map.put(key, Utils.list2str(resolved));
        return 0;
    }

    private List<String> getJniLibs() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.javaSDK != null) {
            File libs = new File(this.javaSDK, "lib");
            paths.add(libs.getAbsolutePath());
        }
        return paths;
    }

    public static void dumpMap(Map<String, String> map) throws IOException {
        ArrayList<String> sorted = new ArrayList<String>();
        for (Map.Entry<String, String> e : map.entrySet()) {
            sorted.add(String.valueOf(e.getKey()) + " = " + Utils.cmdTokenize(e.getValue()));
        }
        Collections.sort(sorted);
        for (String s : sorted) {
            System.out.println(s);
        }
    }

    private Map<String, String> initTemplate() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        PropertiesReader.readProperties(Build.class.getResourceAsStream("/com/github/rjeschke/jnibuild/template.txt"), map);
        PropertiesReader.readProperties(this.buildJni, map);
        return map;
    }

    public int cmd(String ... command) throws IOException {
        return this.cmd((ProcessBuilder)new ProcessBuilder((String[])command), (boolean)false).returnValue;
    }

    public int cmd(List<String> command) throws IOException {
        return this.cmd((ProcessBuilder)new ProcessBuilder(command), (boolean)false).returnValue;
    }

    private Command.Result cmd(ProcessBuilder pb, boolean quiet) throws IOException {
        return this.cmd(pb, this.cwd, quiet);
    }

    private Command.Result cmd(ProcessBuilder pb, File cwd, boolean quiet) throws IOException {
        pb.directory(cwd);
        pb.environment().put("JAVA_HOME", this.javaHome);
        return Command.execute(pb, quiet);
    }

    private String configCmd(String cmd) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(Utils.cmdTokenize(cmd.substring(1, cmd.length() - 1)));
        Command.Result result = this.cmd(pb, true);
        if (result.returnValue != 0) {
            System.err.println("Error excuting command: " + cmd);
            System.err.println(result.errOut);
            return null;
        }
        return result.stdOut;
    }
}

