/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.jnibuild;

import com.github.rjeschke.jnibuild.StreamRedirect;
import java.io.IOException;
import java.util.List;

public final class Command {
    private Command() {
    }

    public static final Result execute(ProcessBuilder pb, boolean quiet) throws IOException {
        Process p = pb.start();
        StreamRedirect err = new StreamRedirect(p.getErrorStream(), quiet ? null : System.err);
        StreamRedirect out = new StreamRedirect(p.getInputStream(), quiet ? null : System.out);
        err.start();
        out.start();
        String errOut = err.waitFor();
        String stdOut = out.waitFor();
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new Result(p.exitValue(), stdOut, errOut);
    }

    public static final Result execute(List<String> command) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command);
        return Command.execute(pb, false);
    }

    public static final Result execute(String ... command) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command);
        return Command.execute(pb, false);
    }

    public static class Result {
        public final int returnValue;
        public final String stdOut;
        public final String errOut;

        public Result(int returnValue, String stdOut, String errOut) {
            this.returnValue = returnValue;
            this.stdOut = stdOut;
            this.errOut = errOut;
        }
    }
}

