/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.jnibuild;

import com.github.rjeschke.jnibuild.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public final class PropertiesReader {
    private PropertiesReader() {
    }

    public static final Map<String, String> readProperties(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream input = new FileInputStream(file);){
            return PropertiesReader.readProperties(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final Map<String, String> readProperties(File file, Map<String, String> map) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream input = new FileInputStream(file);){
            return PropertiesReader.readProperties(input, map);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final Map<String, String> readProperties(String filename) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream input = new FileInputStream(filename);){
            return PropertiesReader.readProperties(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final Map<String, String> readProperties(String filename, Map<String, String> map) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream input = new FileInputStream(filename);){
            return PropertiesReader.readProperties(input, map);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final Map<String, String> readProperties(InputStream input) throws IOException {
        return PropertiesReader.readProperties(input, new HashMap<String, String>());
    }

    public static final Map<String, String> readProperties(InputStream input, Map<String, String> map) throws IOException {
        if (input == null) {
            throw new IOException("No input stream given, maybe there is a missing resource.");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));){
            String line;
            int lno = 0;
            while ((line = reader.readLine()) != null) {
                ++lno;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (!line.contains("=")) {
                    throw new IOException("Error in configuration: " + line + " in line " + lno);
                }
                int bp = 0;
                while (bp < line.length()) {
                    if (line.charAt(bp) == '+' || line.charAt(bp) == '=') break;
                    ++bp;
                }
                boolean append = line.charAt(bp) == '+';
                String key = Utils.rmWhitespace(line.substring(0, bp).toLowerCase());
                String value = line.substring(append ? bp + 2 : bp + 1).trim();
                if (append && map.containsKey(key)) {
                    map.put(key, String.valueOf(map.get(key)) + " " + value);
                    continue;
                }
                map.put(key, value);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return map;
    }
}

