/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.jnibuild;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.Semaphore;

public class StreamRedirect
implements Runnable {
    private final InputStream input;
    private final OutputStream output;
    private volatile boolean running = true;
    private final Thread thread;
    private final Semaphore busy = new Semaphore(1);
    private byte[] stringBytes = new byte[4096];
    private int readBytes = 0;

    public StreamRedirect(InputStream input, OutputStream output) {
        this.input = input;
        this.output = output;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.busy.acquireUninterruptibly(1);
    }

    public void start() {
        this.thread.start();
    }

    public String waitFor() throws IOException {
        this.busy.acquireUninterruptibly();
        return new String(this.stringBytes, 0, this.readBytes, "UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] buffer = new byte[256];
        try {
            try {
                while (true) {
                    if (!this.running) {
                        return;
                    }
                    int read = this.input.read(buffer);
                    if (read == -1) {
                        return;
                    }
                    if (read > 0) {
                        if (this.output != null) {
                            this.output.write(buffer, 0, read);
                            this.output.flush();
                        }
                        if (this.readBytes + read > this.stringBytes.length) {
                            this.stringBytes = Arrays.copyOf(this.stringBytes, this.readBytes + read * 2);
                        }
                        System.arraycopy(buffer, 0, this.stringBytes, this.readBytes, read);
                        this.readBytes += read;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException iOException) {
                this.busy.release();
                this.running = false;
                return;
            }
        }
        finally {
            this.busy.release();
            this.running = false;
        }
    }
}

