/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.jnibuild;

import com.github.rjeschke.jnibuild.OsIdentifier;
import com.github.rjeschke.jnibuild.OsType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class Utils {
    private Utils() {
    }

    public static final double getJavaVersion() {
        return Double.parseDouble(System.getProperty("java.specification.version"));
    }

    public static final OsIdentifier getOsIdentifier() {
        String os = System.getProperty("os.name").toLowerCase();
        int arch = Integer.parseInt(System.getProperty("sun.arch.data.model"));
        if (os.startsWith("windows")) {
            return new OsIdentifier(OsType.WINDOWS, arch);
        }
        if (os.startsWith("linux")) {
            return new OsIdentifier(OsType.LINUX, arch);
        }
        if (os.startsWith("mac")) {
            return new OsIdentifier(OsType.MAC, arch);
        }
        throw new RuntimeException("Unsupported OS version:" + System.getProperty("os.name"));
    }

    public static final boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch) || Character.isSpaceChar(ch);
    }

    public static final String rmWhitespace(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!Utils.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final ArrayList<String> cmdTokenize(String str) throws IOException {
        String tmp;
        ArrayList<String> list = new ArrayList<String>();
        if (str == null) {
            return list;
        }
        String input = str.trim();
        int start = 0;
        boolean inQuotes = false;
        char quote = '\u0000';
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (inQuotes) {
                inQuotes = c != quote;
            } else if (c == '`' || c == '\"') {
                inQuotes = true;
                quote = c;
            } else if (Utils.isWhitespace(c)) {
                tmp = input.substring(start, i).trim();
                if (!tmp.isEmpty()) {
                    list.add(tmp);
                }
                start = i;
            }
            ++i;
        }
        if (inQuotes) {
            throw new IOException("Open quotes in line: " + str);
        }
        tmp = input.substring(start, input.length()).trim();
        if (!tmp.isEmpty()) {
            list.add(tmp);
        }
        return list;
    }

    public static String normalizePath(String path) {
        String work = path.replaceAll("\\\\", "/");
        String[] toks = work.split("/");
        ArrayList<String> list = new ArrayList<String>();
        boolean abs = work.startsWith("/");
        String[] stringArray = toks;
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!s.equals(".")) {
                if (s.equals("..")) {
                    list.remove(list.size() - 1);
                } else {
                    list.add(s);
                }
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0 || abs) {
                sb.append('/');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static final File findSDK() {
        if (!System.getProperties().containsKey("java.home")) {
            return null;
        }
        File jHome = new File(System.getProperty("java.home"));
        if (!jHome.exists()) {
            return null;
        }
        File sdk = new File(jHome, "../");
        File sdkInclude = new File(sdk, "include");
        File sdkLib = new File(sdk, "lib");
        return sdkInclude.exists() && sdkLib.exists() ? new File(Utils.normalizePath(sdk.getAbsolutePath())) : null;
    }

    public static final void mapAppend(Map<String, String> map, String key, String value) {
        if (map.containsKey(key)) {
            map.put(key, String.valueOf(map.get(key)) + " " + value);
        } else {
            map.put(key, value);
        }
    }

    public static final String list2str(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static final void mapAppend(Map<String, String> map, String key, List<String> value) {
        if (map.containsKey(key)) {
            map.put(key, String.valueOf(map.get(key)) + " " + Utils.list2str(value));
        } else {
            map.put(key, Utils.list2str(value));
        }
    }

    public static final String mapLibraryName(String lib) {
        switch (Utils.getOsIdentifier().os) {
            case WINDOWS: {
                return String.valueOf(lib) + ".dll";
            }
            case LINUX: {
                return "lib" + lib + ".so";
            }
            case MAC: {
                return "lib" + lib + ".jnilib";
            }
        }
        return null;
    }

    public static final void copy(File input, File output) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(input);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (FileOutputStream out = new FileOutputStream(output);){
                Utils.copy(in, out);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static final void copy(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
        }
    }

    public static final byte[] asBytes(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] buffer = new byte[(int)file.length()];
            int p = 0;
            while (p < buffer.length) {
                int r = fis.read(buffer, p, buffer.length - p);
                if (r == -1) break;
                p += r;
            }
            if (p != buffer.length) {
                throw new IOException("Unexpected end of stream, expected " + buffer.length + ", got " + p + " bytes");
            }
            return buffer;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final void writeToFile(File file, String string) throws IOException {
        byte[] bytes = string.getBytes("UTF-8");
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(bytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

