/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils;

import com.github.rjeschke.neetutils.EncodingException;
import com.github.rjeschke.neetutils.Strings;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class Encode {
    private static final String BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String ALLOWED_URL_CHARS = "-.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~";
    private static final BitSet URL_ENCODE_SET = new BitSet(256);

    private Encode() {
    }

    public static final byte[] md5(String string) {
        try {
            return Encode.md5(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] md5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncodingException("Generating MD5 hash failed", e);
        }
    }

    public static final byte[] sha1(String string) {
        try {
            return Encode.sha1(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] sha1(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return md.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncodingException("Generating SHA-1 hash failed", e);
        }
    }

    public static final byte[] sha256(String string) {
        try {
            return Encode.sha256(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] sha256(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncodingException("Generating SHA-256 hash failed", e);
        }
    }

    public static final byte[] sha512(String string) {
        try {
            return Encode.sha512(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] sha512(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            return md.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncodingException("Generating SHA-512 hash failed", e);
        }
    }

    private static final int get24(byte[] bytes, int pos) {
        int ret = 0;
        if (pos < bytes.length) {
            ret |= (bytes[pos] & 0xFF) << 16;
            if (pos + 1 < bytes.length) {
                ret |= (bytes[pos + 1] & 0xFF) << 8;
                if (pos + 2 < bytes.length) {
                    ret |= bytes[pos + 2] & 0xFF;
                }
            }
        }
        return ret;
    }

    public static final byte[] hmacSha1(String key, String data) {
        try {
            return Encode.hmacSha1(key.getBytes("UTF-8"), data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] hmacSha1(String key, byte[] bytes) {
        try {
            return Encode.hmacSha1(key.getBytes("UTF-8"), bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] hmacSha1(byte[] key, String data) {
        try {
            return Encode.hmacSha1(key, data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] hmacSha1(byte[] key, byte[] bytes) {
        try {
            SecretKeySpec sks = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(sks);
            return mac.doFinal(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new EncodingException("Generating HmacSHA1 hash failed", e);
        }
    }

    public static final byte[] hmacSha256(String key, String data) {
        try {
            return Encode.hmacSha256(key.getBytes("UTF-8"), data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] hmacSha256(String key, byte[] bytes) {
        try {
            return Encode.hmacSha256(key.getBytes("UTF-8"), bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] hmacSha256(byte[] key, String data) {
        try {
            return Encode.hmacSha256(key, data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodingException("No UTF-8 encoding available", e);
        }
    }

    public static final byte[] hmacSha256(byte[] key, byte[] bytes) {
        try {
            SecretKeySpec sks = new SecretKeySpec(key, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(sks);
            return mac.doFinal(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new EncodingException("Generating HmacSHA256 hash failed", e);
        }
    }

    public static final String base64(byte[] bytes) {
        return Encode.base64(new StringBuilder(), bytes).toString();
    }

    public static final StringBuilder base64(StringBuilder sb, byte[] bytes) {
        int in;
        int todo = bytes.length;
        int pos = 0;
        while (todo > 2) {
            in = Encode.get24(bytes, pos);
            sb.append(BASE64.charAt(in >> 18 & 0x3F));
            sb.append(BASE64.charAt(in >> 12 & 0x3F));
            sb.append(BASE64.charAt(in >> 6 & 0x3F));
            sb.append(BASE64.charAt(in & 0x3F));
            todo -= 3;
            pos += 3;
        }
        if (todo > 0) {
            in = Encode.get24(bytes, pos);
            sb.append(BASE64.charAt(in >> 18 & 0x3F));
            sb.append(BASE64.charAt(in >> 12 & 0x3F));
            if (todo == 2) {
                sb.append(BASE64.charAt(in >> 6 & 0x3F));
            } else {
                sb.append('=');
            }
            sb.append('=');
        }
        return sb;
    }

    public static final String hex(byte[] bytes) {
        return Encode.hex(new StringBuilder(), bytes).toString();
    }

    private static final char hexCharL(int nibble) {
        return (char)(nibble < 10 ? 48 + nibble : 97 + nibble - 10);
    }

    private static final char hexCharU(int nibble) {
        return (char)(nibble < 10 ? 48 + nibble : 65 + nibble - 10);
    }

    public static final StringBuilder hex(StringBuilder sb, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            sb.append(Encode.hexCharL(b >> 4));
            sb.append(Encode.hexCharL(b & 0xF));
        }
        return sb;
    }

    public static final String hexu(byte[] bytes) {
        return Encode.hexu(new StringBuilder(), bytes).toString();
    }

    public static final StringBuilder hexu(StringBuilder sb, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            sb.append(Encode.hexCharU(b >> 4));
            sb.append(Encode.hexCharU(b & 0xF));
        }
        return sb;
    }

    public static final String url(String url, Charset charset) {
        return Encode.url(new StringBuilder(), url, charset).toString();
    }

    public static final StringBuilder url(StringBuilder sb, String url, Charset charset) {
        byte[] bytes = url.getBytes(charset);
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            if (URL_ENCODE_SET.get(c)) {
                sb.append((char)c);
                continue;
            }
            sb.append('%');
            sb.append(Encode.hexCharU(c >> 4));
            sb.append(Encode.hexCharU(c & 0xF));
        }
        return sb;
    }

    public static final String urlPath(String url, Charset charset) {
        return Encode.urlPath(new StringBuilder(), url, charset).toString();
    }

    public static final StringBuilder urlPath(StringBuilder sb, String url, Charset charset) {
        List<String> comps = Strings.split(url, '/');
        for (int i = 0; i < comps.size(); ++i) {
            if (i > 0) {
                sb.append('/');
            }
            sb.append(Encode.url(comps.get(i), charset));
        }
        return sb;
    }

    public static final String html(String str) {
        return Encode.html(new StringBuilder(), str).toString();
    }

    public static final StringBuilder html(StringBuilder sb, String str) {
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    static {
        for (int i = 0; i < ALLOWED_URL_CHARS.length(); ++i) {
            URL_ENCODE_SET.set(ALLOWED_URL_CHARS.charAt(i));
        }
    }
}

