/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils;

import com.github.rjeschke.neetutils.rng.RNG;
import com.github.rjeschke.neetutils.rng.RNGFactory;
import com.github.rjeschke.neetutils.rng.RNGType;

public final class SysUtils {
    private static final ThreadLocal<Object> sleepObject = new ThreadLocal<Object>(){

        @Override
        protected Object initialValue() {
            return new Object();
        }
    };
    private static final ThreadLocal<RNG> RNG = new ThreadLocal<RNG>(){

        @Override
        protected RNG initialValue() {
            return RNGFactory.create(RNGType.LCG);
        }
    };

    private SysUtils() {
    }

    public static final boolean sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static final boolean sleep(long millis, int nanos) {
        try {
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean fineSleep(long millis) {
        Object obj = sleepObject.get();
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait(millis);
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean fineSleep(long millis, int nanos) {
        Object obj = sleepObject.get();
        try {
            Object object = obj;
            synchronized (object) {
                obj.wait(millis, nanos);
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static final boolean threadJoin(Thread t) {
        try {
            t.join();
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static final int rndInt() {
        return RNG.get().nextInt();
    }

    public static final int rndInt(int max) {
        return RNG.get().nextInt(max);
    }

    public static final float rndFloatUnipolar() {
        return RNG.get().nextFloatUnipolar();
    }

    public static final float rndFloatBipolar() {
        return RNG.get().nextFloatBipolar();
    }

    public static final double rndDoubleUnipolar() {
        return RNG.get().nextDoubleUnipolar();
    }

    public static final double rndDoubleBipolar() {
        return RNG.get().nextDoubleBipolar();
    }

    public static final int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static final void gc() {
        System.gc();
    }

    public static final long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static final double usedMemoryRatio() {
        return (double)SysUtils.usedMemory() / (double)SysUtils.maxMemory();
    }

    public static final long freeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static final long maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static final long totalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static final double getJavaVersion() {
        return Double.parseDouble(System.getProperty("java.specification.version"));
    }

    public static final String mapLibraryName(String name) {
        String lib = System.mapLibraryName(name);
        if (SysUtils.getJavaVersion() >= 1.7 && lib.endsWith(".dylib")) {
            return lib.substring(0, lib.length() - 5) + "jnilib";
        }
        return lib;
    }
}

