/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.DefaultClipper;

public class SVF12dB2 {
    private final double fs;
    private double b0;
    private double b1;
    private double f;
    private double fB0;
    private double fB1;
    private double fC0;
    private double a;
    private double b;
    private double r;
    private double ar;
    private double A;
    private double B;
    private double C;
    private Clipper clipper = new DefaultClipper();

    public SVF12dB2(double fs) {
        this.fs = fs;
        this.setButterworthResponse();
    }

    public SVF12dB2 setCoefficients(double a, double b) {
        this.a = a;
        this.b = b;
        this.recalc();
        return this;
    }

    public SVF12dB2 setButterworthResponse() {
        return this.setCoefficients(Math.sqrt(2.0), 1.0);
    }

    public SVF12dB2 setLadderResponse() {
        return this.setCoefficients(2.0, 1.0);
    }

    public void setCutoff(double freq) {
        this.f = Math.tan(Math.PI * freq / this.fs);
        this.recalc();
    }

    public void setQ(double q) {
        this.r = q;
        this.recalc();
    }

    public void reset() {
        this.b1 = 0.0;
        this.b0 = 0.0;
    }

    public SVF12dB2 setClipper(Clipper clipper) {
        this.clipper = clipper;
        return this;
    }

    private void recalc() {
        double rq = 1.0 + this.r;
        this.ar = this.a / rq;
        this.fB0 = 1.0 / (1.0 + this.f * this.ar);
        this.fB1 = this.f * this.fB0;
        this.fC0 = 1.0 / (1.0 + this.fB1 * this.f * this.b);
    }

    public double low() {
        return this.C;
    }

    public double band() {
        return this.B;
    }

    public double high() {
        return this.A;
    }

    public SVF12dB2 process(double input) {
        this.C = (this.b1 + this.fB1 * (this.b0 + this.f * input)) * this.fC0;
        double temp = input - this.b * this.C;
        this.B = (this.b0 + this.f * temp) * this.fB0;
        this.A = temp - this.ar * this.B;
        this.b1 = this.clipper.clip(this.C + this.f * this.B);
        this.b0 = this.clipper.clip(this.B + this.f * this.A);
        return this;
    }
}

