/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.collections;

import com.github.rjeschke.neetutils.collections.ImmutableList;
import com.github.rjeschke.neetutils.collections.IndexedIterator;
import com.github.rjeschke.neetutils.collections.Pair;
import com.github.rjeschke.neetutils.collections.SortedList;
import com.github.rjeschke.neetutils.collections.Tuple;
import com.github.rjeschke.neetutils.fn.FnCombine;
import com.github.rjeschke.neetutils.fn.FnEquals;
import com.github.rjeschke.neetutils.fn.FnFoldStep;
import com.github.rjeschke.neetutils.fn.FnFoldStepWithIndex;
import com.github.rjeschke.neetutils.fn.FnInstance;
import com.github.rjeschke.neetutils.fn.FnMapping;
import com.github.rjeschke.neetutils.fn.FnPredicate;
import com.github.rjeschke.neetutils.fn.Fns;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TreeMap;
import java.util.Vector;

public final class Colls {
    private Colls() {
    }

    public static final <A> List<A> list() {
        return new ArrayList();
    }

    public static final <A> List<A> list(int initialSize) {
        return new ArrayList(initialSize);
    }

    public static final <A> List<A> list(Collection<A> coll) {
        return new ArrayList<A>(coll);
    }

    public static final <A> List<A> list(Iterable<A> coll) {
        List<A> ret = Colls.list();
        for (A a : coll) {
            ret.add(a);
        }
        return ret;
    }

    @SafeVarargs
    public static final <A> List<A> list(A ... coll) {
        List<A> ret = Colls.list(coll.length);
        for (int i = 0; i < coll.length; ++i) {
            ret.add(coll[i]);
        }
        return ret;
    }

    public static final <A> List<A> ilist(Collection<A> coll) {
        return new ImmutableList<A>(coll);
    }

    public static final <A> List<A> ilist(Iterable<A> coll) {
        return new ImmutableList<A>(coll);
    }

    @SafeVarargs
    public static final <A> List<A> ilist(A ... coll) {
        return new ImmutableList<A>(coll);
    }

    public static final <A> Iterable<Tuple<Integer, A>> idxIter(final Collection<A> coll) {
        return new Iterable<Tuple<Integer, A>>(){
            final Collection<A> collection;
            {
                this.collection = coll;
            }

            @Override
            public Iterator<Tuple<Integer, A>> iterator() {
                return new IndexedIterator(this.collection.iterator());
            }
        };
    }

    public static final <A> Iterable<Tuple<Integer, A>> idxIter(final Iterable<A> iter) {
        return new Iterable<Tuple<Integer, A>>(){
            final Iterable<A> iterable;
            {
                this.iterable = iter;
            }

            @Override
            public Iterator<Tuple<Integer, A>> iterator() {
                return new IndexedIterator(this.iterable.iterator());
            }
        };
    }

    public static final <A> List<A> trimToSize(List<A> list) {
        if (list instanceof Vector) {
            ((Vector)list).trimToSize();
        } else if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        } else if (list instanceof SortedList) {
            ((SortedList)list).trimToSize();
        }
        return list;
    }

    public static final <A, B> List<Tuple<A, B>> asList(Map<A, B> map) {
        List<Tuple<A, B>> ret = Colls.list();
        for (Map.Entry<A, B> e : map.entrySet()) {
            ret.add(Tuple.of(e.getKey(), e.getValue()));
        }
        return ret;
    }

    public static final <A extends Comparable<A>, B extends Comparable<B>> List<Pair<A, B>> asPairList(Map<A, B> map) {
        List<Pair<A, B>> ret = Colls.list();
        for (Map.Entry<A, B> e : map.entrySet()) {
            ret.add(Pair.of((Comparable)e.getKey(), (Comparable)e.getValue()));
        }
        return ret;
    }

    public static final <A, B> Map<A, B> intoMap(Iterable<A> keys, Iterable<B> values, Map<A, B> map) {
        Iterator<A> a = keys.iterator();
        Iterator<B> b = values.iterator();
        while (a.hasNext() && b.hasNext()) {
            map.put(a.next(), b.next());
        }
        return map;
    }

    public static final <A, B> Map<A, B> intoMap(Iterable<Tuple<A, B>> keyValues, Map<A, B> map) {
        for (Tuple<A, B> t : keyValues) {
            map.put(t.a, t.b);
        }
        return map;
    }

    public static final <A, B> Map<A, B> toHashMap(Iterable<A> keys, Iterable<B> values) {
        return Colls.intoMap(keys, values, new HashMap());
    }

    public static final <A, B> Map<A, B> toHashMap(Iterable<Tuple<A, B>> keyValues) {
        return Colls.intoMap(keyValues, new HashMap());
    }

    public static final <A, B> Map<A, B> toTreeMap(Iterable<A> keys, Iterable<B> values) {
        return Colls.intoMap(keys, values, new TreeMap());
    }

    public static final <A, B> Map<A, B> toTreeMap(Iterable<Tuple<A, B>> keyValues) {
        return Colls.intoMap(keyValues, new TreeMap());
    }

    public static final <A, B> Map<A, B> toLinkedHashMap(Iterable<A> keys, Iterable<B> values) {
        return Colls.intoMap(keys, values, new LinkedHashMap());
    }

    public static final <A, B> Map<A, B> toLinkedHashMap(Iterable<Tuple<A, B>> keyValues) {
        return Colls.intoMap(keyValues, new LinkedHashMap());
    }

    public static final <A extends Comparable<A>> List<A> sort(List<A> list) {
        Collections.sort(list);
        return list;
    }

    public static final <A> List<A> sort(List<A> list, Comparator<? super A> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static final <A> A head(Iterable<A> coll) {
        return coll.iterator().next();
    }

    public static final <A> A head(List<A> coll) {
        return coll.get(0);
    }

    public static final <A> A last(List<A> coll) {
        return coll.get(coll.size() - 1);
    }

    public static final <A> List<A> tail(Collection<A> coll) {
        return Colls.drop(coll, 1);
    }

    public static final <A> List<A> tail(Iterable<A> coll) {
        return Colls.drop(coll, 1);
    }

    public static final <A> List<A> take(Collection<A> coll, int amount) {
        if (amount >= coll.size()) {
            return Colls.list(coll);
        }
        List<A> ret = Colls.list(amount);
        Iterator<A> it = coll.iterator();
        for (int i = 0; i < amount; ++i) {
            ret.add(it.next());
        }
        return ret;
    }

    public static final <A> List<A> take(Iterable<A> coll, int amount) {
        List<A> ret = Colls.list();
        Iterator<A> it = coll.iterator();
        int i = 0;
        while (i++ < amount && it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public static final <A> List<A> drop(Collection<A> coll, int amount) {
        int i;
        if (amount >= coll.size()) {
            return Colls.list();
        }
        int toTake = coll.size() - amount;
        List<A> ret = Colls.list(toTake);
        Iterator<A> it = coll.iterator();
        for (i = 0; i < amount; ++i) {
            it.next();
        }
        for (i = 0; i < toTake; ++i) {
            ret.add(it.next());
        }
        return ret;
    }

    public static final <A> List<A> drop(Iterable<A> coll, int amount) {
        List<A> ret = Colls.list();
        Iterator<A> it = coll.iterator();
        int i = 0;
        while (i++ < amount && it.hasNext()) {
            it.next();
        }
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public static final <A, B> List<B> map(Collection<A> coll, FnMapping<A, B> fn) {
        List<A> l = Colls.list(coll.size());
        for (A a : coll) {
            l.add(fn.applyMapping(a));
        }
        return l;
    }

    public static final <A, B> List<B> map(Iterable<A> coll, FnMapping<A, B> fn) {
        List<A> l = Colls.list();
        for (A a : coll) {
            l.add(fn.applyMapping(a));
        }
        return l;
    }

    public static final <A> List<A> filter(Iterable<A> coll, FnPredicate<A> fn) {
        List<A> l = Colls.list();
        for (A a : coll) {
            if (!fn.applyPredicate(a)) continue;
            l.add(a);
        }
        return l;
    }

    public static final <A, B> List<B> filterMap(Iterable<A> coll, FnPredicate<A> fnPredicate, FnMapping<A, B> fnMap) {
        List<A> l = Colls.list();
        for (A a : coll) {
            if (!fnPredicate.applyPredicate(a)) continue;
            l.add(fnMap.applyMapping(a));
        }
        return l;
    }

    public static final <A, B> List<B> mapFilter(Iterable<A> coll, FnMapping<A, B> fnMap, FnPredicate<B> fnPredicate) {
        List<A> l = Colls.list();
        for (A a : coll) {
            B b = fnMap.applyMapping(a);
            if (!fnPredicate.applyPredicate(b)) continue;
            l.add(b);
        }
        return l;
    }

    public static final <A, B, C> C mapReduce(Iterable<A> coll, FnMapping<A, B> fnMap, FnFoldStep<B, C> fnReduce, C initial) {
        C c = initial;
        for (A a : coll) {
            c = fnReduce.applyFoldStep(fnMap.applyMapping(a), c);
        }
        return c;
    }

    public static final <A, B, C> C filterMapReduce(Iterable<A> coll, FnPredicate<A> fnPredicate, FnMapping<A, B> fnMap, FnFoldStep<B, C> fnReduce, C initial) {
        C c = initial;
        for (A a : coll) {
            if (!fnPredicate.applyPredicate(a)) continue;
            c = fnReduce.applyFoldStep(fnMap.applyMapping(a), c);
        }
        return c;
    }

    public static final <A, B, C> C mapFilterReduce(Iterable<A> coll, FnMapping<A, B> fnMap, FnPredicate<B> fnPredicate, FnFoldStep<B, C> fnReduce, C initial) {
        C c = initial;
        for (A a : coll) {
            B b = fnMap.applyMapping(a);
            if (!fnPredicate.applyPredicate(b)) continue;
            c = fnReduce.applyFoldStep(b, c);
        }
        return c;
    }

    public static final <A, B> B reduce(List<A> coll, FnFoldStep<A, B> fn, B initial) {
        if (coll instanceof RandomAccess) {
            int sz = coll.size();
            B b = initial;
            for (int i = 0; i < sz; ++i) {
                b = fn.applyFoldStep(coll.get(i), b);
            }
            return b;
        }
        return Colls.reduce(coll, fn, initial);
    }

    public static final <A, B> B reduce(Iterable<A> coll, FnFoldStep<A, B> fn, B initial) {
        B b = initial;
        for (A a : coll) {
            b = fn.applyFoldStep(a, b);
        }
        return b;
    }

    public static final <A, B> B filterReduce(Iterable<A> coll, FnPredicate<A> fnPredicate, FnFoldStep<A, B> fnReduce, B initial) {
        B b = initial;
        for (A a : coll) {
            if (!fnPredicate.applyPredicate(a)) continue;
            b = fnReduce.applyFoldStep(a, b);
        }
        return b;
    }

    public static final <A, B> List<Tuple<A, B>> zip(Collection<A> collA, Collection<B> collB) {
        int todo = Math.min(collA.size(), collB.size());
        List<Tuple<A, B>> ret = Colls.list(todo);
        Iterator<A> a = collA.iterator();
        Iterator<B> b = collB.iterator();
        for (int i = 0; i < todo; ++i) {
            ret.add(Tuple.of(a.next(), b.next()));
        }
        return ret;
    }

    public static final <A, B> List<Tuple<A, B>> zip(Iterable<A> collA, Iterable<B> collB) {
        List<Tuple<A, B>> ret = Colls.list();
        Iterator<A> a = collA.iterator();
        Iterator<B> b = collB.iterator();
        while (a.hasNext() && b.hasNext()) {
            ret.add(Tuple.of(a.next(), b.next()));
        }
        return ret;
    }

    public static final <A, B, C> List<C> zip(Collection<A> collA, Collection<B> collB, FnCombine<A, B, C> fn) {
        int todo = Math.min(collA.size(), collB.size());
        List<A> ret = Colls.list(todo);
        Iterator<A> a = collA.iterator();
        Iterator<B> b = collB.iterator();
        for (int i = 0; i < todo; ++i) {
            ret.add(fn.applyCombine(a.next(), b.next()));
        }
        return ret;
    }

    public static final <A, B, C> List<C> zip(Iterable<A> collA, Iterable<B> collB, FnCombine<A, B, C> fn) {
        List<A> ret = Colls.list();
        Iterator<A> a = collA.iterator();
        Iterator<B> b = collB.iterator();
        while (a.hasNext() && b.hasNext()) {
            ret.add(fn.applyCombine(a.next(), b.next()));
        }
        return ret;
    }

    public static final <A, B> Tuple<List<A>, List<B>> unzip(Collection<Tuple<A, B>> coll) {
        List<A> listA = Colls.list(coll.size());
        List<A> listB = Colls.list(coll.size());
        for (Tuple<A, B> t : coll) {
            listA.add(t.a);
            listB.add(t.b);
        }
        return Tuple.of(listA, listB);
    }

    public static final <A, B> Tuple<List<A>, List<B>> unzip(Iterable<Tuple<A, B>> coll) {
        List<A> listA = Colls.list();
        List<A> listB = Colls.list();
        for (Tuple<A, B> t : coll) {
            listA.add(t.a);
            listB.add(t.b);
        }
        return Tuple.of(listA, listB);
    }

    public static final <A> List<List<A>> partition(Iterable<A> coll, int size) {
        List<List<A>> ret = Colls.list();
        if (size < 1) {
            throw new IllegalArgumentException("Partition size must be > 0");
        }
        List<A> part = Colls.list();
        for (A a : coll) {
            part.add(a);
            if (part.size() != size) continue;
            ret.add(part);
            part = Colls.list();
        }
        if (part.size() > 0) {
            ret.add(part);
        }
        return ret;
    }

    public static final <A> Tuple<List<A>, List<A>> partition(Iterable<A> coll, FnPredicate<A> fn) {
        List<A> l0 = Colls.list();
        List<A> l1 = Colls.list();
        for (A a : coll) {
            if (fn.applyPredicate(a)) {
                l0.add(a);
                continue;
            }
            l1.add(a);
        }
        return Tuple.of(l0, l1);
    }

    public static final <A> List<List<A>> group(Iterable<A> coll) {
        return Colls.group(coll, Fns.examineEquals());
    }

    public static final <A> List<List<A>> group(Iterable<A> coll, FnEquals<A> fn) {
        List<List<A>> ret = Colls.list();
        List<A> part = Colls.list();
        for (A a : coll) {
            if (part.size() == 0) {
                part.add(a);
                continue;
            }
            if (!fn.applyEquals(Colls.last(part), a)) {
                ret.add(part);
                part = Colls.list();
            }
            part.add(a);
        }
        if (part.size() > 0) {
            ret.add(part);
        }
        return ret;
    }

    public static final byte[] asByteArray(Collection<? extends Number> coll) {
        byte[] ret = new byte[coll.size()];
        int i = 0;
        for (Number number : coll) {
            ret[i++] = number.byteValue();
        }
        return ret;
    }

    public static final short[] asShortArray(Collection<? extends Number> coll) {
        short[] ret = new short[coll.size()];
        int i = 0;
        for (Number number : coll) {
            ret[i++] = number.shortValue();
        }
        return ret;
    }

    public static final int[] asIntArray(Collection<? extends Number> coll) {
        int[] ret = new int[coll.size()];
        int i = 0;
        for (Number number : coll) {
            ret[i++] = number.intValue();
        }
        return ret;
    }

    public static final long[] asLongArray(Collection<? extends Number> coll) {
        long[] ret = new long[coll.size()];
        int i = 0;
        for (Number number : coll) {
            ret[i++] = number.longValue();
        }
        return ret;
    }

    public static final float[] asFloatArray(Collection<? extends Number> coll) {
        float[] ret = new float[coll.size()];
        int i = 0;
        for (Number number : coll) {
            ret[i++] = number.floatValue();
        }
        return ret;
    }

    public static final double[] asDoubleArray(Collection<? extends Number> coll) {
        double[] ret = new double[coll.size()];
        int i = 0;
        for (Number number : coll) {
            ret[i++] = number.doubleValue();
        }
        return ret;
    }

    @SafeVarargs
    public static <T> T[] objArray(T ... ts) {
        return ts;
    }

    public static byte[] array(byte ... bytes) {
        return bytes;
    }

    public static short[] array(short ... shorts) {
        return shorts;
    }

    public static char[] array(char ... chars) {
        return chars;
    }

    public static int[] array(int ... ints) {
        return ints;
    }

    public static long[] array(long ... longs) {
        return longs;
    }

    public static float[] array(float ... floats) {
        return floats;
    }

    public static double[] array(double ... doubles) {
        return doubles;
    }

    @SafeVarargs
    public static <T> void addAll(Collection<T> coll, T ... ts) {
        for (T t : ts) {
            coll.add(t);
        }
    }

    public static <T> void addAll(Collection<T> coll, Iterable<T> iterable) {
        for (T t : iterable) {
            coll.add(t);
        }
    }

    public static <A, B> B get(Map<A, B> map, A key, B def) {
        B b = map.get(key);
        return b == null ? def : b;
    }

    public static <A, B> B get(Map<A, B> map, A key, FnInstance<B> def) {
        B b = map.get(key);
        return b == null ? def.newInstance() : b;
    }

    public static <A, B> B getOrCreate(Map<A, B> map, A key, B def) {
        B b = map.get(key);
        if (b == null) {
            map.put(key, def);
            return def;
        }
        return b;
    }

    public static <A, B> B getOrCreate(Map<A, B> map, A key, FnInstance<B> def) {
        B b = map.get(key);
        if (b == null) {
            B d = def.newInstance();
            map.put(key, d);
            return d;
        }
        return b;
    }

    public static final <A, B> B reduce(List<A> coll, FnFoldStepWithIndex<A, B> fn, B initial) {
        if (coll instanceof RandomAccess) {
            int sz = coll.size();
            B b = initial;
            for (int i = 0; i < sz; ++i) {
                b = fn.applyFoldStep(coll.get(i), b, i);
            }
            return b;
        }
        return Colls.reduce(coll, fn, initial);
    }

    public static final <A, B> B reduce(Iterable<A> coll, FnFoldStepWithIndex<A, B> fn, B initial) {
        B b = initial;
        int i = 0;
        for (A a : coll) {
            b = fn.applyFoldStep(a, b, i++);
        }
        return b;
    }
}

