/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SortedList<E extends Comparable<? super E>>
implements List<E>,
Cloneable {
    private final ArrayList<E> list;
    private final Comparator<? super E> comparator;

    public SortedList() {
        this.list = new ArrayList();
        this.comparator = null;
    }

    public SortedList(int initialSize) {
        this.list = new ArrayList(initialSize);
        this.comparator = null;
    }

    public SortedList(Comparator<? super E> comparator) {
        this.list = new ArrayList();
        this.comparator = comparator;
    }

    public SortedList(Collection<? extends E> c) {
        this.list = new ArrayList();
        this.comparator = null;
        this.addAll(c);
    }

    public SortedList(Collection<? extends E> c, Comparator<? super E> comparator) {
        this.list = new ArrayList();
        this.comparator = comparator;
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        int index;
        int n = index = this.comparator == null ? Collections.binarySearch(this.list, e) : Collections.binarySearch(this.list, e, this.comparator);
        if (index < 0) {
            this.list.add(-index - 1, e);
        } else {
            this.list.add(index + 1, e);
        }
        return true;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (Comparable e : c) {
            this.add((E)e);
        }
        return c.size() > 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public E get(int index) {
        return (E)((Comparable)this.list.get(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public E remove(int index) {
        return (E)((Comparable)this.list.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public SortedList<E> clone() {
        return this.comparator == null ? new SortedList<E>(this.list) : new SortedList<E>(this.list, this.comparator);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SortedList)) {
            return false;
        }
        return this.list.equals(((SortedList)obj).list);
    }

    public String toString() {
        return this.list.toString();
    }

    public void trimToSize() {
        this.list.trimToSize();
    }
}

