/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.concurrent;

import com.github.rjeschke.neetutils.SysUtils;
import com.github.rjeschke.neetutils.concurrent.RequeueWatcher;
import com.github.rjeschke.neetutils.concurrent.RequeueWatcherCallback;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;

public class ThreadPool
implements RequeueWatcherCallback<Runnable, ThreadWorker> {
    private final int numThreads;
    private final int queueLimit;
    private final ConcurrentLinkedQueue<ThreadWorker> workers = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> jobs = new ConcurrentLinkedQueue();
    private final Thread[] threads;
    private RequeueWatcher<Runnable, ThreadWorker> watcher;

    private ThreadPool(int threads, int queueLimit) {
        this.numThreads = threads;
        this.queueLimit = Math.max(0, queueLimit);
        this.threads = new Thread[threads];
    }

    public static final int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    static final int defaultThreadcount(int threads) {
        return threads < 1 ? Runtime.getRuntime().availableProcessors() : threads;
    }

    public static ThreadPool start(int threads, int queueLimit) {
        ThreadPool jobber = new ThreadPool(ThreadPool.defaultThreadcount(threads), queueLimit);
        for (int i = 0; i < jobber.threads.length; ++i) {
            ThreadWorker w = new ThreadWorker(jobber);
            Thread t = new Thread(w);
            t.setDaemon(true);
            jobber.workers.offer(w);
            t.start();
            jobber.threads[i] = t;
        }
        jobber.watcher = RequeueWatcher.start(jobber, jobber.jobs, jobber.workers);
        return jobber;
    }

    public int threadCount() {
        return this.numThreads;
    }

    public void enqueue(Runnable job) {
        if (job == null) {
            throw new NullPointerException("A null Runnable is not permitted");
        }
        ThreadWorker w = this.workers.poll();
        if (w != null) {
            w.setWorkLoad(job);
        } else {
            if (this.queueLimit != 0 && this.jobs.size() >= this.queueLimit) {
                int ql = Math.max(this.queueLimit >> 1, 1);
                while (this.jobs.size() > ql) {
                    SysUtils.fineSleep(5L);
                }
            }
            this.jobs.offer(job);
        }
    }

    void reuseOrEnqueue(ThreadWorker w) {
        Runnable job = this.jobs.poll();
        if (job != null) {
            w.setWorkLoad(job);
        } else {
            this.workers.offer(w);
        }
    }

    public boolean hasWork() {
        return !this.jobs.isEmpty();
    }

    public void join() {
        while (!this.jobs.isEmpty()) {
            SysUtils.sleep(10L);
        }
    }

    public void stop() {
        int i;
        StopWorker stop = new StopWorker();
        this.join();
        for (i = 0; i < this.numThreads; ++i) {
            this.enqueue(stop);
        }
        for (i = 0; i < this.numThreads; ++i) {
            SysUtils.threadJoin(this.threads[i]);
        }
        this.watcher.stop();
    }

    @Override
    public void requeue(ThreadWorker worker, Runnable job) {
        worker.setWorkLoad(job);
    }

    static class StopWorker
    implements Runnable {
        @Override
        public void run() {
        }
    }

    static class ThreadWorker
    implements Runnable {
        private final Semaphore sync = new Semaphore(1);
        private final ThreadPool pool;
        private volatile Runnable workload = null;

        public ThreadWorker(ThreadPool pool) {
            this.sync.acquireUninterruptibly();
            this.pool = pool;
        }

        protected void setWorkLoad(Runnable job) {
            this.workload = job;
            this.sync.release();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.sync.acquireUninterruptibly();
                    if (this.workload instanceof StopWorker) break;
                    this.workload.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.pool.reuseOrEnqueue(this);
            }
        }
    }
}

