/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.fn;

import com.github.rjeschke.neetutils.collections.Colls;
import com.github.rjeschke.neetutils.fn.FnEquals;
import com.github.rjeschke.neetutils.fn.FnFoldStep;
import com.github.rjeschke.neetutils.fn.FnInstance;
import com.github.rjeschke.neetutils.fn.FnPredicate;
import com.github.rjeschke.neetutils.math.Numbers;
import java.util.List;
import java.util.Map;

public final class Fns {
    private Fns() {
    }

    public static final <A> FnFoldStep<A, Map<A, Integer>> objectFrequencies() {
        return new FnFoldStep<A, Map<A, Integer>>(){

            @Override
            public Map<A, Integer> applyFoldStep(A a, Map<A, Integer> b) {
                Integer i = b.get(a);
                b.put(a, i == null ? Numbers.integerOf(1) : Numbers.integerOf(i + 1));
                return b;
            }
        };
    }

    public static final <A> FnPredicate<A> invert(final FnPredicate<A> predicate) {
        return new FnPredicate<A>(){

            @Override
            public boolean applyPredicate(A a) {
                return !predicate.applyPredicate(a);
            }
        };
    }

    public static final <A> FnEquals<A> examineEquals() {
        return new FnEquals<A>(){

            @Override
            public boolean applyEquals(A a, A b) {
                if (a == null) {
                    return b == null;
                }
                return a.equals(b);
            }
        };
    }

    public static final <A> FnInstance<List<A>> newListInstance() {
        return new FnInstance<List<A>>(){

            @Override
            public List<A> newInstance() {
                return Colls.list();
            }
        };
    }
}

