/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import com.github.rjeschke.neetutils.graphics.NColorMatrix;
import com.github.rjeschke.neetutils.math.NMath;
import java.awt.Color;

public class NColor {
    public final float a;
    public final float r;
    public final float g;
    public final float b;
    public static final NColor WHITE = new NColor(-1);
    public static final NColor BLACK = new NColor(-16777216);
    public static final NColor RED = new NColor(-65536);
    public static final NColor GREEN = new NColor(-16711936);
    public static final NColor BLUE = new NColor(-16776961);
    public static final NColor WHITE_TRANS = new NColor(0xFFFFFF);
    public static final NColor BLACK_TRANS = new NColor(0);

    public NColor(int argb) {
        this.a = (float)(argb >>> 24) / 255.0f;
        this.r = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.g = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.b = (float)(argb & 0xFF) / 255.0f;
    }

    public NColor(Color c) {
        this.a = (float)c.getAlpha() / 255.0f;
        this.r = (float)c.getRed() / 255.0f;
        this.g = (float)c.getGreen() / 255.0f;
        this.b = (float)c.getBlue() / 255.0f;
    }

    public NColor(NColor c, float a) {
        this.a = a;
        this.r = c.r;
        this.g = c.g;
        this.b = c.b;
    }

    public NColor(int argb, double exp) {
        this.a = (float)(argb >>> 24) / 255.0f;
        this.r = (float)Math.pow((double)(argb >> 16 & 0xFF) / 255.0, exp);
        this.g = (float)Math.pow((double)(argb >> 8 & 0xFF) / 255.0, exp);
        this.b = (float)Math.pow((double)(argb & 0xFF) / 255.0, exp);
    }

    public NColor(int a, int r, int g, int b) {
        this.a = (float)a / 255.0f;
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
    }

    public NColor(float a, float r, float g, float b) {
        this.a = a;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public NColor(double a, double r, double g, double b) {
        this.a = (float)a;
        this.r = (float)r;
        this.g = (float)g;
        this.b = (float)b;
    }

    public NColor(int r, int g, int b) {
        this.a = 1.0f;
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
    }

    public NColor(float r, float g, float b) {
        this.a = 1.0f;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public NColor(double r, double g, double b) {
        this.a = 1.0f;
        this.r = (float)r;
        this.g = (float)g;
        this.b = (float)b;
    }

    public NColor(float a, NColor c) {
        this.a = a;
        this.r = c.r;
        this.g = c.g;
        this.b = c.b;
    }

    public NColor(double a, NColor c) {
        this.a = (float)a;
        this.r = c.r;
        this.g = c.g;
        this.b = c.b;
    }

    public float dot(NColor c) {
        return NColor.dot(this, c);
    }

    public static float dot(NColor a, NColor b) {
        return a.a * b.a + a.r * b.r + a.g * b.g + a.b + b.b;
    }

    public float dotRGB(NColor c) {
        return NColor.dotRGB(this, c);
    }

    public static float dotRGB(NColor a, NColor b) {
        return a.r * b.r + a.g * b.g + a.b + b.b;
    }

    public NColor add(NColor c) {
        return NColor.add(this, c);
    }

    public static NColor add(NColor a, NColor b) {
        return new NColor(a.a + b.a, a.r + b.r, a.g + b.g, a.b + b.b);
    }

    public NColor addRGB(NColor c) {
        return NColor.addRGB(this, c);
    }

    public static NColor addRGB(NColor a, NColor b) {
        return new NColor(a.a, a.r + b.r, a.g + b.g, a.b + b.b);
    }

    public NColor add(NColor c, float scale) {
        return NColor.add(this, c, scale);
    }

    public static NColor add(NColor a, NColor b, float scale) {
        return new NColor(a.a + b.a * scale, a.r + b.r * scale, a.g + b.g * scale, a.b + b.b * scale);
    }

    public NColor addRGB(NColor c, float scale) {
        return NColor.addRGB(this, c, scale);
    }

    public static NColor addRGB(NColor a, NColor b, float scale) {
        return new NColor(a.a, a.r + b.r * scale, a.g + b.g * scale, a.b + b.b * scale);
    }

    public NColor sub(NColor c) {
        return NColor.sub(this, c);
    }

    public static NColor sub(NColor a, NColor b) {
        return new NColor(a.a - b.a, a.r - b.r, a.g - b.g, a.b - b.b);
    }

    public NColor subRGB(NColor c) {
        return NColor.subRGB(this, c);
    }

    public static NColor subRGB(NColor a, NColor b) {
        return new NColor(a.a, a.r - b.r, a.g - b.g, a.b - b.b);
    }

    public NColor mul(NColor c) {
        return NColor.mul(this, c);
    }

    public static NColor mul(NColor a, NColor b) {
        return new NColor(a.a * b.a, a.r * b.r, a.g * b.g, a.b * b.b);
    }

    public NColor mulRGB(NColor c) {
        return NColor.mulRGB(this, c);
    }

    public static NColor mulRGB(NColor a, NColor b) {
        return new NColor(a.a, a.r * b.r, a.g * b.g, a.b * b.b);
    }

    public NColor scale(float scale) {
        return NColor.scale(this, scale);
    }

    public static NColor scale(NColor c, float scale) {
        return new NColor(c.a * scale, c.r * scale, c.g * scale, c.b * scale);
    }

    public NColor scaleRGB(float scale) {
        return NColor.scaleRGB(this, scale);
    }

    public static NColor scaleRGB(NColor c, float scale) {
        return new NColor(c.a, c.r * scale, c.g * scale, c.b * scale);
    }

    public NColor lerp(NColor b, float f) {
        return NColor.lerp(this, b, f);
    }

    public static NColor lerp(NColor a, NColor b, float f) {
        return new NColor(a.a + (b.a - a.a) * f, a.r + (b.r - a.r) * f, a.g + (b.g - a.g) * f, a.b + (b.b - a.b) * f);
    }

    public NColor lerpRGB(NColor b, float f) {
        return NColor.lerpRGB(this, b, f);
    }

    public static NColor lerpRGB(NColor a, NColor b, float f) {
        return new NColor(a.a, a.r + (b.r - a.r) * f, a.g + (b.g - a.g) * f, a.b + (b.b - a.b) * f);
    }

    public NColor blendOver(NColor src) {
        return NColor.blendOver(src, this);
    }

    public static NColor blendOver(NColor src, NColor dst) {
        float da = NMath.clamp(dst.a, 0.0f, 1.0f);
        float sa = NMath.clamp(src.a, 0.0f, 1.0f);
        if (da == 1.0f) {
            float a = 1.0f - sa;
            float r = sa * src.r + dst.r * a;
            float g = sa * src.g + dst.g * a;
            float b = sa * src.b + dst.b * a;
            return new NColor(1.0f, r, g, b);
        }
        if (da == 0.0f) {
            float r = sa * src.r;
            float g = sa * src.g;
            float b = sa * src.b;
            return new NColor(sa, r, g, b);
        }
        float a = 1.0f - sa;
        float outa = sa + da * a;
        if (outa <= 0.0f) {
            return BLACK_TRANS;
        }
        float outar = 1.0f / outa;
        float r = (sa * src.r + da * dst.r * a) * outar;
        float g = (sa * src.g + da * dst.g * a) * outar;
        float b = (sa * src.b + da * dst.b * a) * outar;
        return new NColor(outa, r, g, b);
    }

    public NColor saturate() {
        return NColor.saturate(this);
    }

    public static NColor saturate(NColor c) {
        return new NColor(NMath.clamp(c.a, 0.0f, 1.0f), NMath.clamp(c.r, 0.0f, 1.0f), NMath.clamp(c.g, 0.0f, 1.0f), NMath.clamp(c.b, 0.0f, 1.0f));
    }

    public NColor powRGB(double exp) {
        return NColor.powRGB(this, exp);
    }

    public static NColor powRGB(NColor c, double exp) {
        return new NColor(NMath.clamp(c.a, 0.0f, 1.0f), (float)Math.pow(NMath.clamp(c.r, 0.0f, 1.0f), exp), (float)Math.pow(NMath.clamp(c.g, 0.0f, 1.0f), exp), (float)Math.pow(NMath.clamp(c.b, 0.0f, 1.0f), exp));
    }

    public float luminance() {
        return NColor.luminance(this);
    }

    public static float luminance(NColor c) {
        return 0.299f * c.r + 0.587f * c.g + 0.114f * c.b;
    }

    public static int alpha(int argb) {
        return argb >>> 24;
    }

    public static float alphaf(int argb) {
        return (float)(argb >>> 24) / 255.0f;
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static float redf(int argb) {
        return (float)(argb >> 16 & 0xFF) / 255.0f;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static float greenf(int argb) {
        return (float)(argb >> 8 & 0xFF) / 255.0f;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    public static float bluef(int argb) {
        return (float)(argb & 0xFF) / 255.0f;
    }

    public int toARGB() {
        return NColor.toARGB(this);
    }

    public int toARGB(double exp) {
        return NColor.toARGB(this, exp);
    }

    public static int toARGB(NColor c) {
        int a = NMath.clamp((int)(c.a * 255.0f + 0.5f), 0, 255);
        int r = NMath.clamp((int)(c.r * 255.0f + 0.5f), 0, 255);
        int g = NMath.clamp((int)(c.g * 255.0f + 0.5f), 0, 255);
        int b = NMath.clamp((int)(c.b * 255.0f + 0.5f), 0, 255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int toARGB(NColor c, double exp) {
        int a = NMath.clamp((int)(c.a * 255.0f), 0, 255);
        int r = (int)(Math.pow(NMath.clamp(c.r, 0.0f, 1.0f), exp) * 255.0 + 0.5);
        int g = (int)(Math.pow(NMath.clamp(c.g, 0.0f, 1.0f), exp) * 255.0 + 0.5);
        int b = (int)(Math.pow(NMath.clamp(c.b, 0.0f, 1.0f), exp) * 255.0 + 0.5);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int toARGB(double r, double g, double b) {
        int ir = NMath.clamp((int)(r * 255.0 + 0.5), 0, 255);
        int ig = NMath.clamp((int)(g * 255.0 + 0.5), 0, 255);
        int ib = NMath.clamp((int)(b * 255.0 + 0.5), 0, 255);
        return 0xFF000000 | ir << 16 | ig << 8 | ib;
    }

    public static int toARGB(int r, int g, int b) {
        return 0xFF000000 | NMath.clamp(r, 0, 255) << 16 | NMath.clamp(g, 0, 255) << 8 | NMath.clamp(b, 0, 255);
    }

    public static int toARGBg(double r, double g, double b, double exp) {
        int ir = (int)(Math.pow(NMath.clamp(r, 0.0, 1.0), exp) * 255.0 + 0.5);
        int ig = (int)(Math.pow(NMath.clamp(g, 0.0, 1.0), exp) * 255.0 + 0.5);
        int ib = (int)(Math.pow(NMath.clamp(b, 0.0, 1.0), exp) * 255.0 + 0.5);
        return 0xFF000000 | ir << 16 | ig << 8 | ib;
    }

    public static int toARGB(double r, double g, double b, double a) {
        int ia = NMath.clamp((int)(a * 255.0 + 0.5), 0, 255);
        int ir = NMath.clamp((int)(r * 255.0 + 0.5), 0, 255);
        int ig = NMath.clamp((int)(g * 255.0 + 0.5), 0, 255);
        int ib = NMath.clamp((int)(b * 255.0 + 0.5), 0, 255);
        return ia << 24 | ir << 16 | ig << 8 | ib;
    }

    public static int toARGB(int r, int g, int b, int a) {
        return NMath.clamp(a, 0, 255) << 24 | NMath.clamp(r, 0, 255) << 16 | NMath.clamp(g, 0, 255) << 8 | NMath.clamp(b, 0, 255);
    }

    public static int toARGBg(double r, double g, double b, double a, double exp) {
        int ia = NMath.clamp((int)(a * 255.0), 0, 255);
        int ir = (int)(Math.pow(NMath.clamp(r, 0.0, 1.0), exp) * 255.0 + 0.5);
        int ig = (int)(Math.pow(NMath.clamp(g, 0.0, 1.0), exp) * 255.0 + 0.5);
        int ib = (int)(Math.pow(NMath.clamp(b, 0.0, 1.0), exp) * 255.0 + 0.5);
        return ia << 24 | ir << 16 | ig << 8 | ib;
    }

    public static double hueFunction(double t) {
        double t1 = 6.0 * NMath.wrap1(t);
        return NMath.clamp(t1 < 3.0 ? 2.0 - t1 : t1 - 4.0, 0.0, 1.0);
    }

    public static int hsv2rgb(double h, double s, double v) {
        int r;
        int g;
        int b;
        if (s == 0.0) {
            g = b = (int)(v * 255.0 + 0.5);
            r = b;
        } else {
            double c = s * v;
            double m = 255.0 * (v - c) + 0.5;
            r = (int)(m + (c *= 255.0) * NColor.hueFunction(h));
            g = (int)(m + c * NColor.hueFunction(h + 0.6666666666666666));
            b = (int)(m + c * NColor.hueFunction(h + 0.3333333333333333));
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int hsv2rgbClamped(double h, double s, double v) {
        int r;
        int g;
        int b;
        if (s == 0.0) {
            g = b = (int)(v * 255.0 + 0.5);
            r = b;
        } else {
            double c = s * v;
            double m = 255.0 * (v - c) + 0.5;
            r = (int)(m + (c *= 255.0) * NColor.hueFunction(h));
            g = (int)(m + c * NColor.hueFunction(h + 0.6666666666666666));
            b = (int)(m + c * NColor.hueFunction(h + 0.3333333333333333));
        }
        return 0xFF000000 | NMath.clamp(r, 0, 255) << 16 | NMath.clamp(g, 0, 255) << 8 | NMath.clamp(b, 0, 255);
    }

    public static double[] rgb2hsv(int argb, double[] hsv) {
        return NColor.rgb2hsv((double)(argb >> 16 & 0xFF) * 0.00392156862745098, (double)(argb >> 8 & 0xFF) * 0.00392156862745098, (double)(argb & 0xFF) * 0.00392156862745098, hsv);
    }

    public static double[] rgb2hsv(int argb) {
        return NColor.rgb2hsv((double)(argb >> 16 & 0xFF) * 0.00392156862745098, (double)(argb >> 8 & 0xFF) * 0.00392156862745098, (double)(argb & 0xFF) * 0.00392156862745098, new double[3]);
    }

    public static double[] rgb2hsv(double r, double g, double b) {
        return NColor.rgb2hsv(r, g, b, new double[3]);
    }

    public static double[] rgb2hsv(double r, double g, double b, double[] hsv) {
        double m;
        double c;
        int idx = 0;
        double max = r;
        if (g > max) {
            idx = 1;
            max = g;
        }
        if (b > max) {
            idx = 2;
            max = b;
        }
        if ((c = max - (m = Math.min(r, Math.min(g, b)))) > 0.0) {
            double h;
            hsv[1] = c / (m + c);
            hsv[2] = c / hsv[1];
            switch (idx) {
                default: {
                    h = (g - b) / c;
                    break;
                }
                case 1: {
                    h = 2.0 + (b - r) / c;
                    break;
                }
                case 2: {
                    h = 4.0 + (r - g) / c;
                }
            }
            hsv[0] = NMath.wrap1(h * 0.16666666666666666);
        } else {
            hsv[0] = 0.0;
            hsv[1] = 0.0;
            hsv[2] = max;
        }
        return hsv;
    }

    public Color toColor() {
        return NColor.toColor(this);
    }

    public static Color toColor(NColor c) {
        return new Color(NColor.toARGB(c), true);
    }

    public NColor transform(NColorMatrix m) {
        return NColor.transform(this, m);
    }

    public static NColor transform(NColor c, NColorMatrix m) {
        return new NColor(c.a, c.r * m.m[0] + c.g * m.m[1] + c.b * m.m[2], c.r * m.m[3] + c.g * m.m[4] + c.b * m.m[5], c.r * m.m[6] + c.g * m.m[7] + c.b * m.m[8]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(this.a);
        sb.append(", ");
        sb.append(this.r);
        sb.append(", ");
        sb.append(this.g);
        sb.append(", ");
        sb.append(this.b);
        sb.append('}');
        return sb.toString();
    }
}

