/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import com.github.rjeschke.neetutils.collections.Colls;
import com.github.rjeschke.neetutils.concurrent.Worker;
import com.github.rjeschke.neetutils.concurrent.WorkerCallback;
import com.github.rjeschke.neetutils.concurrent.WorkerPool;
import com.github.rjeschke.neetutils.concurrent.WorkerStatus;
import com.github.rjeschke.neetutils.graphics.ClampMode;
import com.github.rjeschke.neetutils.graphics.ColorOp;
import com.github.rjeschke.neetutils.graphics.FilterKernel;
import com.github.rjeschke.neetutils.graphics.NColor;
import com.github.rjeschke.neetutils.graphics.NImageBoxDownsampler;
import com.github.rjeschke.neetutils.graphics.NImageFilter;
import com.github.rjeschke.neetutils.graphics.NImagePBlock;
import com.github.rjeschke.neetutils.graphics.NImagePerlin;
import com.github.rjeschke.neetutils.graphics.NImageVoronoi;
import com.github.rjeschke.neetutils.graphics.WrappedImage;
import com.github.rjeschke.neetutils.math.NMath;
import com.github.rjeschke.neetutils.rng.RNG;
import com.github.rjeschke.neetutils.rng.RNGFactory;
import com.github.rjeschke.neetutils.rng.RNGType;
import com.github.rjeschke.neetutils.vectors.Vector3f;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.List;

public class NImage
implements WorkerCallback<NImagePBlock> {
    public final int width;
    public final int height;
    final NColor[] pixels;
    private ClampMode clampX = ClampMode.CLAMP_TO_EDGE;
    private ClampMode clampY = ClampMode.CLAMP_TO_EDGE;
    private ColorOp cop = ColorOp.SET;
    private int processingThreads = 1;
    static final float[] SOBEL_X = Colls.array(1.0f, 0.0f, -1.0f, 2.0f, 0.0f, -2.0f, 1.0f, 0.0f, -1.0f);
    static final float[] SOBEL_Y = Colls.array(1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -2.0f, -1.0f);
    static final int[] PAINT_DX = Colls.array(1, 1, 0);
    static final int[] PAINT_DY = Colls.array(0, -1, -1);
    static final int BLOCK_SIZE = 8;
    private static final double TO_sRGB = 0.45454545454545453;
    private static final double FROM_sRGB = 2.2;

    public NImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.pixels = new NColor[width * height];
        Arrays.fill(this.pixels, NColor.BLACK_TRANS);
    }

    public NImage(NImage image) {
        this.width = image.width;
        this.height = image.height;
        this.pixels = new NColor[this.width * this.height];
        this.processingThreads = image.processingThreads;
        System.arraycopy(image.pixels, 0, this.pixels, 0, this.pixels.length);
    }

    public NImage(BufferedImage image) {
        this(image, 2.2);
    }

    public NImage(WrappedImage image) {
        this(image.getImage(), 2.2);
    }

    public NImage(BufferedImage image, double gamma) {
        BufferedImage img = NImage.forceARGB(image);
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.pixels = new NColor[this.width * this.height];
        int[] pix = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        if (gamma != 1.0) {
            for (int i = 0; i < pix.length; ++i) {
                this.pixels[i] = new NColor(pix[i], gamma);
            }
        } else {
            for (int i = 0; i < pix.length; ++i) {
                this.pixels[i] = new NColor(pix[i]);
            }
        }
    }

    private static BufferedImage forceARGB(BufferedImage in) {
        if (in.getType() == 2) {
            return in;
        }
        BufferedImage img = new BufferedImage(in.getWidth(), in.getHeight(), 2);
        Graphics2D g = img.createGraphics();
        g.drawImage((Image)in, 0, 0, null);
        g.dispose();
        return img;
    }

    private static final int clampXY(ClampMode c, int v, int max) {
        switch (c) {
            default: {
                return NMath.clamp(v, 0, max - 1);
            }
            case WRAP: 
        }
        int temp = v % max;
        return temp < 0 ? temp + max : temp;
    }

    private int clampX(int x) {
        return NImage.clampXY(this.clampX, x, this.width);
    }

    private int clampY(int y) {
        return NImage.clampXY(this.clampY, y, this.height);
    }

    private int clampedPos(int x, int y) {
        return this.clampX(x) + this.clampY(y) * this.width;
    }

    public NImage setThreadCount(int threads) {
        this.processingThreads = Math.max(1, threads);
        return this;
    }

    public void setPixel(int x, int y, NColor c) {
        if (this.clampX == ClampMode.CLIP && x < 0 || x >= this.width) {
            return;
        }
        if (this.clampY == ClampMode.CLIP && y < 0 || y >= this.height) {
            return;
        }
        int p = this.clampedPos(x, y);
        switch (this.cop) {
            default: {
                this.pixels[p] = c;
                break;
            }
            case ADD: {
                this.pixels[p] = this.pixels[p].add(c);
                break;
            }
            case SUB: {
                this.pixels[p] = this.pixels[p].sub(c);
                break;
            }
            case MUL: {
                this.pixels[p] = this.pixels[p].mul(c);
                break;
            }
            case ADD_RGB: {
                this.pixels[p] = this.pixels[p].addRGB(c);
                break;
            }
            case SUB_RGB: {
                this.pixels[p] = this.pixels[p].subRGB(c);
                break;
            }
            case MUL_RGB: {
                this.pixels[p] = this.pixels[p].mulRGB(c);
                break;
            }
            case BLEND: {
                this.pixels[p] = this.pixels[p].blendOver(c);
                break;
            }
            case BLEND1: {
                this.pixels[p] = new NColor(this.pixels[p].a, NColor.lerpRGB(this.pixels[p], c, c.a));
            }
        }
    }

    public NImage forceFill(NColor c) {
        Arrays.fill(this.pixels, c);
        return this;
    }

    public NImage fill(NColor c) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.setPixel(x, y, c);
            }
        }
        return this;
    }

    public NColor getPixel(int x, int y) {
        if (this.clampX == ClampMode.CLIP && x < 0 || x >= this.width) {
            return NColor.BLACK_TRANS;
        }
        if (this.clampY == ClampMode.CLIP && y < 0 || y >= this.height) {
            return NColor.BLACK_TRANS;
        }
        return this.pixels[this.clampedPos(x, y)];
    }

    public NImage clampColors() {
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = this.pixels[i].saturate();
        }
        return this;
    }

    public NImage invertColors() {
        for (int i = 0; i < this.pixels.length; ++i) {
            NColor c = this.pixels[i];
            this.pixels[i] = new NColor(1.0 - (double)c.a, 1.0 - (double)c.r, 1.0 - (double)c.g, 1.0 - (double)c.b);
        }
        return this;
    }

    public NImage invertColorsRGB() {
        for (int i = 0; i < this.pixels.length; ++i) {
            NColor c = this.pixels[i];
            this.pixels[i] = new NColor((double)c.a, 1.0 - (double)c.r, 1.0 - (double)c.g, 1.0 - (double)c.b);
        }
        return this;
    }

    public void setClampMode(ClampMode clampX, ClampMode clampY) {
        this.clampX = clampX;
        this.clampY = clampY;
    }

    public void setColorOp(ColorOp op) {
        this.cop = op;
    }

    public NImage normalizeColors() {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < this.pixels.length; ++i) {
            NColor c = this.pixels[i];
            min = Math.min(min, c.a);
            min = Math.min(min, c.r);
            min = Math.min(min, c.g);
            min = Math.min(min, c.b);
            max = Math.max(max, c.a);
            max = Math.max(max, c.r);
            max = Math.max(max, c.g);
            max = Math.max(max, c.b);
        }
        float d = max - min;
        d = d == 0.0f ? 1.0f : 1.0f / d;
        for (int i = 0; i < this.pixels.length; ++i) {
            NColor c = this.pixels[i];
            this.pixels[i] = new NColor((c.a - min) * d, (c.r - min) * d, (c.g - min) * d, (c.b - min) * d);
        }
        return this;
    }

    public NImage setAlpha(float alpha) {
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = new NColor(alpha, this.pixels[i]);
        }
        return this;
    }

    public NImage toGrayscale() {
        for (int i = 0; i < this.pixels.length; ++i) {
            NColor c = this.pixels[i];
            float l = c.luminance();
            this.pixels[i] = new NColor(c.a, l, l, l);
        }
        return this;
    }

    public BufferedImage toBufferedImageARGB() {
        return this.toBufferedImageARGB(0.45454545454545453);
    }

    public BufferedImage toBufferedImageARGB(double gamma) {
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        int[] pix = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        if (gamma != 1.0) {
            for (int i = 0; i < pix.length; ++i) {
                pix[i] = this.pixels[i].toARGB(gamma);
            }
        } else {
            for (int i = 0; i < pix.length; ++i) {
                pix[i] = this.pixels[i].toARGB();
            }
        }
        return img;
    }

    public BufferedImage toBufferedImageARGBDithered() {
        return this.toBufferedImageARGBDithered(0.45454545454545453);
    }

    public BufferedImage toBufferedImageARGBDithered(double gamma) {
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        int[] pix = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        float[] err0 = new float[3 * this.width + 6];
        float[] err1 = new float[3 * this.width + 6];
        float e0 = 0.4375f;
        float e1 = 0.1875f;
        float e2 = 0.3125f;
        float e3 = 0.0625f;
        for (int y = 0; y < this.height; ++y) {
            System.arraycopy(err1, 0, err0, 0, err0.length);
            Arrays.fill(err1, 0.0f);
            for (int x = 0; x < this.width; ++x) {
                int p = x * 3 + 3;
                NColor co = this.pixels[x + y * this.width].saturate();
                if (gamma != 1.0) {
                    co = co.powRGB(gamma);
                }
                int a = NMath.clamp((int)(co.a * 255.0f), 0, 255);
                int r = NMath.clamp((int)((co.r + err0[p]) * 255.0f), 0, 255);
                int g = NMath.clamp((int)((co.g + err0[p + 1]) * 255.0f), 0, 255);
                int b = NMath.clamp((int)((co.b + err0[p + 2]) * 255.0f), 0, 255);
                float er = co.r - (float)r / 255.0f;
                float eg = co.g - (float)g / 255.0f;
                float eb = co.b - (float)b / 255.0f;
                int n = p + 3 + 0;
                err0[n] = err0[n] + er * 0.4375f;
                int n2 = p + 3 + 1;
                err0[n2] = err0[n2] + eg * 0.4375f;
                int n3 = p + 3 + 2;
                err0[n3] = err0[n3] + eb * 0.4375f;
                int n4 = p - 3 + 0;
                err1[n4] = err1[n4] + er * 0.1875f;
                int n5 = p - 3 + 1;
                err1[n5] = err1[n5] + eg * 0.1875f;
                int n6 = p - 3 + 2;
                err1[n6] = err1[n6] + eb * 0.1875f;
                int n7 = p + 0;
                err1[n7] = err1[n7] + er * 0.3125f;
                int n8 = p + 1;
                err1[n8] = err1[n8] + eg * 0.3125f;
                int n9 = p + 2;
                err1[n9] = err1[n9] + eb * 0.3125f;
                int n10 = p + 3 + 0;
                err1[n10] = err1[n10] + er * 0.0625f;
                int n11 = p + 3 + 1;
                err1[n11] = err1[n11] + eg * 0.0625f;
                int n12 = p + 3 + 2;
                err1[n12] = err1[n12] + eb * 0.0625f;
                pix[x + y * this.width] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        return img;
    }

    public NImage bump(NImage normals, Vector3f light, NColor ambient, NColor diffuse, NColor specular, float power, float heightScale, boolean directional) {
        Vector3f l = new Vector3f();
        Vector3f n = new Vector3f();
        Vector3f h = new Vector3f();
        l.set(light);
        if (directional) {
            l.negate().normalize();
        }
        for (int y = 0; y < this.height; ++y) {
            float fz = (float)y / (float)this.height;
            for (int x = 0; x < this.width; ++x) {
                float fx = (float)x / (float)this.width;
                NColor color = this.getPixel(x, y);
                NColor norm = normals.getPixel(x, y);
                n.set(norm.r * 2.0f - 1.0f, norm.b * 2.0f - 1.0f, norm.g * 2.0f - 1.0f).normalize();
                float fy = norm.a * heightScale;
                if (!directional) {
                    l.set(light.x - fx, light.y - fy, light.z - fz).normalize();
                }
                NColor out = color.mulRGB(ambient);
                float d = Math.max(0.0f, n.dot(l));
                if (d > 0.0f) {
                    out = out.addRGB(diffuse.mulRGB(color), d);
                    if (power > 0.0f) {
                        h.set(light.x, light.y + 1.0f, light.z).normalize();
                        d = (float)Math.pow(Math.max(0.0f, n.dot(h)), power);
                        out = out.addRGB(specular, d);
                    }
                }
                this.pixels[x + y * this.width] = out;
            }
        }
        return this;
    }

    public NImage normals(float scale) {
        NColor[] pix = new NColor[this.width * this.height];
        float sx = scale * (float)this.width / 512.0f;
        float sy = scale * (float)this.height / 512.0f;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                float dx = 0.0f;
                float dy = 0.0f;
                for (int n = 0; n < 3; ++n) {
                    for (int i = 0; i < 3; ++i) {
                        float l = this.getPixel(x + i - 1, y + n - 1).luminance();
                        dx += l * SOBEL_X[i + n * 3];
                        dy += l * SOBEL_Y[i + n * 3];
                    }
                }
                float len = (float)Math.sqrt((dx *= sx) * dx + (dy *= sy) * dy + 1.0f);
                float dz = 1.0f / len;
                NColor c = this.getPixel(x, y);
                pix[x + y * this.width] = new NColor(NMath.saturate((dx /= len) * 0.5f + 0.5f), NMath.saturate((dy /= len) * 0.5f + 0.5f), NMath.saturate(dz * 0.5f + 0.5f), c.luminance());
            }
        }
        System.arraycopy(pix, 0, this.pixels, 0, pix.length);
        return this;
    }

    public NImage perlin(int seed, float scalex, float scaley, int octaves, float fallOff, float amp, NColor color0, NColor color1) {
        return this.runThreaded(new NImagePerlin(this, seed, scalex, scaley, octaves, fallOff, amp, color0, color1), 8);
    }

    public static final float distOnTorus(float[] a, float[] b) {
        float dx = Math.min(Math.abs(a[0] - b[0] + 1.0f) % 1.0f, Math.abs(a[0] - b[0] - 1.0f) % 1.0f);
        float dy = Math.min(Math.abs(a[1] - b[1] + 1.0f) % 1.0f, Math.abs(a[1] - b[1] - 1.0f) % 1.0f);
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public synchronized NImage runThreaded(Worker<NImagePBlock> worker, int blockSize) {
        if (this.processingThreads < 2) {
            NImagePBlock block = new NImagePBlock(0, 0, this.width, this.height);
            worker.run(block);
            System.arraycopy(block.pixels, 0, this.pixels, 0, this.pixels.length);
        } else {
            WorkerPool<NImagePBlock> pool = WorkerPool.start(this, this.processingThreads, 512, true);
            int wx = (this.width + blockSize - 1) / blockSize;
            int wy = (this.height + blockSize - 1) / blockSize;
            for (int y = 0; y < wy; ++y) {
                int ry = y * blockSize;
                int rh = Math.min(this.height - ry, blockSize);
                for (int x = 0; x < wx; ++x) {
                    int rx = x * blockSize;
                    int rw = Math.min(this.width - rx, blockSize);
                    pool.enqueue(worker, new NImagePBlock(rx, ry, rw, rh));
                }
            }
            pool.stop();
        }
        return this;
    }

    @Override
    public void workerCallback(WorkerPool<NImagePBlock> pool, WorkerStatus status, Worker<NImagePBlock> worker, NImagePBlock p) {
        for (int y = 0; y < p.h; ++y) {
            System.arraycopy(p.pixels, y * p.w, this.pixels, p.x + (y + p.y) * this.width, p.w);
        }
    }

    public NImage boxDownsample(int fx, int fy) {
        NImage ret = new NImage(this.width / fx, this.height / fy);
        ret.setThreadCount(this.processingThreads);
        return ret.runThreaded(new NImageBoxDownsampler(this, fx, fy), 8);
    }

    public NImage decimate(int fx, int fy) {
        NImage ret = new NImage(this.width / fx, this.height / fy);
        ret.setThreadCount(this.processingThreads);
        int fx2 = fx / 2;
        int fy2 = fy / 2;
        for (int y = 0; y < ret.height; ++y) {
            for (int x = 0; x < ret.width; ++x) {
                ret.setPixel(x, y, this.getPixel(x * fx + fx2, y * fy + fy2));
            }
        }
        return ret;
    }

    public NImage filter(FilterKernel kernel) {
        if (kernel.isSingle) {
            return this.runThreaded(new NImageFilter(new NImage(this), kernel, 0), 8);
        }
        this.runThreaded(new NImageFilter(this, kernel, 1), 8);
        return this.runThreaded(new NImageFilter(this, kernel, 2), 8);
    }

    public NImage combine(NImage other, ColorOp colorOp, int dx, int dy, int sx, int sy, int w, int h) {
        int tw = Math.min(Math.min(w, other.width - sx), this.width - dx);
        int th = Math.min(Math.min(h, other.height - sy), this.height - dy);
        ColorOp old = this.cop;
        this.cop = colorOp;
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                this.setPixel(dx + x, dy + y, other.getPixel(sx + x, sy + y));
            }
        }
        this.cop = old;
        return this;
    }

    public NImage combine(NImage other, int dx, int dy) {
        return this.combine(other, ColorOp.SET, dx, dy, 0, 0, other.width, other.height);
    }

    public NImage combine(NImage other) {
        return this.combine(other, ColorOp.SET, 0, 0, 0, 0, other.width, other.height);
    }

    public NImage combine(NImage other, ColorOp colorOp, int dx, int dy) {
        return this.combine(other, colorOp, dx, dy, 0, 0, other.width, other.height);
    }

    public NImage combine(NImage other, ColorOp colorOp) {
        return this.combine(other, colorOp, 0, 0, 0, 0, other.width, other.height);
    }

    public NImage voronoi(int seed, int max, float minDist, float fallOff, boolean invert, boolean colorCells, NColor color0, NColor color1) {
        return this.runThreaded(new NImageVoronoi(this, seed, max, minDist, fallOff, invert, colorCells, color0, color1), 8);
    }

    public NImage bricks(int seed, int bricksx, int bricksy, float jointsx, float jointsy, float singleProb, float rowOffset, float jointHardness, NColor color0, NColor color1, NColor colorJoints) {
        RNG rnd = RNGFactory.create(RNGType.LCG, seed);
        float[][] points = new float[bricksx + 1][2];
        int lastRow = -1;
        int count = 0;
        for (int y = 0; y < this.height; ++y) {
            float fy = (float)y / (float)this.height;
            int currentRow = (int)((float)bricksy * fy);
            float offset = (float)currentRow * rowOffset;
            if (currentRow > lastRow) {
                boolean single;
                lastRow = currentRow;
                count = 0;
                for (int x = 0; x < bricksx; x += single ? 1 : 2) {
                    float fx;
                    single = bricksx - x == 1 ? true : rnd.nextFloatUnipolar() < singleProb;
                    points[count][0] = fx = (float)x / (float)bricksx;
                    points[count][1] = rnd.nextFloatUnipolar();
                    ++count;
                }
                points[count][0] = 1.0f;
            }
            float y0 = (float)currentRow / (float)bricksy;
            float y1 = (float)(currentRow + 1) / (float)bricksy;
            for (int x = 0; x < this.width; ++x) {
                float fx = ((float)x / (float)this.width + offset) % 1.0f;
                int idx = count;
                while (fx < points[idx][0]) {
                    --idx;
                }
                float x0 = points[idx][0];
                float x1 = points[idx + 1][0];
                float dx0 = Math.min(Math.abs(fx - x0 + 1.0f) % 1.0f, Math.abs(fx - x0 - 1.0f) % 1.0f);
                float dx1 = Math.min(Math.abs(fx - x1 + 1.0f) % 1.0f, Math.abs(fx - x1 - 1.0f) % 1.0f);
                float dx = Math.min(dx0, dx1);
                float dy = Math.min(Math.abs(fy - y0), Math.abs(fy - y1));
                float jx = dx / jointsx;
                float jy = dy / jointsy;
                NColor col = color0.lerp(color1, points[idx][1]);
                if (jx < 1.0f | jy < 1.0f) {
                    col = col.lerp(colorJoints, (float)Math.pow(1.0 - (double)(NMath.saturate(jx) * NMath.saturate(jy)), jointHardness));
                }
                this.pixels[x + y * this.width] = col;
            }
        }
        return this;
    }

    public static void drawLine(int x0, int y0, int x1, int y1, List<NPoint> points) {
        int x = x0;
        int y = y0;
        int ys = 1;
        int xs = 1;
        int dx = x1 - x0;
        if (dx == 0) {
            xs = 0;
        } else if (dx < 0) {
            dx = -dx;
            xs = -xs;
        }
        int dy = y1 - y0;
        if (dy == 0) {
            ys = 0;
        } else if (dy < 0) {
            dy = -dy;
            ys = -ys;
        }
        int a = dx - dy;
        while (x != x1 || y != y1) {
            points.add(new NPoint(x, y));
            if (a >= 0) {
                x += xs;
                a -= dy;
            }
            if (a >= 0) continue;
            y += ys;
            a += dx;
        }
        points.add(new NPoint(x, y));
    }

    public void drawLine(int x0, int y0, int x1, int y1, NColor color) {
        int x = x0;
        int y = y0;
        int ys = 1;
        int xs = 1;
        int dx = x1 - x0;
        if (dx == 0) {
            xs = 0;
        } else if (dx < 0) {
            dx = -dx;
            xs = -xs;
        }
        int dy = y1 - y0;
        if (dy == 0) {
            ys = 0;
        } else if (dy < 0) {
            dy = -dy;
            ys = -ys;
        }
        int a = dx - dy;
        while (x != x1 || y != y1) {
            this.setPixel(x, y, color);
            if (a >= 0) {
                x += xs;
                a -= dy;
            }
            if (a >= 0) continue;
            y += ys;
            a += dx;
        }
        this.setPixel(x, y, color);
    }

    public void drawThickLine(int x0, int y0, int x1, int y1, int w, NColor color) {
        if (w < 2) {
            this.drawLine(x0, y0, x1, y1, color);
            return;
        }
        int dx = x1 - x0;
        int dy = y1 - y0;
        if (dx == 0) {
            if (y1 > y0) {
                this.fillRect(x0 - w, y0, w * 2 + 1, y1 - y0 + 1, color);
            } else {
                this.fillRect(x0 - w, y1, w * 2 + 1, y0 - y1 + 1, color);
            }
            return;
        }
        if (dy == 0) {
            if (x1 > x0) {
                this.fillRect(x0, y0 - w, x1 - x0 + 1, w * 2 + 1, color);
            } else {
                this.fillRect(x1, y0 - w, x0 - x1 + 1, w * 2 + 1, color);
            }
            return;
        }
        double len = Math.sqrt(dx * dx + dy * dy);
        double vx = (double)dx / len;
        double vy = (double)dy / len;
        NPoint[] points = new NPoint[]{new NPoint((int)((double)x0 - vy * (double)w), (int)((double)y0 + vx * (double)w)), new NPoint((int)((double)x0 + vy * (double)w), (int)((double)y0 - vx * (double)w)), new NPoint((int)((double)x1 + vy * (double)w), (int)((double)y1 - vx * (double)w)), new NPoint((int)((double)x1 - vy * (double)w), (int)((double)y1 + vx * (double)w))};
        this.fillPolygon(points, color);
    }

    public void drawHLine(int x, int y, int w, NColor color) {
        if (w < 2) {
            this.setPixel(x, y, color);
            return;
        }
        for (int i = x; i < x + w; ++i) {
            this.setPixel(i, y, color);
        }
    }

    public void drawVLine(int x, int y, int h, NColor color) {
        if (h < 2) {
            this.setPixel(x, y, color);
            return;
        }
        for (int i = y; i < y + h; ++i) {
            this.setPixel(x, i, color);
        }
    }

    public void drawRect(int x, int y, int w, int h, NColor color) {
        this.drawHLine(x, y, w, color);
        this.drawVLine(x, y, h, color);
        this.drawHLine(x, y + h - 1, w, color);
        this.drawVLine(x + w - 1, y, h, color);
    }

    public void fillRect(int x, int y, int w, int h, NColor color) {
        for (int i = y; i < y + h; ++i) {
            this.drawHLine(x, i, w, color);
        }
    }

    public void drawPolygon(NPoint[] points, NColor color) {
        for (int i = 0; i < points.length - 1; ++i) {
            this.drawLine(points[i].x, points[i].y, points[i + 1].x, points[i + 1].y, color);
        }
        if (!points[0].equals(points[points.length - 1])) {
            this.drawLine(points[points.length - 1].x, points[points.length - 1].y, points[0].x, points[0].y, color);
        }
    }

    public void drawPolygon(List<NPoint> points, NColor color) {
        for (int i = 0; i < points.size() - 1; ++i) {
            this.drawLine(points.get((int)i).x, points.get((int)i).y, points.get((int)(i + 1)).x, points.get((int)(i + 1)).y, color);
        }
        if (!Colls.head(points).equals(Colls.last(points))) {
            this.drawLine(Colls.last(points).x, Colls.last(points).y, Colls.head(points).x, Colls.head(points).y, color);
        }
    }

    private void _fillPolygon(List<NPoint> dpoints, NColor color) {
        Colls.sort(dpoints);
        int i = 0;
        int oy = dpoints.get((int)i).y;
        while (i < dpoints.size()) {
            int sx = dpoints.get((int)i).x;
            int ex = 0;
            while (i < dpoints.size() && dpoints.get((int)i).y == oy) {
                ex = dpoints.get((int)i++).x;
            }
            this.drawHLine(sx, oy, ex - sx + 1, color);
            if (i >= dpoints.size()) continue;
            oy = dpoints.get((int)i).y;
        }
    }

    public void fillPolygon(NPoint[] points, NColor color) {
        List<NPoint> dpoints = Colls.list();
        for (int i = 0; i < points.length - 1; ++i) {
            NImage.drawLine(points[i].x, points[i].y, points[i + 1].x, points[i + 1].y, dpoints);
        }
        if (!points[0].equals(points[points.length - 1])) {
            NImage.drawLine(points[points.length - 1].x, points[points.length - 1].y, points[0].x, points[0].y, dpoints);
        }
        this._fillPolygon(dpoints, color);
    }

    public void fillPolygon(List<NPoint> points, NColor color) {
        List<NPoint> dpoints = Colls.list();
        for (int i = 0; i < points.size() - 1; ++i) {
            NImage.drawLine(points.get((int)i).x, points.get((int)i).y, points.get((int)(i + 1)).x, points.get((int)(i + 1)).y, dpoints);
        }
        if (!Colls.head(points).equals(Colls.last(points))) {
            NImage.drawLine(Colls.last(points).x, Colls.last(points).y, Colls.head(points).x, Colls.head(points).y, dpoints);
        }
        this._fillPolygon(dpoints, color);
    }

    public void drawCircle(int x, int y, int radius, NColor color) {
        if (radius < 2) {
            this.setPixel(x, y, color);
            return;
        }
        int cy = radius;
        int cx = 0;
        while (cy >= 0 || cx < radius) {
            double err = 10.0;
            int nx = cx;
            int ny = cy;
            this.setPixel(x + cx, y + cy, color);
            this.setPixel(x - cx, y + cy, color);
            this.setPixel(x + cx, y - cy, color);
            this.setPixel(x - cx, y - cy, color);
            for (int i = 0; i < 3; ++i) {
                int tx = cx + PAINT_DX[i];
                int ty = cy + PAINT_DY[i];
                double d = Math.abs((double)radius - Math.sqrt(tx * tx + ty * ty));
                if (!(d <= err)) continue;
                err = d;
                nx = tx;
                ny = ty;
            }
            cx = nx;
            cy = ny;
        }
    }

    public void fillCircle(int x, int y, int radius, NColor color) {
        if (radius < 2) {
            this.setPixel(x, y, color);
            return;
        }
        int cy = radius;
        int cx = 0;
        while (cy >= 0 || cx < radius) {
            double err = 10.0;
            int nx = cx;
            int ny = cy;
            this.drawHLine(x - cx, y - cy, cx * 2 + 1, color);
            this.drawHLine(x - cx, y + cy, cx * 2 + 1, color);
            for (int i = 0; i < 3; ++i) {
                int tx = cx + PAINT_DX[i];
                int ty = cy + PAINT_DY[i];
                double d = Math.abs((double)radius - Math.sqrt(tx * tx + ty * ty));
                if (!(d <= err)) continue;
                err = d;
                nx = tx;
                ny = ty;
            }
            cx = nx;
            cy = ny;
        }
    }

    public void drawEllipse(int x, int y, int a, int b, NColor color) {
        if (a < 2 && b < 2) {
            this.setPixel(x, y, color);
            return;
        }
        if (a < 2) {
            this.drawVLine(x, y - b, b * 2 + 1, color);
            return;
        }
        if (b < 2) {
            this.drawHLine(x - a, y, a * 2 + 1, color);
            return;
        }
        int cy = b;
        int cx = 0;
        double a2 = 1.0 / (double)(a * a);
        double b2 = 1.0 / (double)(b * b);
        while (cy >= 0 || cx < a) {
            double err = 10.0;
            int nx = cx;
            int ny = cy;
            this.setPixel(x + cx, y + cy, color);
            this.setPixel(x - cx, y + cy, color);
            this.setPixel(x + cx, y - cy, color);
            this.setPixel(x - cx, y - cy, color);
            for (int i = 0; i < 3; ++i) {
                int tx = cx + PAINT_DX[i];
                int ty = cy + PAINT_DY[i];
                double d = Math.abs(1.0 - Math.sqrt((double)(tx * tx) * a2 + (double)(ty * ty) * b2));
                if (!(d <= err)) continue;
                err = d;
                nx = tx;
                ny = ty;
            }
            cx = nx;
            cy = ny;
        }
    }

    public void fillEllipse(int x, int y, int a, int b, NColor color) {
        if (a < 2 && b < 2) {
            this.setPixel(x, y, color);
            return;
        }
        if (a < 2) {
            this.drawVLine(x, y - b, b * 2 + 1, color);
            return;
        }
        if (b < 2) {
            this.drawHLine(x - a, y, a * 2 + 1, color);
            return;
        }
        int cy = b;
        int cx = 0;
        double a2 = 1.0 / (double)(a * a);
        double b2 = 1.0 / (double)(b * b);
        while (cy >= 0 || cx < a) {
            double err = 10.0;
            int nx = cx;
            int ny = cy;
            this.drawHLine(x - cx, y - cy, cx * 2 + 1, color);
            this.drawHLine(x - cx, y + cy, cx * 2 + 1, color);
            for (int i = 0; i < 3; ++i) {
                int tx = cx + PAINT_DX[i];
                int ty = cy + PAINT_DY[i];
                double d = Math.abs(1.0 - Math.sqrt((double)(tx * tx) * a2 + (double)(ty * ty) * b2));
                if (!(d <= err)) continue;
                err = d;
                nx = tx;
                ny = ty;
            }
            cx = nx;
            cy = ny;
        }
    }

    public void drawArc(int x, int y, int radius, double start, double end, NColor color) {
        double rs;
        double invRad = 57.29577951308232;
        int cy = radius;
        int cx = 0;
        double re = end;
        for (rs = start; rs < 0.0; rs += 360.0) {
        }
        while (rs >= 360.0) {
            rs -= 360.0;
        }
        while (re < 0.0) {
            re += 360.0;
        }
        while (re >= 360.0) {
            re -= 360.0;
        }
        while (cy >= 0 || cx < radius) {
            double wi;
            double err = 10.0;
            int nx = cx;
            int ny = cy;
            double wi0 = 90.0 - Math.asin((double)cy / Math.sqrt(cx * cx + cy * cy)) * 57.29577951308232;
            if (rs > re) {
                if (wi0 >= rs || wi0 <= re) {
                    this.setPixel(x + cx, y - cy, color);
                }
                if ((wi = 180.0 - wi0) >= rs || wi <= re) {
                    this.setPixel(x + cx, y + cy, color);
                }
                if ((wi = 180.0 + wi0) >= rs || wi <= re) {
                    this.setPixel(x - cx, y + cy, color);
                }
                if ((wi = 360.0 - wi0) >= rs || wi <= re) {
                    this.setPixel(x - cx, y - cy, color);
                }
            } else {
                if (wi0 >= rs && wi0 <= re) {
                    this.setPixel(x + cx, y - cy, color);
                }
                if ((wi = 180.0 - wi0) >= rs && wi <= re) {
                    this.setPixel(x + cx, y + cy, color);
                }
                if ((wi = 180.0 + wi0) >= rs && wi <= re) {
                    this.setPixel(x - cx, y + cy, color);
                }
                if ((wi = 360.0 - wi0) >= rs && wi <= re) {
                    this.setPixel(x - cx, y - cy, color);
                }
            }
            for (int i = 0; i < 3; ++i) {
                int tx = cx + PAINT_DX[i];
                int ty = cy + PAINT_DY[i];
                double d = Math.abs((double)radius - Math.sqrt(tx * tx + ty * ty));
                if (!(d <= err)) continue;
                err = d;
                nx = tx;
                ny = ty;
            }
            cx = nx;
            cy = ny;
        }
    }

    private void fillArcHLine(int sx, int sy, int cx, int cy, double rs, double re, NColor color) {
        double invRad = 57.29577951308232;
        double cy2 = Math.abs(cy);
        for (int x = -cx; x <= cx; ++x) {
            double r = Math.sqrt(x * x + cy * cy);
            if (r == 0.0) {
                this.setPixel(sx, sy, color);
                continue;
            }
            double wi = 0.0;
            if (x == 0 && cy < 0) {
                wi = 0.0;
            } else if (x == 0 && cy > 0) {
                wi = 180.0;
            } else if (cy == 0 && x > 0) {
                wi = 90.0;
            } else if (cy == 0 && x < 0) {
                wi = 270.0;
            } else {
                wi = 90.0 - Math.asin(cy2 / r) * 57.29577951308232;
                if (cy > 0 && x > 0) {
                    wi = 180.0 - wi;
                } else if (cy < 0 && x < 0) {
                    wi = 360.0 - wi;
                } else if (cy > 0 && x < 0) {
                    wi = 180.0 + wi;
                }
            }
            if (rs > re) {
                if (!(wi >= rs) && !(wi <= re)) continue;
                this.setPixel(sx + x, sy + cy, color);
                continue;
            }
            if (!(wi >= rs) || !(wi <= re)) continue;
            this.setPixel(sx + x, sy + cy, color);
        }
    }

    public void fillArc(int x, int y, int radius, double start, double end, NColor color) {
        double rs;
        int cy = radius;
        int cx = 0;
        double re = end;
        for (rs = start; rs < 0.0; rs += 360.0) {
        }
        while (rs >= 360.0) {
            rs -= 360.0;
        }
        while (re < 0.0) {
            re += 360.0;
        }
        while (re >= 360.0) {
            re -= 360.0;
        }
        while (cy >= 0 || cx < radius) {
            double err = 10.0;
            int nx = cx;
            int ny = cy;
            this.fillArcHLine(x, y, cx, -cy, rs, re, color);
            this.fillArcHLine(x, y, cx, cy, rs, re, color);
            for (int i = 0; i < 3; ++i) {
                int tx = cx + PAINT_DX[i];
                int ty = cy + PAINT_DY[i];
                double d = Math.abs((double)radius - Math.sqrt(tx * tx + ty * ty));
                if (!(d <= err)) continue;
                err = d;
                nx = tx;
                ny = ty;
            }
            cx = nx;
            cy = ny;
        }
    }

    public void drawRoundRect(int x, int y, int w, int h, int arcsz, NColor color) {
        this.drawRoundRect(x, y, w, h, arcsz, arcsz, color);
    }

    public void fillRoundRect(int x, int y, int w, int h, int arcsz, NColor color) {
        this.fillRoundRect(x, y, w, h, arcsz, arcsz, color);
    }

    public void drawRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight, NColor color) {
        int x0 = x + arcWidth;
        int y0 = y + arcHeight;
        int x1 = x + w - arcWidth - 1;
        int y1 = y + h - arcHeight - 1;
        int w2 = w - arcWidth * 2;
        int h2 = h - arcHeight * 2;
        if (w2 < 0 || h2 < 0) {
            this.drawRect(x, y, w, h, color);
            return;
        }
        this.drawHLine(x0, y, w2, color);
        this.drawHLine(x0, y + h - 1, w2, color);
        this.drawVLine(x, y0, h2, color);
        this.drawVLine(x + w - 1, y0, h2, color);
        int cy = arcHeight;
        int cx = 0;
        double a2 = 1.0 / (double)(arcWidth * arcWidth);
        double b2 = 1.0 / (double)(arcHeight * arcHeight);
        while (cy >= 0 || cx < arcWidth) {
            double err = 10.0;
            int nx = cx;
            int ny = cy;
            this.setPixel(x1 + cx, y1 + cy, color);
            this.setPixel(x0 - cx, y1 + cy, color);
            this.setPixel(x1 + cx, y0 - cy, color);
            this.setPixel(x0 - cx, y0 - cy, color);
            for (int i = 0; i < 3; ++i) {
                int tx = cx + PAINT_DX[i];
                int ty = cy + PAINT_DY[i];
                double d = Math.abs(1.0 - Math.sqrt((double)(tx * tx) * a2 + (double)(ty * ty) * b2));
                if (!(d <= err)) continue;
                err = d;
                nx = tx;
                ny = ty;
            }
            cx = nx;
            cy = ny;
        }
    }

    public void fillRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight, NColor color) {
        int x0 = x + arcWidth;
        int y0 = y + arcHeight;
        int y1 = y + h - arcHeight - 1;
        int w2 = w - arcWidth * 2;
        int h2 = h - arcHeight * 2;
        if (w2 < 0 || h2 < 0) {
            this.fillRect(x, y, w, h, color);
            return;
        }
        for (int i = 0; i < h2; ++i) {
            this.drawHLine(x, y0 + i, w, color);
        }
        int cy = arcHeight;
        int cx = 0;
        double a2 = 1.0 / (double)(arcWidth * arcWidth);
        double b2 = 1.0 / (double)(arcHeight * arcHeight);
        while (cy >= 0 || cx < arcWidth) {
            double err = 10.0;
            int nx = cx;
            int ny = cy;
            this.drawHLine(x0 - cx, y0 - cy, cx * 2 + w2, color);
            this.drawHLine(x0 - cx, y1 + cy, cx * 2 + w2, color);
            for (int i = 0; i < 3; ++i) {
                int tx = cx + PAINT_DX[i];
                int ty = cy + PAINT_DY[i];
                double d = Math.abs(1.0 - Math.sqrt((double)(tx * tx) * a2 + (double)(ty * ty) * b2));
                if (!(d <= err)) continue;
                err = d;
                nx = tx;
                ny = ty;
            }
            cx = nx;
            cy = ny;
        }
    }

    public static class NPoint
    implements Comparable<NPoint> {
        public final int x;
        public final int y;

        public NPoint(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int hashCode() {
            return this.x * 31 + this.y;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NPoint)) {
                return false;
            }
            NPoint point = (NPoint)obj;
            return this.x == point.x && this.y == point.y;
        }

        @Override
        public int compareTo(NPoint o) {
            if (this.y == o.y) {
                return this.x - o.x;
            }
            return this.y - o.y;
        }
    }
}

