/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import com.github.rjeschke.neetutils.concurrent.Worker;
import com.github.rjeschke.neetutils.graphics.NColor;
import com.github.rjeschke.neetutils.graphics.NImage;
import com.github.rjeschke.neetutils.graphics.NImagePBlock;
import com.github.rjeschke.neetutils.math.NMath;
import com.github.rjeschke.neetutils.rng.RNG;
import com.github.rjeschke.neetutils.rng.RNGFactory;
import com.github.rjeschke.neetutils.rng.RNGType;
import java.util.Arrays;

class NImagePerlin
implements Worker<NImagePBlock> {
    final NImage image;
    final int[] perm = new int[256];
    final float[] gradx = new float[256];
    final float[] grady = new float[256];
    final float scalex;
    final float scaley;
    final int octaves;
    final float fallOff;
    final float amp;
    final NColor color0;
    final NColor color1;

    NImagePerlin(NImage image, int seed, float scalex, float scaley, int octaves, float fallOff, float amp, NColor color0, NColor color1) {
        this.image = image;
        this.scalex = scalex;
        this.scaley = scaley;
        this.octaves = octaves;
        this.fallOff = fallOff;
        this.amp = amp;
        this.color0 = color0;
        this.color1 = color1;
        RNG rnd = RNGFactory.create(RNGType.LCG, seed);
        Arrays.fill(this.perm, -1);
        for (int i = 0; i < 256; ++i) {
            float y;
            int p = rnd.nextInt() >>> 24;
            while (this.perm[p] != -1) {
                p = rnd.nextInt() >>> 24;
            }
            this.perm[p] = i;
            float x = rnd.nextFloatUnipolar() * 2.0f - 1.0f;
            float len = (float)Math.sqrt(x * x + (y = rnd.nextFloatUnipolar() * 2.0f - 1.0f) * y);
            this.gradx[i] = len > 0.0f ? x / len : x;
            this.grady[i] = len > 0.0f ? y / len : y;
        }
    }

    private static float s_curve(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    @Override
    public void run(NImagePBlock p) {
        for (int y = 0; y < p.h; ++y) {
            float fy = (float)(p.y + y) / (float)this.image.height;
            for (int x = 0; x < p.w; ++x) {
                float fx = (float)(p.x + x) / (float)this.image.width;
                float tx = fx * this.scalex;
                float ty = fy * this.scaley;
                float noise = 0.0f;
                float am = this.amp;
                for (int oct = 0; oct < this.octaves; ++oct) {
                    float px0 = tx * 256.0f;
                    int ix = (int)px0;
                    float px1 = (px0 -= (float)ix) - 1.0f;
                    float py0 = ty * 256.0f;
                    int iy = (int)py0;
                    float py1 = (py0 -= (float)iy) - 1.0f;
                    int p00 = this.perm[ix + this.perm[iy & 0xFF] & 0xFF];
                    int p10 = this.perm[ix + 1 + this.perm[iy & 0xFF] & 0xFF];
                    int p01 = this.perm[ix + this.perm[iy + 1 & 0xFF] & 0xFF];
                    int p11 = this.perm[ix + 1 + this.perm[iy + 1 & 0xFF] & 0xFF];
                    float fsx = NImagePerlin.s_curve(px0);
                    float fsy = NImagePerlin.s_curve(py0);
                    float u = px0 * this.gradx[p00] + py0 * this.grady[p00];
                    float v = px1 * this.gradx[p10] + py0 * this.grady[p10];
                    float a = NMath.lerp(u, v, fsx);
                    u = px0 * this.gradx[p01] + py1 * this.grady[p01];
                    v = px1 * this.gradx[p11] + py1 * this.grady[p11];
                    float b = NMath.lerp(u, v, fsx);
                    noise += NMath.lerp(a, b, fsy) * am;
                    am *= this.fallOff;
                    tx = (float)((double)tx * 2.0);
                    ty = (float)((double)ty * 2.0);
                }
                p.pixels[x + y * p.w] = this.color0.lerp(this.color1, NMath.saturate(noise * 0.5f + 0.5f));
            }
        }
    }
}

