/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.graphics;

import com.github.rjeschke.neetutils.concurrent.Worker;
import com.github.rjeschke.neetutils.graphics.NColor;
import com.github.rjeschke.neetutils.graphics.NImage;
import com.github.rjeschke.neetutils.graphics.NImagePBlock;
import com.github.rjeschke.neetutils.math.NMath;
import com.github.rjeschke.neetutils.rng.RNG;
import com.github.rjeschke.neetutils.rng.RNGFactory;
import com.github.rjeschke.neetutils.rng.RNGType;

class NImageVoronoi
implements Worker<NImagePBlock> {
    final NImage image;
    final float[][] points;
    final int pointCount;
    final float fallOff;
    final boolean invert;
    final boolean colorCells;
    final NColor color0;
    final NColor color1;

    NImageVoronoi(NImage image, int seed, int max, float minDist, float fallOff, boolean invert, boolean colorCells, NColor color0, NColor color1) {
        this.image = image;
        this.fallOff = fallOff;
        this.invert = invert;
        this.color0 = color0;
        this.color1 = color1;
        this.colorCells = colorCells;
        RNG rnd = RNGFactory.create(RNGType.LCG, seed);
        int todo = Math.min(max, (int)(1.0 / (double)(minDist * minDist)));
        this.points = new float[todo][3];
        int count = 0;
        while (count < todo) {
            int i;
            float[] point = new float[3];
            for (i = 0; i < 500; ++i) {
                point[0] = rnd.nextFloatUnipolar();
                point[1] = rnd.nextFloatUnipolar();
                boolean ok = true;
                for (int n = 0; n < count; ++n) {
                    if (!(NImage.distOnTorus(point, this.points[n]) < minDist)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                point[2] = rnd.nextFloatUnipolar();
                this.points[count++] = point;
                break;
            }
            if (i < 500) continue;
            break;
        }
        this.pointCount = count;
    }

    @Override
    public void run(NImagePBlock p) {
        for (int y = 0; y < p.h; ++y) {
            float[] point = new float[2];
            point[1] = (float)(p.y + y) / (float)this.image.height;
            for (int x = 0; x < p.w; ++x) {
                point[0] = (float)(p.x + x) / (float)this.image.width;
                float d0 = Float.MAX_VALUE;
                float d1 = Float.MAX_VALUE;
                float c = 0.0f;
                for (int i = 0; i < this.pointCount; ++i) {
                    float d = NImage.distOnTorus(point, this.points[i]);
                    if (d < d0) {
                        d1 = d0;
                        d0 = d;
                        c = this.points[i][2];
                        continue;
                    }
                    if (!(d < d1)) continue;
                    d1 = d;
                }
                float z = 1.0f;
                if (this.fallOff > 0.0f) {
                    z = NMath.saturate(d0 / d1);
                    z = (float)Math.pow(this.invert ? 1.0 - (double)z : (double)z, this.fallOff);
                }
                if (this.colorCells) {
                    z *= c;
                }
                p.pixels[x + y * p.w] = this.color0.lerp(this.color1, z);
            }
        }
    }
}

