/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.SynchronousQueue;

public abstract class Generator<A>
implements Iterable<A> {
    final ThreadLocal<GeneratorIterator<A>> generatorIterator = new ThreadLocal();

    protected final void yield(A element) {
        this.generatorIterator.get().push(element);
    }

    public abstract void generate();

    @Override
    public final Iterator<A> iterator() {
        GeneratorIterator gi = new GeneratorIterator(this);
        Thread thread = new Thread(gi);
        thread.setDaemon(true);
        thread.start();
        return gi;
    }

    private static final class GeneratorIterator<A>
    implements Iterator<A>,
    Runnable {
        private final SynchronousQueue<State<A>> queue = new SynchronousQueue();
        private final Generator<A> generator;
        private State<A> state;

        public GeneratorIterator(Generator<A> generator) {
            this.generator = generator;
        }

        public void push(A element) {
            try {
                this.queue.put(new State<A>(element, true));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void close() {
            try {
                this.queue.put(new State<Object>(null, false));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public boolean hasNext() {
            try {
                this.state = this.queue.take();
            }
            catch (InterruptedException e) {
                return false;
            }
            return this.state.hasNext;
        }

        @Override
        public A next() {
            if (!this.state.hasNext) {
                throw new NoSuchElementException();
            }
            return this.state.element;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Generators are read-only.");
        }

        @Override
        public void run() {
            this.generator.generatorIterator.set(this);
            this.generator.generate();
            this.close();
        }

        private static final class State<A> {
            public final A element;
            public final boolean hasNext;

            public State(A element, boolean hasNext) {
                this.element = element;
                this.hasNext = hasNext;
            }
        }
    }
}

