/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.fn.FnMapping;
import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.util.Iterator;

class XIterableMap<A, B>
extends AbstractXIterable<B> {
    private final Iterable<? extends A> iterable;
    private final FnMapping<A, B> mapping;

    public XIterableMap(Iterable<? extends A> iterable, FnMapping<A, B> mapping) {
        this.iterable = iterable;
        this.mapping = mapping;
    }

    @Override
    public Iterator<B> iterator() {
        return new XIterator<A, B>(this.iterable.iterator(), this.mapping);
    }

    private static final class XIterator<A, B>
    implements Iterator<B> {
        private final Iterator<? extends A> iterator;
        private final FnMapping<A, B> mapping;

        public XIterator(Iterator<? extends A> iterator, FnMapping<A, B> mapping) {
            this.iterator = iterator;
            this.mapping = mapping;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public B next() {
            return this.mapping.applyMapping(this.iterator.next());
        }

        @Override
        public void remove() {
            throw new IllegalStateException("XIterators are read-only.");
        }
    }
}

