/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.fn.FnFoldStep;
import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.util.Iterator;

class XIterableReductions<A, B>
extends AbstractXIterable<B> {
    private final Iterable<A> iterable;
    private final FnFoldStep<? super A, ? super B> foldStep;
    private final B initialValue;

    public XIterableReductions(Iterable<A> iterable, FnFoldStep<? super A, ? super B> foldStep, B initialValue) {
        this.iterable = iterable;
        this.foldStep = foldStep;
        this.initialValue = initialValue;
    }

    @Override
    public Iterator<B> iterator() {
        return new XIterator<A, B>(this.iterable.iterator(), this.foldStep, this.initialValue);
    }

    private static final class XIterator<A, B>
    implements Iterator<B> {
        private final Iterator<A> iterator;
        private final FnFoldStep<? super A, ? super B> foldStep;
        private B initialValue;
        private boolean isInitialValue = true;

        public XIterator(Iterator<A> iterator, FnFoldStep<? super A, ? super B> foldStep, B initialValue) {
            this.iterator = iterator;
            this.foldStep = foldStep;
            this.initialValue = initialValue;
        }

        @Override
        public boolean hasNext() {
            return this.isInitialValue || this.iterator.hasNext();
        }

        @Override
        public B next() {
            if (this.isInitialValue) {
                this.isInitialValue = false;
                return this.initialValue;
            }
            this.initialValue = this.foldStep.applyFoldStep(this.iterator.next(), this.initialValue);
            return this.initialValue;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("XIterators are read-only.");
        }
    }
}

