/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.iterables;

import com.github.rjeschke.neetutils.fn.FnFoldStep;
import com.github.rjeschke.neetutils.iterables.AbstractXIterable;
import java.util.Iterator;

class XIterableReductions2<A>
extends AbstractXIterable<A> {
    private final Iterable<? extends A> iterable;
    private final FnFoldStep<? super A, ? super A> foldStep;

    public XIterableReductions2(Iterable<? extends A> iterable, FnFoldStep<? super A, ? super A> foldStep) {
        this.iterable = iterable;
        this.foldStep = foldStep;
    }

    @Override
    public Iterator<A> iterator() {
        return new XIterator<A>(this.iterable.iterator(), this.foldStep);
    }

    private static final class XIterator<A>
    implements Iterator<A> {
        private final Iterator<? extends A> iterator;
        private final FnFoldStep<? super A, ? super A> foldStep;
        private A initialValue;
        private boolean isInitialValue = true;

        public XIterator(Iterator<? extends A> iterator, FnFoldStep<? super A, ? super A> foldStep) {
            this.iterator = iterator;
            this.foldStep = foldStep;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public A next() {
            if (this.isInitialValue) {
                this.isInitialValue = false;
                this.initialValue = this.iterator.next();
            } else {
                this.initialValue = this.foldStep.applyFoldStep(this.iterator.next(), this.initialValue);
            }
            return this.initialValue;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("XIterators are read-only.");
        }
    }
}

