/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.lists;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.RandomAccess;

public class DoubleList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5782630412309485957L;
    private static final transient int INIT_SIZE = 16;
    private transient double[] data;
    private int size;
    private transient int maxSize;

    public DoubleList() {
        this(16);
    }

    public DoubleList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must not be less than 0");
        }
        this.maxSize = initialCapacity;
        this.size = 0;
        this.data = new double[initialCapacity];
    }

    public static DoubleList fromArray(double ... values) {
        DoubleList list = new DoubleList(values.length);
        System.arraycopy(values, 0, list.data, 0, values.length);
        list.size = values.length;
        return list;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.maxSize > this.size) {
            this.maxSize = this.size;
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    public double add(double v) {
        this.grow(this.size + 1);
        double d = v;
        this.data[this.size++] = d;
        return d;
    }

    public double add(int index, double v) {
        if (index == this.size) {
            return this.add(v);
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.grow(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = v;
        ++this.size;
        return v;
    }

    public double remove(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        double old = this.data[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        return old;
    }

    public double set(int index, double v) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.data[index] = v;
        return this.data[index];
    }

    public double get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public double[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public boolean contains(double v) {
        return this.indexOf(v) != -1;
    }

    public int indexOf(double v) {
        for (int i = 0; i < this.size; ++i) {
            if (v != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double v) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (v != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (this.size > 0) {
            sb.append(this.data[0]);
            for (int i = 1; i < this.size; ++i) {
                sb.append(',');
                sb.append(this.data[i]);
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.size; ++i) {
            long h = Double.doubleToLongBits(this.data[i]);
            hash = (hash * 31 + (int)(h >>> 32)) * 31 + (int)h;
        }
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DoubleList)) {
            return false;
        }
        DoubleList list = (DoubleList)other;
        if (list.size != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == list.data[i]) continue;
            return false;
        }
        return true;
    }

    public DoubleList clone() {
        DoubleList list = new DoubleList(this.size);
        list.size = this.size;
        System.arraycopy(this.data, 0, list.data, 0, this.size);
        return list;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            out.writeDouble(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.maxSize = this.size;
        this.data = new double[this.maxSize];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = in.readDouble();
        }
    }

    private void grow(int required) {
        if (required > this.maxSize) {
            this.maxSize = (this.maxSize * 3 >>> 1) + 1;
            this.data = Arrays.copyOf(this.data, this.maxSize);
        }
    }
}

