/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.vectors;

import com.github.rjeschke.neetutils.vectors.Matrix4x4f;
import com.github.rjeschke.neetutils.vectors.Vector3d;
import com.github.rjeschke.neetutils.vectors.Vector3f;

public final class Math3D {
    private Math3D() {
    }

    public static final float radians(float x) {
        return (float)Math.PI / 180 * x;
    }

    public static final float radians(double x) {
        return (float)(x * Math.PI / 180.0);
    }

    public static final float degrees(float x) {
        return 57.29578f * x;
    }

    public static final float sin(float x) {
        return (float)Math.sin(x);
    }

    public static final float cos(float x) {
        return (float)Math.cos(x);
    }

    public static final float tan(float x) {
        return (float)Math.tan(x);
    }

    public static final float asin(float x) {
        return (float)Math.asin(x);
    }

    public static final float acos(float x) {
        return (float)Math.acos(x);
    }

    public static final float atan(float x) {
        return (float)Math.atan(x);
    }

    public static final float atan(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static final float pow(float x, float y) {
        return (float)Math.pow(x, y);
    }

    public static final float exp(float x) {
        return (float)Math.exp(x);
    }

    public static final float log(float x) {
        return (float)Math.log(x);
    }

    public static final float exp2(float x) {
        return (float)Math.pow(2.0, x);
    }

    public static final float log2(float x) {
        return (float)(Math.log(x) / Math.log(2.0));
    }

    public static final float sqrt(float x) {
        return (float)Math.sqrt(x);
    }

    public static final float inversesqrt(float x) {
        return (float)(1.0 / Math.sqrt(x));
    }

    public static final float abs(float x) {
        return Math.abs(x);
    }

    public static final float sign(float x) {
        return x < 0.0f ? -1.0f : (x > 0.0f ? 1.0f : 0.0f);
    }

    public static final float floor(float x) {
        return (float)Math.floor(x);
    }

    public static final float ceil(float x) {
        return (float)Math.ceil(x);
    }

    public static final float mod(float x, float y) {
        return (float)((double)x - (double)y * Math.floor(x / y));
    }

    public static final Vector3f reflect(Vector3f i, Vector3f n) {
        return i.clone().sub(n, 2.0f * n.dot(i));
    }

    public static final Vector3d reflect(Vector3d i, Vector3d n) {
        return i.clone().sub(n, 2.0 * n.dot(i));
    }

    public static final Vector3f refract(Vector3f i, Vector3f n, float eta) {
        float d = n.dot(i);
        float k = 1.0f - eta * eta * (1.0f - d * d);
        if (k < 0.0f) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return i.clone().scale(eta).sub(n, eta * d + Math3D.sqrt(k));
    }

    public static final Vector3d refract(Vector3d i, Vector3d n, double eta) {
        double d = n.dot(i);
        double k = 1.0 - eta * eta * (1.0 - d * d);
        if (k < 0.0) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        return i.clone().scale(eta).sub(n, eta * d + Math.sqrt(k));
    }

    public static final Matrix4x4f matrixLookAtLH(Vector3f pos, Vector3f lookat, Vector3f up) {
        float[] ret = new float[16];
        Vector3f zaxis = lookat.clone().sub(pos).normalize();
        Vector3f xaxis = up.clone().cross(zaxis).normalize();
        Vector3f yaxis = zaxis.clone().cross(xaxis).normalize();
        ret[0] = xaxis.x;
        ret[4] = xaxis.y;
        ret[8] = xaxis.z;
        ret[12] = -xaxis.dot(pos);
        ret[1] = yaxis.x;
        ret[5] = yaxis.y;
        ret[9] = yaxis.z;
        ret[13] = -yaxis.dot(pos);
        ret[2] = zaxis.x;
        ret[6] = zaxis.y;
        ret[10] = zaxis.z;
        ret[14] = -zaxis.dot(pos);
        ret[15] = 1.0f;
        return new Matrix4x4f(ret);
    }

    public static final Matrix4x4f matrixLookAtRH(Vector3f pos, Vector3f lookat, Vector3f up) {
        float[] ret = new float[16];
        Vector3f zaxis = pos.clone().sub(lookat).normalize();
        Vector3f xaxis = up.clone().cross(zaxis).normalize();
        Vector3f yaxis = zaxis.clone().cross(xaxis);
        ret[0] = xaxis.x;
        ret[4] = xaxis.y;
        ret[8] = xaxis.z;
        ret[12] = -xaxis.dot(pos);
        ret[1] = yaxis.x;
        ret[5] = yaxis.y;
        ret[9] = yaxis.z;
        ret[13] = -yaxis.dot(pos);
        ret[2] = zaxis.x;
        ret[6] = zaxis.y;
        ret[10] = zaxis.z;
        ret[14] = -zaxis.dot(pos);
        ret[15] = 1.0f;
        return new Matrix4x4f(ret);
    }

    public static final Matrix4x4f matrixProjectionLH(float fov, float aspect, float near_z, float far_z) {
        float xscale;
        float[] ret = new float[16];
        float yscale = 1.0f / (float)Math.tan(fov * 0.5f);
        float t = 1.0f / (far_z - near_z);
        ret[0] = xscale = yscale / aspect;
        ret[5] = yscale;
        ret[10] = far_z * t;
        ret[14] = -near_z * far_z * t;
        ret[11] = 1.0f;
        return new Matrix4x4f(ret);
    }

    public static final Matrix4x4f matrixProjectionRH(float fov, float aspect, float near_z, float far_z) {
        float xscale;
        float[] ret = new float[16];
        float yscale = 1.0f / (float)Math.tan(fov * 0.5f);
        float t = 1.0f / (far_z - near_z);
        ret[0] = xscale = yscale / aspect;
        ret[5] = yscale;
        ret[10] = far_z * t;
        ret[14] = -near_z * far_z * t;
        ret[11] = -1.0f;
        return new Matrix4x4f(ret);
    }

    public static final Matrix4x4f matrixTranslate(float x, float y, float z) {
        float[] ret = new float[16];
        ret[0] = 1.0f;
        ret[5] = 1.0f;
        ret[10] = 1.0f;
        ret[15] = 1.0f;
        ret[12] = x;
        ret[13] = y;
        ret[14] = z;
        return new Matrix4x4f(ret);
    }

    public static final Matrix4x4f matrixScale(float x, float y, float z) {
        float[] ret = new float[16];
        ret[0] = x;
        ret[5] = y;
        ret[10] = z;
        ret[15] = 1.0f;
        return new Matrix4x4f(ret);
    }

    public static final Matrix4x4f matrixUniformScale(float s) {
        float[] ret = new float[16];
        ret[0] = s;
        ret[5] = s;
        ret[10] = s;
        ret[15] = 1.0f;
        return new Matrix4x4f(ret);
    }

    public static final Matrix4x4f matrixRotateX(float a) {
        float cs;
        float[] ret = new float[16];
        float sn = (float)Math.sin(a);
        ret[5] = cs = (float)Math.cos(a);
        ret[6] = sn;
        ret[9] = -sn;
        ret[10] = cs;
        ret[0] = 1.0f;
        ret[15] = 1.0f;
        return new Matrix4x4f(ret);
    }

    public static final Matrix4x4f matrixRotateY(float a) {
        float cs;
        float[] ret = new float[16];
        float sn = (float)Math.sin(a);
        ret[0] = cs = (float)Math.cos(a);
        ret[2] = -sn;
        ret[8] = sn;
        ret[10] = cs;
        ret[5] = 1.0f;
        ret[15] = 1.0f;
        return new Matrix4x4f(ret);
    }

    public static final Matrix4x4f matrixRotateZ(float a) {
        float cs;
        float[] ret = new float[16];
        float sn = (float)Math.sin(a);
        ret[0] = cs = (float)Math.cos(a);
        ret[1] = sn;
        ret[4] = -sn;
        ret[5] = cs;
        ret[10] = 1.0f;
        ret[15] = 1.0f;
        return new Matrix4x4f(ret);
    }
}

