/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils;

import java.util.ArrayList;

public class ElapsedTime {
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private final ArrayList<Long> runs = new ArrayList();

    public ElapsedTime reset() {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.runs.clear();
        return this;
    }

    public ElapsedTime measure(Runnable r) {
        return this.measure(r, 1);
    }

    public ElapsedTime measure(Runnable r, int runs) {
        for (int i = 0; i < runs; ++i) {
            System.gc();
            long t0 = System.nanoTime();
            r.run();
            long t1 = System.nanoTime();
            long t = t1 - t0;
            this.min = Math.min(this.min, t);
            this.max = Math.max(this.max, t);
            this.runs.add(t);
        }
        return this;
    }

    public String toString() {
        long sum = 0L;
        for (long l : this.runs) {
            sum += l;
        }
        return String.format("Min: %g, max: %g, avg: %g, tot: %g", (double)this.min * 1.0E-9, (double)this.max * 1.0E-9, (double)sum * 1.0E-9 / (double)this.runs.size(), (double)sum * 1.0E-9);
    }
}

