/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.audio;

import com.github.rjeschke.neetutils.audio.Clipper;
import com.github.rjeschke.neetutils.audio.DefaultClipper;
import com.github.rjeschke.neetutils.audio.DefaultGainModifier;
import com.github.rjeschke.neetutils.audio.GainModifier;

public class LPF6dBG {
    private final double fs;
    private double f;
    private double b = 0.0;
    private double t = 1.0;
    private Clipper clipper = new DefaultClipper();
    private GainModifier gainModifier = new DefaultGainModifier();

    public LPF6dBG(double fs) {
        this.fs = fs;
        this.setCutoff(fs * 0.1);
    }

    public void reset() {
        this.b = 0.0;
        this.t = 1.0;
    }

    public void setCutoff(double freq) {
        this.f = Math.tan(Math.PI * freq / this.fs);
    }

    public double coef(double previous) {
        return previous * this.t * this.f / (1.0 + this.t * this.f);
    }

    public double output(double input) {
        return (this.b + this.t * this.f * input) / (1.0 + this.t * this.f);
    }

    public double process(double input) {
        double o = (this.b + this.f * this.t * input) / (1.0 + this.t * this.f);
        double in = input - o;
        this.b = this.clipper.clip(o + this.t * this.f * in);
        this.t = this.gainModifier.calculateGain(in);
        return o;
    }

    public LPF6dBG setClipper(Clipper clipper) {
        this.clipper = clipper;
        return this;
    }

    public LPF6dBG setGainModifier(GainModifier gainModifier) {
        this.gainModifier = gainModifier;
        return this;
    }
}

